/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.ex.ErrorStripeAdapter;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.List;

public class ErrorStripeHandler
extends ErrorStripeAdapter {
    private final Project myProject;

    public ErrorStripeHandler(Project project) {
        this.myProject = project;
    }

    @Override
    public void errorMarkerClicked(ErrorStripeEvent e) {
        RangeHighlighter highlighter = e.getHighlighter();
        if (!highlighter.isValid()) {
            return;
        }
        HighlightInfo info = this.findInfo(highlighter);
        if (info != null) {
            GotoNextErrorHandler.navigateToError(this.myProject, e.getEditor(), info);
        }
    }

    private HighlightInfo findInfo(RangeHighlighter highlighter) {
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(highlighter.getDocument(), this.myProject);
        if (highlights == null) {
            return null;
        }
        for (HighlightInfo info : highlights) {
            if (info.highlighter != highlighter) continue;
            return info;
        }
        return null;
    }
}

