/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithTryFinallySurrounder
extends JavaStatementsSurrounder {
    JavaWithTryFinallySurrounder() {
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text = "try{\n}finally{\n}";
        PsiTryStatement tryStatement = (PsiTryStatement)factory.createStatementFromText(text, null);
        tryStatement = (PsiTryStatement)codeStyleManager.reformat((PsiElement)tryStatement);
        tryStatement = (PsiTryStatement)container.addAfter((PsiElement)tryStatement, statements[statements.length - 1]);
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        tryBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        int offset = finallyBlock.getTextRange().getStartOffset() + 1;
        return new TextRange(offset, offset);
    }
}

