/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.jikes;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesConfigurable;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesConfiguration;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesOutputParser;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesSettings;
import com.intellij.compiler.options.CompilerConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JikesCompiler
extends ExternalCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.JikesHandler");
    private final Project myProject;
    private File myTempFile;

    public JikesCompiler(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        File file;
        String compilerPath = this.getCompilerPath();
        if (compilerPath == null) {
            Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"jikes.error.path.to.compiler.unspecified", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.jikes.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            this.openConfigurationDialog();
            compilerPath = this.getCompilerPath();
            if (compilerPath == null) {
                return false;
            }
        }
        if (!(file = new File(compilerPath)).exists()) {
            Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"jikes.error.path.to.compiler.missing", (Object[])new Object[]{compilerPath}), (String)CompilerBundle.message((String)"compiler.jikes.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            this.openConfigurationDialog();
            compilerPath = this.getCompilerPath();
            if (compilerPath == null) {
                return false;
            }
            if (!new File(compilerPath).exists()) {
                return false;
            }
        }
        return true;
    }

    private void openConfigurationDialog() {
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)CompilerConfigurable.getInstance(this.myProject));
    }

    private String getCompilerPath() {
        return JikesConfiguration.getSettings((Project)this.myProject).JIKES_PATH.replace('/', File.separatorChar);
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("Jikes" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.getId must not return null");
        }
        return "Jikes";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.jikes.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.getPresentableName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        JikesConfigurable jikesConfigurable = new JikesConfigurable(JikesConfiguration.getSettings(this.myProject));
        if (jikesConfigurable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.createConfigurable must not return null");
        }
        return jikesConfigurable;
    }

    @Override
    public OutputParser createErrorParser(@NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.createErrorParser must not be null");
        }
        return new JikesOutputParser(this.myProject);
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.createOutputParser must not be null");
        }
        return null;
    }

    @Override
    @NotNull
    public String[] createStartupCommand(final ModuleChunk chunk, CompileContext context, final String outputPath) throws IOException {
        final ArrayList commandLine = new ArrayList();
        final IOException[] ex = new IOException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    JikesCompiler.this._createStartupCommand(chunk, commandLine, outputPath);
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        String[] stringArray = ArrayUtil.toStringArray(commandLine);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler.createStartupCommand must not return null");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createStartupCommand(ModuleChunk chunk, ArrayList<String> commandLine, @NotNull String outputPath) throws IOException {
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/jikes/JikesCompiler._createStartupCommand must not be null");
        }
        this.myTempFile = File.createTempFile("jikes", ".tmp");
        this.myTempFile.deleteOnExit();
        List<VirtualFile> files = chunk.getFilesToCompile();
        PrintWriter writer = new PrintWriter(new FileWriter(this.myTempFile));
        try {
            for (VirtualFile file : files) {
                writer.println(file.getPath());
            }
        }
        finally {
            writer.close();
        }
        String compilerPath = this.getCompilerPath();
        LOG.assertTrue(compilerPath != null, (Object)"No path to compiler configured");
        commandLine.add(compilerPath);
        commandLine.add("-verbose");
        commandLine.add("-classpath");
        commandLine.add(chunk.getCompilationBootClasspath() + File.pathSeparator + chunk.getCompilationClasspath());
        JikesCompiler.setupSourceVersion(chunk, commandLine);
        commandLine.add("-sourcepath");
        String sourcePath = chunk.getSourcePath();
        if (sourcePath.length() > 0) {
            commandLine.add(sourcePath);
        } else {
            commandLine.add("\"\"");
        }
        commandLine.add("-d");
        commandLine.add(outputPath.replace('/', File.separatorChar));
        JikesSettings jikesSettings = JikesConfiguration.getSettings(this.myProject);
        StringTokenizer tokenizer = new StringTokenizer(jikesSettings.getOptionsString(), " ");
        while (tokenizer.hasMoreTokens()) {
            commandLine.add(tokenizer.nextToken());
        }
        commandLine.add("@" + this.myTempFile.getAbsolutePath());
    }

    private static void setupSourceVersion(ModuleChunk chunk, ArrayList<String> commandLine) {
        Sdk jdk = chunk.getJdk();
        String versionString = jdk.getVersionString();
        LanguageLevel applicableLanguageLevel = CompilerUtil.getApplicableLanguageLevel(versionString, chunk.getLanguageLevel());
        if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_5)) {
            commandLine.add("-source");
            commandLine.add("1.4");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_4)) {
            commandLine.add("-source");
            commandLine.add("1.4");
        }
    }

    @Override
    public void compileFinished() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
            this.myTempFile = null;
        }
    }
}

