/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectRunConfigurationManager", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/runConfigurations/", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=RunConfigurationStateSplitter.class)})
public class ProjectRunConfigurationManager
implements ProjectComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.ProjectRunConfigurationManager");
    private final RunManagerImpl myManager;
    private List<Element> myUnloadedElements = null;

    public ProjectRunConfigurationManager(RunManagerImpl manager) {
        this.myManager = manager;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ProjectRunConfigurationManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/ProjectRunConfigurationManager.getComponentName must not return null");
        }
        return "ProjectRunConfigurationManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myUnloadedElements = null;
        HashSet existing = new HashSet();
        List children = element.getChildren();
        for (Object child : children) {
            RunnerAndConfigurationSettingsImpl configuration = this.myManager.loadConfiguration((Element)child, true);
            if (configuration == null && Comparing.strEqual((String)element.getName(), (String)"configuration")) {
                if (this.myUnloadedElements == null) {
                    this.myUnloadedElements = new ArrayList<Element>(2);
                }
                this.myUnloadedElements.add(element);
            }
            if (configuration == null) continue;
            existing.add(RunManagerImpl.getUniqueName(configuration.getConfiguration()));
        }
        this.myManager.removeNotExistingSharedConfigurations((Set<String>)existing);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Collection<RunnerAndConfigurationSettingsImpl> configurations = this.myManager.getStableConfigurations().values();
        for (RunnerAndConfigurationSettingsImpl configuration : configurations) {
            if (!this.myManager.isConfigurationShared(configuration)) continue;
            this.myManager.addConfigurationElement(element, configuration);
        }
        if (this.myUnloadedElements != null) {
            for (Element unloadedElement : this.myUnloadedElements) {
                element.addContent((Element)unloadedElement.clone());
            }
        }
    }

    public static class RunConfigurationStateSplitter
    implements StateSplitter {
        public List<Pair<Element, String>> splitState(Element e) {
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            List list = e.getChildren();
            for (Object o : list) {
                Element library = (Element)o;
                String name = generator.generateUniqueName(FileUtil.sanitizeFileName((String)library.getAttributeValue("name"))) + ".xml";
                result.add((Pair<Element, String>)new Pair((Object)library, (Object)name));
            }
            return result;
        }

        public void mergeStatesInto(Element target, Element[] elements) {
            for (Element e : elements) {
                target.addContent(e);
            }
        }
    }
}

