/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SuiteInProgressState
extends TestInProgressState {
    private final SMTestProxy mySuiteProxy;
    private Boolean isDefectWasReallyFound;

    public SuiteInProgressState(@NotNull SMTestProxy suiteProxy) {
        if (suiteProxy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/states/SuiteInProgressState.<init> must not be null");
        }
        this.isDefectWasReallyFound = null;
        this.mySuiteProxy = suiteProxy;
    }

    @Override
    public boolean isDefect() {
        if (this.isDefectWasReallyFound != null) {
            return this.isDefectWasReallyFound;
        }
        List<? extends SMTestProxy> children = this.mySuiteProxy.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (!sMTestProxy.isDefect()) continue;
            this.isDefectWasReallyFound = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }

    @Override
    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.RUNNING_INDEX;
    }

    @Override
    public String toString() {
        return "SUITE PROGRESS";
    }
}

