/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.FacetType;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionByTypeElement;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionInModuleElement;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnableAutodetectionWorker {
    private final MultiValuesMap<FacetType<?, ?>, Module> myModulesToProcess;
    private final MultiValuesMap<FacetType<?, ?>, VirtualFile> myFilesToProcess;
    private final Project myProject;
    private final FacetAutodetectingManagerImpl myFacetAutodetectingManager;

    public EnableAutodetectionWorker(@NotNull Project project, FacetAutodetectingManagerImpl facetAutodetectingManager) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/EnableAutodetectionWorker.<init> must not be null");
        }
        this.myModulesToProcess = new MultiValuesMap();
        this.myFilesToProcess = new MultiValuesMap();
        this.myProject = project;
        this.myFacetAutodetectingManager = facetAutodetectingManager;
    }

    public void addFile(@NotNull FacetType<?, ?> type, @NotNull String url) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/EnableAutodetectionWorker.addFile must not be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/EnableAutodetectionWorker.addFile must not be null");
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            this.myFilesToProcess.put(type, (Object)file);
        }
    }

    public void queueChanges(@NotNull FacetType<?, ?> facetType, @Nullable DisabledAutodetectionByTypeElement oldElement, @Nullable DisabledAutodetectionByTypeElement newElement) {
        Module module;
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/EnableAutodetectionWorker.queueChanges must not be null");
        }
        if (oldElement == null || newElement != null && newElement.getModuleElements().isEmpty()) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        ArrayList<Module> modulesToProcess = new ArrayList<Module>();
        List<DisabledAutodetectionInModuleElement> moduleElements = oldElement.getModuleElements();
        for (DisabledAutodetectionInModuleElement moduleElement : moduleElements) {
            if (moduleElement.isDisableInWholeModule()) {
                module = moduleManager.findModuleByName(moduleElement.getModuleName());
                if (module == null) continue;
                modulesToProcess.add(module);
                continue;
            }
            for (String url : moduleElement.getFiles()) {
                if (newElement != null && newElement.isDisabled(moduleElement.getModuleName(), url)) continue;
                this.addFile(facetType, url);
            }
            for (String directoryUrl : moduleElement.getDirectories()) {
                if (newElement != null && newElement.isDisabled(moduleElement.getModuleName(), directoryUrl)) continue;
                this.addFile(facetType, directoryUrl);
            }
        }
        if (moduleElements.isEmpty()) {
            modulesToProcess.addAll(Arrays.asList(moduleManager.getModules()));
        }
        if (newElement != null) {
            THashSet toRemove = new THashSet();
            for (DisabledAutodetectionInModuleElement moduleElement : newElement.getModuleElements()) {
                if (!moduleElement.isDisableInWholeModule()) continue;
                toRemove.add(moduleElement.getModuleName());
            }
            Iterator iterator = modulesToProcess.iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                if (!toRemove.contains(module.getName())) continue;
                iterator.remove();
            }
        }
        if (!modulesToProcess.isEmpty()) {
            this.myModulesToProcess.putAll(facetType, modulesToProcess);
        }
    }

    public void redetectFacets() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (FacetType type : EnableAutodetectionWorker.this.myModulesToProcess.keySet()) {
                    EnableAutodetectionWorker.this.detectFacetsInModules(type, EnableAutodetectionWorker.this.myModulesToProcess.get((Object)type));
                }
                EnableAutodetectionWorker.this.myModulesToProcess.clear();
                for (FacetType type : EnableAutodetectionWorker.this.myFilesToProcess.keySet()) {
                    EnableAutodetectionWorker.this.detectFacetsInFiles(type, EnableAutodetectionWorker.this.myFilesToProcess.get((Object)type));
                }
                EnableAutodetectionWorker.this.myFilesToProcess.clear();
            }
        }, ProjectBundle.message((String)"progress.text.detecting.facets", (Object[])new Object[0]), false, this.myProject);
        this.myFacetAutodetectingManager.getDetectedFacetManager().showDetectedFacetsDialog();
    }

    private void detectFacetsInModules(final FacetType<?, ?> type, Collection<Module> modules) {
        for (Module module : modules) {
            ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile file) {
                    EnableAutodetectionWorker.this.detectFacetsInFile(type, file);
                    return true;
                }
            });
        }
    }

    private void detectFacetsInFile(FacetType<?, ?> type, VirtualFile file) {
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.detectFacetsInFile(type, child);
            }
        } else {
            this.myFacetAutodetectingManager.processFile(file);
        }
    }

    private void detectFacetsInFiles(FacetType<?, ?> type, Collection<VirtualFile> virtualFiles) {
        for (VirtualFile file : virtualFiles) {
            this.detectFacetsInFile(type, file);
        }
    }

    @Nullable
    public Collection<Module> getModulesToProcess(FacetType<?, ?> facetType) {
        return this.myModulesToProcess.get(facetType);
    }

    @Nullable
    public Collection<VirtualFile> getFilesToProcess(FacetType<?, ?> facetType) {
        return this.myFilesToProcess.get(facetType);
    }
}

