/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindProgressIndicator;
import com.intellij.find.FindResult;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.FileIndexImplUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectUtil {
    private static final int USAGES_LIMIT = 1000;
    private static final int FILES_SIZE_LIMIT = 0x4600000;
    private static final int SINGLE_FILE_SIZE_LIMIT = 0x500000;

    private FindInProjectUtil() {
    }

    public static void setDirectoryName(FindModel model, DataContext dataContext) {
        Module module;
        PsiElement psiElement;
        try {
            psiElement = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        catch (IndexNotReadyException e) {
            psiElement = null;
        }
        String directoryName = null;
        if (psiElement instanceof PsiDirectory) {
            directoryName = ((PsiDirectory)psiElement).getVirtualFile().getPresentableUrl();
        } else {
            PsiDirectory psiDirectory;
            PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
            if (psiFile != null && (psiDirectory = psiFile.getContainingDirectory()) != null) {
                directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
            }
        }
        if (directoryName == null && psiElement instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)psiElement).getDirectories();
            String string = directoryName = directories.length == 1 ? directories[0].getVirtualFile().getPresentableUrl() : null;
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null) {
            model.setModuleName(module.getName());
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (model.getModuleName() == null || editor == null) {
            model.setDirectoryName(directoryName);
            model.setProjectScope(directoryName == null && module == null && model.getCustomScopeName() == null || editor != null);
        }
    }

    @Nullable
    public static PsiDirectory getPsiDirectory(FindModel findModel, Project project) {
        String directoryName = findModel.getDirectoryName();
        if (findModel.isProjectScope() || directoryName == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String path = directoryName.replace(File.separatorChar, '/');
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            if (!path.contains("!/")) {
                path = path + "!/";
            }
            virtualFile = JarFileSystem.getInstance().findFileByPath(path);
        }
        return virtualFile == null ? null : psiManager.findDirectory(virtualFile);
    }

    private static void addFilesUnderDirectory(PsiDirectory directory, Collection<PsiFile> fileList, boolean isRecursive, Pattern fileMaskRegExp) {
        PsiElement[] children;
        for (PsiElement child : children = directory.getChildren()) {
            if (child instanceof PsiFile && (fileMaskRegExp == null || fileMaskRegExp.matcher(((PsiFile)child).getName()).matches())) {
                PsiFile file = (PsiFile)child;
                PsiFile sourceFile = (PsiFile)file.getNavigationElement();
                if (sourceFile != null) {
                    file = sourceFile;
                }
                fileList.add(file);
                continue;
            }
            if (!isRecursive || !(child instanceof PsiDirectory)) continue;
            FindInProjectUtil.addFilesUnderDirectory((PsiDirectory)child, fileList, isRecursive, fileMaskRegExp);
        }
    }

    @NotNull
    public static List<UsageInfo> findUsages(FindModel findModel, PsiDirectory psiDirectory, Project project) {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        FindInProjectUtil.findUsages(findModel, psiDirectory, project, (Processor<UsageInfo>)collector);
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>(collector.getResults());
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindInProjectUtil.findUsages must not return null");
        }
        return arrayList;
    }

    @Nullable
    private static Pattern createFileMaskRegExp(FindModel findModel) {
        String filter = findModel.getFileFilter();
        return FindInProjectUtil.createFileMaskRegExp(filter);
    }

    public static Pattern createFileMaskRegExp(String filter) {
        if (filter == null) {
            return null;
        }
        Object[] strings = filter.split(",");
        String pattern = strings.length == 1 ? PatternUtil.convertToRegex((String)filter.trim()) : StringUtil.join((Object[])strings, (Function)new Function<String, String>(){

            public String fun(String s) {
                return "(" + PatternUtil.convertToRegex((String)s.trim()) + ")";
            }
        }, (String)"|");
        return Pattern.compile(pattern, 2);
    }

    public static void findUsages(FindModel findModel, PsiDirectory psiDirectory, final Project project, Processor<UsageInfo> consumer) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        Collection<PsiFile> psiFiles = FindInProjectUtil.getFilesToSearchIn(findModel, project, psiDirectory);
        try {
            final SearchScope customScope = findModel.getCustomScope();
            THashSet largeFiles = new THashSet();
            int i = 0;
            long totalFilesSize = 0L;
            int count = 0;
            boolean warningShown = false;
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            for (final PsiFile psiFile : psiFiles) {
                int countInFile;
                long fileLength;
                usageViewManager.checkSearchCanceled();
                if (customScope != null && !((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        return PsiSearchScopeUtil.isInScope((SearchScope)customScope, (PsiElement)psiFile);
                    }
                })).booleanValue()) continue;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                int index = i++;
                if (virtualFile == null || (fileLength = FindInProjectUtil.getFileLength(virtualFile)) == -1L || ProjectUtil.isProjectOrWorkspaceFile(virtualFile)) continue;
                if (fileLength > 0x500000L) {
                    largeFiles.add(psiFile);
                    continue;
                }
                if (progress != null) {
                    progress.setFraction((double)index / (double)psiFiles.size());
                    String text = FindBundle.message("find.searching.for.string.in.file.progress", findModel.getStringToFind(), virtualFile.getPresentableUrl());
                    progress.setText(text);
                    progress.setText2(FindBundle.message("find.searching.for.string.in.file.occurrences.progress", count));
                }
                if ((countInFile = FindInProjectUtil.processUsagesInFile(psiFile, findModel, consumer)) > 0 && (totalFilesSize += fileLength) > 0x4600000L && !warningShown) {
                    FindInProjectUtil.showTooManyUsagesWaring(project, FindBundle.message("find.excessive.total.size.prompt", FindInProjectUtil.presentableSize(totalFilesSize), ApplicationNamesInfo.getInstance().getProductName()));
                    warningShown = true;
                }
                if ((count += countInFile) <= 1000 || warningShown) continue;
                FindInProjectUtil.showTooManyUsagesWaring(project, FindBundle.message("find.excessive.usage.count.prompt", count));
                warningShown = true;
            }
            if (!largeFiles.isEmpty()) {
                final StringBuilder message = new StringBuilder();
                message.append("<html><body>");
                if (largeFiles.size() == 1) {
                    VirtualFile vFile = ((PsiFile)largeFiles.iterator().next()).getVirtualFile();
                    message.append("File '").append(FindInProjectUtil.getPresentablePath(vFile)).append("'&nbsp;(").append(FindInProjectUtil.presentableSize(FindInProjectUtil.getFileLength(vFile))).append(") is ");
                } else {
                    message.append("Files<br> ");
                    int counter = 0;
                    for (PsiFile file : largeFiles) {
                        VirtualFile vFile = file.getVirtualFile();
                        message.append(FindInProjectUtil.getPresentablePath(vFile)).append("&nbsp;(").append(FindInProjectUtil.presentableSize(FindInProjectUtil.getFileLength(vFile))).append(")<br> ");
                        if (counter++ <= 10) continue;
                        break;
                    }
                    message.append("are ");
                }
                message.append("too large and cannot be scanned</body></html>");
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowManager.getInstance((Project)project).notifyByBalloon(ToolWindowId.FIND, MessageType.WARNING, message.toString());
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            // empty catch block
        }
        if (progress != null) {
            progress.setText(FindBundle.message("find.progress.search.completed", new Object[0]));
        }
    }

    private static int processUsagesInFile(final PsiFile psiFile, final FindModel findModel, final Processor<UsageInfo> consumer) {
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                if (psiFile.isValid()) {
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (FileTypeManager.getInstance().getFileTypeByFile(virtualFile).isBinary()) {
                        return 0;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    if (document != null) {
                        return FindInProjectUtil.addToUsages(document, (Processor<UsageInfo>)consumer, findModel, psiFile);
                    }
                }
                return 0;
            }
        });
    }

    private static String getPresentablePath(final VirtualFile virtualFile) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return virtualFile.getPresentableUrl();
            }
        });
    }

    private static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        return FindBundle.message("find.file.size.megabytes", Long.toString(megabytes));
    }

    private static long getFileLength(final VirtualFile virtualFile) {
        final long[] length = new long[]{-1L};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!virtualFile.isValid()) {
                    return;
                }
                if (FileTypeManager.getInstance().getFileTypeByFile(virtualFile).isBinary()) {
                    return;
                }
                length[0] = virtualFile.getLength();
            }
        });
        return length[0];
    }

    private static void showTooManyUsagesWaring(final Project project, final String message) {
        int retCode = FindInProjectUtil.invokeAndWait(new Computable<Integer>(){

            public Integer compute() {
                return Messages.showYesNoDialog((Project)project, (String)message, (String)FindBundle.message("find.excessive.usages.title", new Object[0]), (Icon)Messages.getWarningIcon());
            }
        });
        if (retCode != 0) {
            throw new ProcessCanceledException();
        }
    }

    private static int invokeAndWait(final Computable<Integer> f) {
        final int[] answer = new int[1];
        try {
            GuiUtils.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    answer[0] = (Integer)f.compute();
                }
            });
        }
        catch (Exception e) {
            answer[0] = 0;
        }
        return answer[0];
    }

    private static int showMessage(final Project project, final String message, final String title, final String[] buttons) {
        return FindInProjectUtil.invokeAndWait(new Computable<Integer>(){

            public Integer compute() {
                return Messages.showDialog((Project)project, (String)message, (String)title, (String[])buttons, (int)0, (Icon)Messages.getWarningIcon());
            }
        });
    }

    private static Collection<PsiFile> getFilesToSearchIn(final FindModel findModel, final Project project, final PsiDirectory psiDirectory) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiFile>>(){

            public Collection<PsiFile> compute() {
                return FindInProjectUtil.getFilesToSearchInReadAction(findModel, project, psiDirectory);
            }
        });
    }

    private static Collection<PsiFile> getFilesToSearchInReadAction(FindModel findModel, final Project project, PsiDirectory psiDirectory) {
        ProjectFileIndex fileIndex;
        String moduleName = findModel.getModuleName();
        Module module = moduleName == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        Object object = fileIndex = module == null ? ProjectRootManager.getInstance((Project)project).getFileIndex() : ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (psiDirectory == null || findModel.isWithSubdirectories() && fileIndex.isInContent(psiDirectory.getVirtualFile())) {
            final Pattern fileMaskRegExp = FindInProjectUtil.createFileMaskRegExp(findModel);
            Pair<Boolean, Collection<PsiFile>> fastWords = FindInProjectUtil.getFilesForFastWordSearch(findModel, project, psiDirectory, fileMaskRegExp, module);
            final Collection filesForFastWordSearch = (Collection)fastWords.getSecond();
            if (((Boolean)fastWords.getFirst()).booleanValue() && FindInProjectUtil.canOptimizeForFastWordSearch(findModel)) {
                return filesForFastWordSearch;
            }
            class EnumContentIterator
            implements ContentIterator {
                final List<PsiFile> myFiles;
                final PsiManager psiManager;

                EnumContentIterator() {
                    this.myFiles = new ArrayList<PsiFile>(filesForFastWordSearch);
                    this.psiManager = PsiManager.getInstance((Project)project);
                }

                public boolean processFile(VirtualFile virtualFile) {
                    PsiFile psiFile;
                    if (!(virtualFile.isDirectory() || fileMaskRegExp != null && !fileMaskRegExp.matcher(virtualFile.getName()).matches() || (psiFile = this.psiManager.findFile(virtualFile)) == null || filesForFastWordSearch.contains(psiFile))) {
                        this.myFiles.add(psiFile);
                    }
                    return true;
                }

                private Collection<PsiFile> getFiles() {
                    return this.myFiles;
                }
            }
            EnumContentIterator iterator = new EnumContentIterator();
            if (psiDirectory == null) {
                boolean success = fileIndex.iterateContent((ContentIterator)iterator);
                SearchScope customScope = findModel.getCustomScope();
                if (success && customScope instanceof GlobalSearchScope && ((GlobalSearchScope)customScope).isSearchInLibraries()) {
                    Module[] modules;
                    Module[] moduleArray;
                    THashSet librarySources = new THashSet();
                    if (module == null) {
                        moduleArray = ModuleManager.getInstance((Project)project).getModules();
                    } else {
                        Module[] moduleArray2 = new Module[1];
                        moduleArray = moduleArray2;
                        moduleArray2[0] = module;
                    }
                    for (Module mod : modules = moduleArray) {
                        ModuleRootManager.getInstance((Module)mod).processOrder((RootPolicy)new RootPolicy<Object>((Collection)librarySources){
                            final /* synthetic */ Collection val$librarySources;
                            {
                                this.val$librarySources = collection;
                            }

                            public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
                                VirtualFile[] sources = libraryOrderEntry.getFiles(OrderRootType.SOURCES);
                                this.val$librarySources.addAll(Arrays.asList(sources));
                                return null;
                            }

                            public Object visitJdkOrderEntry(JdkOrderEntry jdkOrderEntry, Object value) {
                                VirtualFile[] sources = jdkOrderEntry.getFiles(OrderRootType.SOURCES);
                                this.val$librarySources.addAll(Arrays.asList(sources));
                                return null;
                            }
                        }, null);
                    }
                    FindInProjectUtil.iterateAll((Collection<VirtualFile>)librarySources, (GlobalSearchScope)customScope, iterator);
                }
            } else {
                fileIndex.iterateContentUnderDirectory(psiDirectory.getVirtualFile(), (ContentIterator)iterator);
            }
            return iterator.getFiles();
        }
        THashSet fileList = new THashSet();
        FindInProjectUtil.addFilesUnderDirectory(psiDirectory, (Collection<PsiFile>)fileList, findModel.isWithSubdirectories(), FindInProjectUtil.createFileMaskRegExp(findModel));
        return fileList;
    }

    private static boolean iterateAll(Collection<VirtualFile> files, final GlobalSearchScope searchScope, ContentIterator iterator) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VirtualFileFilter contentFilter = new VirtualFileFilter(){

            public boolean accept(VirtualFile file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (fileTypeManager.isFileIgnored(file.getName()) || fileTypeManager.getFileTypeByFile(file).isBinary()) {
                    return false;
                }
                return searchScope.contains(file);
            }
        };
        for (VirtualFile file : files) {
            if (FileIndexImplUtil.iterateRecursively((VirtualFile)file, (VirtualFileFilter)contentFilter, (ContentIterator)iterator)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Pair<Boolean, Collection<PsiFile>> getFilesForFastWordSearch(FindModel findModel, Project project, PsiDirectory psiDirectory, Pattern fileMaskRegExp, Module module) {
        Pair pair;
        if (DumbService.getInstance((Project)project).isDumb()) {
            pair = new Pair((Object)false, Collections.emptyList());
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindInProjectUtil.getFilesForFastWordSearch must not return null");
            return pair;
        }
        PsiManager pm = PsiManager.getInstance((Project)project);
        CacheManager cacheManager = ((PsiManagerEx)pm).getCacheManager();
        SearchScope customScope = findModel.getCustomScope();
        GlobalSearchScope scope = psiDirectory != null ? GlobalSearchScope.directoryScope((PsiDirectory)psiDirectory, (boolean)true) : (module != null ? FindInProjectUtil.moduleContentScope(module) : (customScope instanceof GlobalSearchScope ? (GlobalSearchScope)customScope : GlobalSearchScope.projectScope((Project)project)));
        THashSet keys = new THashSet(30);
        THashSet resultFiles = new THashSet();
        boolean fast = false;
        if (TrigramIndex.ENABLED) {
            TIntHashSet trigrams = TrigramBuilder.buildTrigram((CharSequence)findModel.getStringToFind());
            TIntIterator it = trigrams.iterator();
            while (it.hasNext()) {
                keys.add(it.next());
            }
            if (!keys.isEmpty()) {
                fast = true;
                ArrayList hits = new ArrayList();
                FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, keys, (Processor<VirtualFile>)new CommonProcessors.CollectProcessor(hits), scope);
                for (VirtualFile hit : hits) {
                    resultFiles.add(pm.findFile(hit));
                }
                FindInProjectUtil.filterMaskedFiles((Set<PsiFile>)resultFiles, fileMaskRegExp);
                if (resultFiles.isEmpty()) {
                    pair = new Pair((Object)true, (Object)resultFiles);
                    if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindInProjectUtil.getFilesForFastWordSearch must not return null");
                    return pair;
                }
            }
        }
        fast |= findModel.isWholeWordsOnly() && findModel.getStringToFind().indexOf(36) < 0;
        List words = StringUtil.getWordsIn((String)findModel.getStringToFind());
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        for (int i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            PsiFile[] files = cacheManager.getFilesWithWord(word, (short)255, scope, findModel.isCaseSensitive());
            if (files.length == 0) {
                resultFiles.clear();
                break;
            }
            List<PsiFile> psiFiles = Arrays.asList(files);
            if (i == 0 && keys.isEmpty()) {
                resultFiles.addAll(psiFiles);
            } else {
                resultFiles.retainAll(psiFiles);
            }
            FindInProjectUtil.filterMaskedFiles((Set<PsiFile>)resultFiles, fileMaskRegExp);
            if (resultFiles.isEmpty()) break;
        }
        PsiFile[] allWordsFiles = cacheManager.getFilesWithWord(findModel.getStringToFind(), (short)255, scope, findModel.isCaseSensitive());
        resultFiles.addAll(Arrays.asList(allWordsFiles));
        FindInProjectUtil.filterMaskedFiles((Set<PsiFile>)resultFiles, fileMaskRegExp);
        pair = new Pair((Object)fast, (Object)resultFiles);
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindInProjectUtil.getFilesForFastWordSearch must not return null");
    }

    private static GlobalSearchScope moduleContentScope(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        GlobalSearchScope result = null;
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (VirtualFile root : contentRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            GlobalSearchScope moduleContent = GlobalSearchScope.directoryScope((PsiDirectory)directory, (boolean)true);
            result = result == null ? moduleContent : result.uniteWith(moduleContent);
        }
        if (result == null) {
            result = GlobalSearchScope.EMPTY_SCOPE;
        }
        return result;
    }

    private static void filterMaskedFiles(Set<PsiFile> resultFiles, Pattern fileMaskRegExp) {
        if (fileMaskRegExp != null) {
            Iterator<PsiFile> iterator = resultFiles.iterator();
            while (iterator.hasNext()) {
                PsiFile file = iterator.next();
                if (fileMaskRegExp.matcher(file.getName()).matches()) continue;
                iterator.remove();
            }
        }
    }

    private static boolean canOptimizeForFastWordSearch(FindModel findModel) {
        return !findModel.isRegularExpressions() && (findModel.getCustomScope() == null || findModel.getCustomScope() instanceof GlobalSearchScope);
    }

    private static int addToUsages(@NotNull Document document, @NotNull Processor<UsageInfo> consumer, @NotNull FindModel findModel, @NotNull PsiFile psiFile) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindInProjectUtil.addToUsages must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindInProjectUtil.addToUsages must not be null");
        }
        if (findModel == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/impl/FindInProjectUtil.addToUsages must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/find/impl/FindInProjectUtil.addToUsages must not be null");
        }
        int count = 0;
        CharSequence text = document.getCharsSequence();
        if (text == null) {
            return 0;
        }
        int textLength = document.getTextLength();
        int offset = 0;
        Project project = psiFile.getProject();
        UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
        FindManager findManager = FindManager.getInstance((Project)project);
        while (offset < textLength) {
            usageViewManager.checkSearchCanceled();
            FindResult result = findManager.findString(text, offset, findModel, psiFile.getVirtualFile());
            if (!result.isStringFound()) break;
            UsageInfo info = new UsageInfo((PsiElement)psiFile, result.getStartOffset(), result.getEndOffset());
            consumer.process((Object)info);
            ++count;
            int prevOffset = offset;
            if (prevOffset != (offset = result.getEndOffset())) continue;
            ++offset;
        }
        return count;
    }

    private static String getTitleForScope(FindModel findModel) {
        String result = findModel.isProjectScope() ? FindBundle.message("find.scope.project.title", new Object[0]) : (findModel.getModuleName() != null ? FindBundle.message("find.scope.module.title", findModel.getModuleName()) : (findModel.getCustomScopeName() != null ? findModel.getCustomScopeName() : FindBundle.message("find.scope.directory.title", findModel.getDirectoryName())));
        if (findModel.getFileFilter() != null) {
            result = FindBundle.message("find.scope.files.with.mask", result, findModel.getFileFilter());
        }
        return result;
    }

    public static UsageViewPresentation setupViewPresentation(boolean toOpenInNewTab, FindModel findModelCopy) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scope = FindInProjectUtil.getTitleForScope(findModelCopy);
        String stringToFind = findModelCopy.getStringToFind();
        presentation.setScopeText(scope);
        presentation.setTabText(FindBundle.message("find.usage.view.tab.text", stringToFind));
        presentation.setToolwindowTitle(FindBundle.message("find.usage.view.toolwindow.title", stringToFind, scope));
        presentation.setUsagesString(FindBundle.message("find.usage.view.usages.text", stringToFind));
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setCodeUsages(false);
        return presentation;
    }

    public static boolean hasReadOnlyUsages(Collection<Usage> usages) {
        for (Usage usage : usages) {
            if (!usage.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public static FindUsagesProcessPresentation setupProcessPresentation(final Project project, boolean showPanelIfOnlyOneUsage, final UsageViewPresentation presentation) {
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation();
        processPresentation.setShowNotFoundMessage(true);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        processPresentation.setProgressIndicatorFactory((Factory)new Factory<ProgressIndicator>(){

            public ProgressIndicator create() {
                return new FindProgressIndicator(project, presentation.getScopeText());
            }
        });
        return processPresentation;
    }

    public static class StringUsageTarget
    implements UsageTarget {
        private final String myStringToFind;
        private final ItemPresentation myItemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return FindBundle.message("find.usage.target.string.text", StringUsageTarget.this.myStringToFind);
            }

            public String getLocationString() {
                return StringUsageTarget.this.myStringToFind + "!!";
            }

            public Icon getIcon(boolean open) {
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                return null;
            }
        };

        public StringUsageTarget(String _stringToFind) {
            this.myStringToFind = _stringToFind;
        }

        public void findUsages() {
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindInProjectUtil$StringUsageTarget.findUsagesInEditor must not be null");
            }
        }

        public void highlightUsages(PsiFile file, Editor editor, boolean clearHighlights) {
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        public String getName() {
            return this.myStringToFind;
        }

        public ItemPresentation getPresentation() {
            return this.myItemPresentation;
        }

        public FileStatus getFileStatus() {
            return FileStatus.NOT_CHANGED;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }
    }
}

