/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public abstract class SplitAction
extends AnAction
implements DumbAware {
    private final int myOrientation;

    protected SplitAction(int orientation) {
        this.myOrientation = orientation;
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow window = (EditorWindow)EditorWindow.DATA_KEY.getData(event.getDataContext());
        fileEditorManager.createSplitter(this.myOrientation, window);
    }

    public void update(AnActionEvent event) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        Presentation presentation = event.getPresentation();
        presentation.setText(this.myOrientation == 1 ? IdeBundle.message((String)"action.split.vertically", (Object[])new Object[0]) : IdeBundle.message((String)"action.split.horizontally", (Object[])new Object[0]));
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        presentation.setEnabled(fileEditorManager.hasOpenedFile());
    }
}

