/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

final class FileTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.todo.FileTree");
    private final HashMap<VirtualFile, ArrayList<VirtualFile>> myDirectory2Children = new HashMap();
    private final HashSet<VirtualFile> myFiles = new HashSet();
    private final HashMap<VirtualFile, ArrayList<VirtualFile>> myStrictDirectory2Children = new HashMap();

    FileTree() {
    }

    void add(VirtualFile file) {
        if (this.myFiles.contains(file)) {
            return;
        }
        this.myFiles.add(file);
        VirtualFile dir = file.getParent();
        LOG.assertTrue(dir != null);
        ArrayList<VirtualFile> children = (ArrayList<VirtualFile>)this.myStrictDirectory2Children.get((Object)dir);
        if (children != null) {
            LOG.assertTrue(!children.contains(file));
            children.add(file);
        } else {
            children = new ArrayList<VirtualFile>(2);
            children.add(file);
            this.myStrictDirectory2Children.put((Object)dir, children);
        }
        children = (ArrayList<VirtualFile>)this.myDirectory2Children.get((Object)dir);
        if (children != null) {
            LOG.assertTrue(!children.contains(file));
            children.add(file);
            return;
        }
        children = new ArrayList<VirtualFile>(2);
        children.add(file);
        this.myDirectory2Children.put((Object)dir, children);
        for (VirtualFile parent = dir.getParent(); parent != null; parent = parent.getParent()) {
            children = (ArrayList<VirtualFile>)this.myDirectory2Children.get((Object)parent);
            if (children != null) {
                if (!children.contains(dir)) {
                    children.add(dir);
                }
                return;
            }
            children = new ArrayList<VirtualFile>(2);
            children.add(dir);
            this.myDirectory2Children.put((Object)parent, children);
            dir = parent;
        }
    }

    boolean isDirectoryEmpty(VirtualFile dir) {
        ArrayList files = (ArrayList)this.myStrictDirectory2Children.get((Object)dir);
        return files == null || files.isEmpty();
    }

    ArrayList<VirtualFile> getFilesUnderDirectory(VirtualFile dir) {
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        ArrayList files = (ArrayList)this.myStrictDirectory2Children.get((Object)dir);
        if (files != null) {
            filesList.addAll(files);
        }
        return filesList;
    }

    void removeFile(VirtualFile file) {
        ArrayList children;
        if (!this.myFiles.contains(file)) {
            return;
        }
        this.myFiles.remove(file);
        ArrayList<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children = (ArrayList)this.myDirectory2Children.get((Object)_directory);
            LOG.assertTrue(children != null);
            if (!children.contains(file)) continue;
            children.remove(file);
            if (children.size() != 0) continue;
            if (dirsToBeRemoved == null) {
                dirsToBeRemoved = new ArrayList<VirtualFile>(2);
            }
            dirsToBeRemoved.add(_directory);
        }
        for (VirtualFile dir : this.myStrictDirectory2Children.keySet()) {
            children = (ArrayList)this.myStrictDirectory2Children.get((Object)dir);
            LOG.assertTrue(children != null);
            if (!children.contains(file)) continue;
            children.remove(file);
        }
        if (dirsToBeRemoved != null) {
            LOG.assertTrue(dirsToBeRemoved.size() > 0);
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    private void removeDir(VirtualFile psiDirectory) {
        if (!this.myDirectory2Children.containsKey((Object)psiDirectory)) {
            throw new IllegalArgumentException("directory is not in the tree: " + psiDirectory);
        }
        ArrayList children = (ArrayList)this.myDirectory2Children.remove((Object)psiDirectory);
        if (children == null) {
            throw new IllegalArgumentException("directory has no children list: " + psiDirectory);
        }
        if (children.size() > 0) {
            throw new IllegalArgumentException("directory isn't empty: " + psiDirectory);
        }
        this.myStrictDirectory2Children.remove((Object)psiDirectory);
        ArrayList<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children = (ArrayList)this.myDirectory2Children.get((Object)_directory);
            LOG.assertTrue(children != null);
            if (!children.contains(psiDirectory)) continue;
            children.remove(psiDirectory);
            if (children.size() != 0) continue;
            if (dirsToBeRemoved == null) {
                dirsToBeRemoved = new ArrayList<VirtualFile>(2);
            }
            dirsToBeRemoved.add(_directory);
        }
        if (dirsToBeRemoved != null) {
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    boolean contains(VirtualFile file) {
        return this.myFiles.contains(file);
    }

    void clear() {
        this.myStrictDirectory2Children.clear();
        this.myDirectory2Children.clear();
        this.myFiles.clear();
    }

    Iterator<VirtualFile> getFileIterator() {
        return this.myFiles.iterator();
    }

    ArrayList<VirtualFile> getFiles(VirtualFile dir) {
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        this.collectFiles(dir, filesList);
        return filesList;
    }

    private void collectFiles(VirtualFile dir, ArrayList<VirtualFile> filesList) {
        ArrayList children = (ArrayList)this.myDirectory2Children.get((Object)dir);
        if (children != null) {
            for (VirtualFile child : children) {
                if (!child.isDirectory()) {
                    LOG.assertTrue(!filesList.contains(child));
                    filesList.add(child);
                    continue;
                }
                this.collectFiles(child, filesList);
            }
        }
    }
}

