/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.containers.SortedList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class HighlighterList {
    private final SortedList<RangeHighlighterImpl> mySegmentHighlighters = new SortedList<RangeHighlighterImpl>(MY_RANGE_COMPARATOR){

        protected void sort(List<RangeHighlighterImpl> delegate) {
            Iterator<RangeHighlighterImpl> it = delegate.iterator();
            boolean needSort = false;
            RangeHighlighterImpl lastHighlighter = null;
            while (it.hasNext()) {
                RangeHighlighterImpl highlighter = it.next();
                if (!highlighter.isValid()) {
                    needSort = true;
                    it.remove();
                }
                if (lastHighlighter != null && !needSort) {
                    needSort = MY_RANGE_COMPARATOR.compare(lastHighlighter, highlighter) > 0;
                }
                lastHighlighter = highlighter;
            }
            if (needSort) {
                super.sort(delegate);
            }
        }

        public boolean remove(Object o) {
            if (o instanceof RangeHighlighterImpl && !((RangeHighlighterImpl)o).isValid()) {
                return false;
            }
            return super.remove(o);
        }
    };
    private boolean myIsDirtied = false;
    private final DocumentListener myDocumentListener = new PrioritizedDocumentListener(){

        @Override
        public int getPriority() {
            return 0;
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent e) {
            HighlighterList.this.myIsDirtied = true;
            HighlighterList.this.mySegmentHighlighters.markDirty();
        }
    };
    private final Document myDoc;
    private int myLongestHighlighterLength = 0;
    private static final Comparator<RangeHighlighterImpl> MY_RANGE_COMPARATOR = new Comparator<RangeHighlighterImpl>(){

        @Override
        public int compare(RangeHighlighterImpl r1, RangeHighlighterImpl r2) {
            int o = r1.getAffectedAreaStartOffset() - r2.getAffectedAreaStartOffset();
            if (o != 0) {
                return o;
            }
            if (r1.getLayer() != r2.getLayer()) {
                return r2.getLayer() - r1.getLayer();
            }
            return (int)(r2.getId() - r1.getId());
        }
    };

    public HighlighterList(Document doc) {
        this.myDoc = doc;
        this.myDoc.addDocumentListener(this.myDocumentListener);
    }

    public void dispose() {
        this.myDoc.removeDocumentListener(this.myDocumentListener);
    }

    public int getLongestHighlighterLength() {
        return this.myLongestHighlighterLength;
    }

    private void sortMarkers() {
        this.assertDispatchThread();
        this.myLongestHighlighterLength = 0;
        Iterator iterator = this.mySegmentHighlighters.iterator();
        while (iterator.hasNext()) {
            RangeHighlighter rangeHighlighter = (RangeHighlighter)iterator.next();
            if (rangeHighlighter.isValid()) {
                this.myLongestHighlighterLength = Math.max(this.myLongestHighlighterLength, rangeHighlighter.getEndOffset() - rangeHighlighter.getStartOffset());
                continue;
            }
            iterator.remove();
        }
        this.myIsDirtied = false;
    }

    protected abstract void assertDispatchThread();

    Iterator<RangeHighlighterImpl> getHighlighterIterator() {
        if (this.myIsDirtied) {
            this.sortMarkers();
        }
        return this.mySegmentHighlighters.iterator();
    }

    List<RangeHighlighterImpl> getSortedHighlighters() {
        if (this.myIsDirtied) {
            this.sortMarkers();
        }
        return this.mySegmentHighlighters;
    }

    void addSegmentHighlighter(RangeHighlighter segmentHighlighter) {
        this.assertDispatchThread();
        this.myIsDirtied = true;
        this.mySegmentHighlighters.add((Object)((RangeHighlighterImpl)segmentHighlighter));
    }

    void removeSegmentHighlighter(RangeHighlighter segmentHighlighter) {
        this.assertDispatchThread();
        this.myIsDirtied = true;
        this.mySegmentHighlighters.remove((Object)segmentHighlighter);
    }
}

