/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class LibrariesHelperImpl
extends LibrariesHelper {
    public VirtualFile findJarByClass(Library library, @NonNls String fqn) {
        return library == null ? null : this.findJarByClass(library.getFiles(OrderRootType.CLASSES), fqn);
    }

    private VirtualFile findJarByClass(VirtualFile[] files, String fqn) {
        for (VirtualFile file : files) {
            if (!LibrariesHelperImpl.findInFile(file, new StringTokenizer(fqn, "."))) continue;
            return file;
        }
        return null;
    }

    public boolean isClassAvailableInLibrary(Library library, String fqn) {
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        return this.isClassAvailable(urls, fqn);
    }

    public boolean isClassAvailable(String[] urls, String fqn) {
        for (String url : urls) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file == null) continue;
            if (!(file.getFileSystem() instanceof JarFileSystem) && !file.isDirectory()) {
                file = JarFileSystem.getInstance().findFileByPath(file.getPath() + "!/");
            }
            if (file == null || !LibrariesHelperImpl.findInFile(file, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    private static boolean findInFile(VirtualFile root, StringTokenizer filePath) {
        VirtualFile child;
        if (!filePath.hasMoreTokens()) {
            return true;
        }
        String name = filePath.nextToken();
        if (!filePath.hasMoreTokens()) {
            name = name + ".class";
        }
        return (child = root.findChild(name)) != null && LibrariesHelperImpl.findInFile(child, filePath);
    }
}

