/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.IconSet;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JTree;

public class ToggleExcludedStateAction
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;

    public ToggleExcludedStateAction(JTree tree, ContentEntryTreeEditor entryEditor) {
        super(tree);
        this.myEntryTreeEditor = entryEditor;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(ProjectBundle.message((String)"module.toggle.excluded.action", (Object[])new Object[0]));
        templatePresentation.setDescription(ProjectBundle.message((String)"module.toggle.excluded.action.description", (Object[])new Object[0]));
        templatePresentation.setIcon(IconSet.EXCLUDE_FOLDER);
    }

    public boolean isSelected(AnActionEvent e) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return false;
        }
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        return contentEntryEditor.isExcluded(selectedFiles[0]) || contentEntryEditor.isUnderExcludedDirectory(selectedFiles[0]);
    }

    public void setSelected(AnActionEvent e, boolean isSelected) {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles != null && selectedFiles.length > 0);
        for (VirtualFile selectedFile : selectedFiles) {
            ExcludeFolder excludeFolder = this.myEntryTreeEditor.getContentEntryEditor().getExcludeFolder(selectedFile);
            if (isSelected) {
                if (excludeFolder != null) continue;
                this.myEntryTreeEditor.getContentEntryEditor().addExcludeFolder(selectedFile);
                continue;
            }
            if (excludeFolder == null) continue;
            this.myEntryTreeEditor.getContentEntryEditor().removeExcludeFolder(excludeFolder);
        }
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setText(ProjectBundle.message((String)"module.toggle.excluded.action", (Object[])new Object[0]));
    }
}

