/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.PatchMergeRequestFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.patch.ApplyPatchAction");

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Consumer<ApplyPatchDifferentiatedDialog> callback = new Consumer<ApplyPatchDifferentiatedDialog>(){

            public void consume(ApplyPatchDifferentiatedDialog newDia) {
                if (newDia.getExitCode() != 0) {
                    return;
                }
                Collection<FilePatchInProgress> included = newDia.getIncluded();
                MultiMap patchGroups = new MultiMap();
                for (FilePatchInProgress patchInProgress : included) {
                    patchGroups.putValue((Object)patchInProgress.getBase(), (Object)patchInProgress);
                }
                LinkedList<PatchApplier> appliers = new LinkedList<PatchApplier>();
                for (VirtualFile base : patchGroups.keySet()) {
                    PatchApplier patchApplier = new PatchApplier(project, base, ObjectsConvertor.convert(patchGroups.get((Object)base), new Convertor<FilePatchInProgress, FilePatch>(){

                        public FilePatch convert(FilePatchInProgress o) {
                            return o.getPatch();
                        }
                    }), newDia.getSelectedChangeList(), null);
                    appliers.add(patchApplier);
                }
                PatchApplier.executePatchGroup(appliers);
            }
        };
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, callback);
        dialog.show();
    }

    public static void applySkipDirs(List<FilePatch> patches, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch patch : patches) {
            patch.setBeforeName(ApplyPatchAction.skipN(patch.getBeforeName(), skipDirs));
            patch.setAfterName(ApplyPatchAction.skipN(patch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path, int num) {
        String[] pieces = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < pieces.length; ++i) {
            String piece = pieces[i];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    public static <T extends FilePatch> ApplyPatchStatus applyOnly(Project project, ApplyFilePatchBase<T> patch, ApplyPatchContext context, VirtualFile file) {
        T patchBase = patch.getPatch();
        try {
            return patch.apply(file, context, project);
        }
        catch (ApplyPatchException ex) {
            ApplyPatchStatus mergeStatus;
            if (!patchBase.isNewFile() && !patchBase.isDeletedFile() && patchBase instanceof TextFilePatch && (mergeStatus = ApplyPatchAction.mergeAgainstBaseVersion(project, file, new FilePathImpl(file), (TextFilePatch)patchBase, (PatchMergeRequestFactory)ApplyPatchMergeRequestFactory.INSTANCE)) != null) {
                return mergeStatus;
            }
            Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"patch.apply.error", (Object[])new Object[]{patchBase.getBeforeName(), ex.getMessage()}), (String)VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        return ApplyPatchStatus.FAILURE;
    }

    @Nullable
    public static ApplyPatchStatus mergeAgainstBaseVersion(Project project, VirtualFile file, ApplyPatchContext context, TextFilePatch patch, PatchMergeRequestFactory mergeRequestFactory) {
        FilePath pathBeforeRename = context.getPathBeforeRename(file);
        return ApplyPatchAction.mergeAgainstBaseVersion(project, file, pathBeforeRename, patch, mergeRequestFactory);
    }

    @Nullable
    public static ApplyPatchStatus mergeAgainstBaseVersion(Project project, VirtualFile file, FilePath pathBeforeRename, TextFilePatch patch, PatchMergeRequestFactory mergeRequestFactory) {
        ApplyPatchForBaseRevisionTexts threeTexts = ApplyPatchForBaseRevisionTexts.create(project, file, pathBeforeRename, patch);
        if (threeTexts == null || threeTexts.getStatus() == null) {
            return null;
        }
        ApplyPatchStatus status = threeTexts.getStatus();
        if (ApplyPatchStatus.FAILURE.equals((Object)status)) {
            VcsException vcsExc = threeTexts.getException();
            Messages.showErrorDialog((Project)project, (String)VcsBundle.message((String)"patch.load.base.revision.error", (Object[])new Object[]{patch.getBeforeName(), vcsExc == null ? null : vcsExc.getMessage()}), (String)VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
            return status;
        }
        if (status != ApplyPatchStatus.ALREADY_APPLIED) {
            return ApplyPatchAction.showMergeDialog(project, file, threeTexts.getBase(), threeTexts.getPatched(), mergeRequestFactory);
        }
        return status;
    }

    private static ApplyPatchStatus showMergeDialog(Project project, VirtualFile file, CharSequence content, String patchedContent, PatchMergeRequestFactory mergeRequestFactory) {
        CharSequence fileContent = LoadTextUtil.loadText(file);
        if (fileContent == null || content == null) {
            return ApplyPatchStatus.FAILURE;
        }
        MergeRequest request = mergeRequestFactory.createMergeRequest(((Object)fileContent).toString(), patchedContent, ((Object)content).toString(), file, project);
        DiffManager.getInstance().getDiffTool().show((DiffRequest)request);
        if (request.getResult() == 0) {
            return ApplyPatchStatus.SUCCESS;
        }
        request.restoreOriginalContent();
        return ApplyPatchStatus.FAILURE;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (e.getPlace().equals("ProjectViewPopup")) {
            VirtualFile vFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
            e.getPresentation().setVisible(project != null && vFile != null && vFile.getFileType() == StdFileTypes.PATCH);
        } else {
            e.getPresentation().setEnabled(project != null);
        }
    }

    public static class ApplyPatchMergeRequestFactory
    implements PatchMergeRequestFactory {
        private final boolean myReadOnly;
        public static final ApplyPatchMergeRequestFactory INSTANCE = new ApplyPatchMergeRequestFactory(false);
        public static final ApplyPatchMergeRequestFactory INSTANCE_READ_ONLY = new ApplyPatchMergeRequestFactory(true);

        public ApplyPatchMergeRequestFactory(boolean readOnly) {
            this.myReadOnly = readOnly;
        }

        @Override
        public MergeRequest createMergeRequest(String leftText, String rightText, String originalContent, @NotNull VirtualFile file, Project project) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vcs/changes/patch/ApplyPatchAction$ApplyPatchMergeRequestFactory.createMergeRequest must not be null");
            }
            MergeRequest request = this.myReadOnly ? DiffRequestFactory.getInstance().create3WayDiffRequest(leftText, rightText, originalContent, project, null) : DiffRequestFactory.getInstance().createMergeRequest(leftText, rightText, originalContent, file, project, ActionButtonPresentation.createApplyButton());
            request.setVersionTitles(new String[]{VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.conflict.merged.version", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0])});
            request.setWindowTitle(VcsBundle.message((String)"patch.apply.conflict.title", (Object[])new Object[]{file.getPresentableUrl()}));
            return request;
        }
    }
}

