/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.impl;

import com.intellij.diff.Block;
import com.intellij.diff.FindBlock;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.impl.VcsHistoryDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VcsBlockHistoryDialog
extends VcsHistoryDialog {
    private final int mySelectionStart;
    private final int mySelectionEnd;
    private final Map<VcsFileRevision, Block> myRevisionToContentMap = new HashMap();

    public VcsBlockHistoryDialog(Project project, VirtualFile file, AbstractVcs vcs, VcsHistoryProvider provider, VcsHistorySession session, int selectionStart, int selectionEnd) {
        this(project, file, vcs, provider, session, selectionStart, selectionEnd, "History for Selection");
    }

    public VcsBlockHistoryDialog(Project project, VirtualFile file, AbstractVcs vcs, VcsHistoryProvider provider, VcsHistorySession session, int selectionStart, int selectionEnd, String title) {
        super(project, file, provider, session, vcs);
        this.mySelectionStart = selectionStart;
        this.mySelectionEnd = selectionEnd;
        this.setTitle(title);
    }

    @Override
    protected String getContentToShow(VcsFileRevision revision) {
        Block block = this.getBlock(revision);
        if (block == null) {
            return "";
        }
        return block.getBlockContent();
    }

    @Nullable
    private Block getBlock(VcsFileRevision revision) {
        if (this.myRevisionToContentMap.containsKey(revision)) {
            return this.myRevisionToContentMap.get(revision);
        }
        int index = this.myRevisions.indexOf(revision);
        String revisionContent = this.getContentOf(revision);
        if (revisionContent == null) {
            return null;
        }
        if (index == 0) {
            this.myRevisionToContentMap.put(revision, new Block(revisionContent, this.mySelectionStart, this.mySelectionEnd));
        } else {
            Block prevBlock = this.getBlock((VcsFileRevision)this.myRevisions.get(index - 1));
            if (prevBlock == null) {
                return null;
            }
            this.myRevisionToContentMap.put(revision, new FindBlock(revisionContent, prevBlock).getBlockInThePrevVersion());
        }
        return this.myRevisionToContentMap.get(revision);
    }

    @Override
    protected VcsFileRevision[] revisionsNeededToBeLoaded(VcsFileRevision[] revisions) {
        HashSet<VcsFileRevision> result = new HashSet<VcsFileRevision>();
        for (VcsFileRevision revision : revisions) {
            result.addAll(this.collectRevisionsFromFirstTo(revision));
        }
        return result.toArray(new VcsFileRevision[result.size()]);
    }

    private Collection<VcsFileRevision> collectRevisionsFromFirstTo(VcsFileRevision revision) {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        for (VcsFileRevision vcsFileRevision : this.myRevisions) {
            if (VcsHistoryUtil.compare((VcsFileRevision)revision, (VcsFileRevision)vcsFileRevision) > 0) continue;
            result.add(vcsFileRevision);
        }
        return result;
    }
}

