/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeEncodingUpdateGroup;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.nio.charset.Charset;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileTreeTable
extends AbstractFileTreeTable<Charset> {
    public FileTreeTable(Project project) {
        super(project, Charset.class, "Default Encoding");
        this.reset(EncodingProjectManager.getInstance((Project)project).getAllMappings());
        this.getValueColumn().setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                boolean enabled;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Charset t = (Charset)value;
                Object userObject = table.getModel().getValueAt(row, 0);
                VirtualFile file = userObject instanceof VirtualFile ? (VirtualFile)userObject : null;
                Pair<String, Boolean> pair = ChangeEncodingUpdateGroup.update(file);
                boolean bl = enabled = file == null || (Boolean)pair.getSecond() != false;
                if (t != null) {
                    this.setText(t.displayName());
                } else if (file != null) {
                    Charset charset = ChooseFileEncodingAction.charsetFromContent(file);
                    if (charset != null) {
                        this.setText(charset.displayName());
                    } else if (LoadTextUtil.utfCharsetWasDetectedFromBytes(file)) {
                        this.setText(file.getCharset().displayName());
                    } else if (!ChooseFileEncodingAction.isEnabled(file)) {
                        this.setText("N/A");
                    }
                }
                this.setEnabled(enabled);
                return this;
            }
        });
        this.getValueColumn().setCellEditor(new DefaultCellEditor(new JComboBox()){
            private VirtualFile myVirtualFile;
            {
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    @Override
                    public void setValue(Object value) {
                        FileTreeTable.this.getTableModel().setValueAt(value, (Object)new DefaultMutableTreeNode(myVirtualFile), -1);
                    }

                    @Override
                    public Object getCellEditorValue() {
                        return FileTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(myVirtualFile), 1);
                    }
                };
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Object o = table.getModel().getValueAt(row, 0);
                this.myVirtualFile = o instanceof Project ? null : (VirtualFile)o;
                ChooseFileEncodingAction changeAction = new ChooseFileEncodingAction(this.myVirtualFile){

                    @Override
                    protected void chosen(VirtualFile virtualFile, Charset charset) {
                        FileTreeTable.this.getValueColumn().getCellEditor().stopCellEditing();
                        if (FileTreeTable.this.clearSubdirectoriesOnDemandOrCancel(virtualFile, "There are encodings specified for the subdirectories. Override them?", "Override Subdirectory Encoding")) {
                            FileTreeTable.this.getTableModel().setValueAt((Object)charset, (Object)new DefaultMutableTreeNode(virtualFile), 1);
                        }
                    }
                };
                Presentation templatePresentation = changeAction.getTemplatePresentation();
                JComponent comboComponent = changeAction.createCustomComponent(templatePresentation);
                DataContext dataContext = SimpleDataContext.getSimpleContext(PlatformDataKeys.VIRTUAL_FILE.getName(), this.myVirtualFile, SimpleDataContext.getProjectContext(FileTreeTable.this.getProject()));
                AnActionEvent event = new AnActionEvent(null, dataContext, "unknown", templatePresentation, ActionManager.getInstance(), 0);
                changeAction.update(event);
                this.editorComponent = comboComponent;
                comboComponent.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        AbstractFileTreeTable.press((Container)e.getComponent());
                    }
                });
                Charset charset = (Charset)FileTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(this.myVirtualFile), 1);
                templatePresentation.setText(charset == null ? "" : charset.displayName());
                comboComponent.revalidate();
                return this.editorComponent;
            }
        });
    }

    @Override
    protected boolean isNullObject(Charset value) {
        return value == ChooseFileEncodingAction.NO_ENCODING;
    }

    @Override
    protected boolean isValueEditableForFile(VirtualFile virtualFile) {
        return (Boolean)ChangeEncodingUpdateGroup.update(virtualFile).getSecond();
    }
}

