/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class IdeMenuBar
extends JMenuBar {
    private final MyTimerListener myTimerListener;
    private ArrayList<AnAction> myVisibleActions;
    private ArrayList<AnAction> myNewVisibleActions;
    private final MenuItemPresentationFactory myPresentationFactory;
    private final DataManager myDataManager;
    private final ActionManager myActionManager;
    private UISettingsListener myUISettingsListener;

    public IdeMenuBar(ActionManager actionManager, DataManager dataManager, KeymapManager keymapManager) {
        this.myActionManager = actionManager;
        this.myTimerListener = new MyTimerListener();
        this.myVisibleActions = new ArrayList();
        this.myNewVisibleActions = new ArrayList();
        this.myPresentationFactory = new MenuItemPresentationFactory();
        this.myDataManager = dataManager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateMenuActions();
        ActionManagerEx actionManager = (ActionManagerEx)this.myActionManager;
        actionManager.addTimerListener(1000, new WeakTimerListener(actionManager, this.myTimerListener));
        this.myUISettingsListener = new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                IdeMenuBar.this.updateMnemonicsVisibility();
                IdeMenuBar.this.myPresentationFactory.reset();
            }
        };
        UISettings.getInstance().addUISettingsListener(this.myUISettingsListener);
    }

    @Override
    public void removeNotify() {
        UISettings.getInstance().removeUISettingsListener(this.myUISettingsListener);
        super.removeNotify();
    }

    void updateMenuActions() {
        this.myNewVisibleActions.clear();
        DataContext dataContext = ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
        this.expandActionGroup(dataContext, this.myNewVisibleActions, this.myActionManager);
        if (!this.myNewVisibleActions.equals(this.myVisibleActions)) {
            boolean changeBarVisibility = this.myNewVisibleActions.size() == 0 || this.myVisibleActions.size() == 0;
            ArrayList<AnAction> temp = this.myVisibleActions;
            this.myVisibleActions = this.myNewVisibleActions;
            this.myNewVisibleActions = temp;
            this.removeAll();
            Color background = null;
            for (AnAction action : this.myVisibleActions) {
                ActionMenu menu = new ActionMenu(null, "MainMenu", (ActionGroup)action, this.myPresentationFactory, !UISettings.getInstance().DISABLE_MNEMONICS);
                this.add(menu);
                background = menu.getBackground();
            }
            if (background != null) {
                this.setBackground(background);
            }
            this.updateMnemonicsVisibility();
            this.validate();
            if (changeBarVisibility) {
                this.invalidate();
                JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
                if (frame != null) {
                    frame.validate();
                }
            }
        }
    }

    @Override
    public void updateUI() {
        JMenu menu;
        super.updateUI();
        if (this.getMenuCount() > 0 && (menu = this.getMenu(0)) != null) {
            menu.updateUI();
            this.setBackground(menu.getBackground());
        }
    }

    private void expandActionGroup(DataContext context, ArrayList<AnAction> newVisibleActions, ActionManager actionManager) {
        AnAction[] children;
        ActionGroup mainActionGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainMenu");
        if (mainActionGroup == null) {
            return;
        }
        for (AnAction action : children = mainActionGroup.getChildren(null)) {
            if (!(action instanceof ActionGroup)) continue;
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            AnActionEvent e = new AnActionEvent(null, context, "MainMenu", presentation, actionManager, 0);
            e.setInjectedContext(action.isInInjectedContext());
            action.update(e);
            if (!presentation.isVisible()) continue;
            newVisibleActions.add(action);
        }
    }

    private void updateMnemonicsVisibility() {
        boolean enabled = !UISettings.getInstance().DISABLE_MNEMONICS;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            ((ActionMenu)this.getMenu(i)).setMnemonicEnabled(enabled);
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)IdeMenuBar.this);
        }

        public void run() {
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            Window mywindow = SwingUtilities.windowForComponent(IdeMenuBar.this);
            if (mywindow != null && !mywindow.isActive()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return;
            }
            IdeMenuBar.this.updateMenuActions();
        }
    }
}

