/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;

public class WrappingUtil {
    private WrappingUtil() {
    }

    public static boolean shouldWrap(int setting) {
        return setting != 0;
    }

    public static Wrap createWrap(int setting) {
        return Wrap.createWrap((WrapType)WrappingUtil.getWrapType(setting), (boolean)true);
    }

    public static WrapType getWrapType(int setting) {
        switch (setting) {
            case 2: {
                return WrapType.ALWAYS;
            }
            case 1: {
                return WrapType.NORMAL;
            }
            case 0: {
                return WrapType.NONE;
            }
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }

    public static WrapType getArrayInitializerWrapType(CodeStyleSettings settings, ASTNode node, IElementType lBraceType, IElementType rBraceType) {
        WrapType wrapType = WrapType.NONE;
        if (WrappingUtil.shouldWrap(settings.ARRAY_INITIALIZER_WRAP)) {
            wrapType = node.getElementType() == rBraceType ? (settings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE ? Wrap.ALWAYS : Wrap.NONE) : (FormatterUtil.isPrecededBy(node, lBraceType) ? (settings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE ? Wrap.ALWAYS : Wrap.NONE) : WrappingUtil.getWrapType(settings.ARRAY_INITIALIZER_WRAP));
        }
        return wrapType;
    }
}

