/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType {
    private final PsiJavaCodeReferenceElement myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel languageLevel) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        super(languageLevel, PsiClassReferenceType.extractAnnosFromReference(reference));
        this.myReference = reference;
    }

    private static PsiAnnotation[] extractAnnosFromReference(PsiJavaCodeReferenceElement reference) {
        List result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((PsiAnnotation)child);
        }
        if (result == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        return result.toArray(new PsiAnnotation[result.size()]);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel languageLevel, PsiAnnotation[] annotations) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassReferenceType.<init> must not be null");
        }
        super(languageLevel, annotations);
        this.myReference = reference;
    }

    public boolean isValid() {
        return this.myReference.isValid();
    }

    public boolean equalsToText(String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReference.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getResolveScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel;
        if (this.myLanguageLevel != null) {
            languageLevel = this.myLanguageLevel;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.myReference);
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getLanguageLevel must not return null");
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiClassReferenceType(this.myReference, languageLevel, this.getAnnotations());
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        JavaResolveResult result = this.myReference.advancedResolve(false);
        DelegatingClassResolveResult delegatingClassResolveResult = new DelegatingClassResolveResult(result);
        if (delegatingClassResolveResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.resolveGenerics must not return null");
        }
        return delegatingClassResolveResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClassType rawType() {
        LightClassReference reference;
        PsiClassReferenceType psiClassReferenceType;
        PsiElement resolved = this.myReference.resolve();
        if (resolved instanceof PsiClass) {
            PsiSubstitutor rawSubstitutor;
            PsiManager manager;
            PsiElementFactory factory;
            PsiClass aClass = (PsiClass)resolved;
            if (!(!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext() ? (psiClassReferenceType = this) != null : (psiClassReferenceType = (factory = JavaPsiFacade.getInstance((Project)(manager = this.myReference.getManager()).getProject()).getElementFactory()).createType(aClass, rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass), this.getLanguageLevel(), this.getAnnotations())) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
            return psiClassReferenceType;
        }
        String qualifiedName = this.myReference.getQualifiedName();
        String name = this.myReference.getReferenceName();
        if (name == null) {
            name = "";
        }
        if ((psiClassReferenceType = new PsiClassReferenceType(reference = new LightClassReference(this.myReference.getManager(), name, qualifiedName, this.myReference.getResolveScope()), null, this.getAnnotations())) != null) return psiClassReferenceType;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.rawType must not return null");
    }

    public String getClassName() {
        return this.myReference.getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myReference.getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassReferenceType.getParameters must not return null");
        }
        return psiTypeArray;
    }

    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        if (resolveResult.getElement() == null) {
            return this;
        }
        return new PsiImmediateClassType(resolveResult.getElement(), resolveResult.getSubstitutor());
    }

    public String getPresentableText() {
        return this.getAnnotationsTextPrefix() + PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this.myReference);
    }

    public String getCanonicalText() {
        return this.myReference.getCanonicalText();
    }

    public String getInternalCanonicalText() {
        return this.getAnnotationsTextPrefix() + this.getCanonicalText();
    }

    public PsiJavaCodeReferenceElement getReference() {
        return this.myReference;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

