/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;

public class ProcessOutput {
    private StringBuilder myStdoutBuilder = new StringBuilder();
    private StringBuilder myStderrBuilder = new StringBuilder();
    private int myExitCode;
    private boolean myTimeout;

    void appendStdout(String text) {
        this.myStdoutBuilder.append(text);
    }

    void appendStderr(String text) {
        this.myStderrBuilder.append(text);
    }

    void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public String getStdout() {
        return this.myStdoutBuilder.toString();
    }

    public String getStderr() {
        return this.myStderrBuilder.toString();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public List<String> getStdoutLines() {
        return this.splitLines(this.myStdoutBuilder.toString());
    }

    public List<String> getStderrLines() {
        return this.splitLines(this.myStderrBuilder.toString());
    }

    private List<String> splitLines(String s) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n");
    }
}

