/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindModel
extends UserDataHolderBase
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.FindModel");
    private String myStringToFind = "";
    private String myStringToReplace = "";
    private boolean isSearchHighlighters = false;
    private boolean isReplaceState = false;
    private boolean isWholeWordsOnly = false;
    private boolean isInCommentsOnly;
    private boolean isInStringLiteralsOnly;
    private boolean isFromCursor = true;
    private boolean isForward = true;
    private boolean isGlobal = true;
    private boolean isRegularExpressions = false;
    private boolean isCaseSensitive = false;
    private boolean isMultipleFiles = false;
    private boolean isPromptOnReplace = true;
    private boolean isReplaceAll = false;
    private boolean isOpenNewTab = false;
    private boolean isOpenInNewTabEnabled = false;
    private boolean isOpenNewTabVisible = false;
    private boolean isProjectScope = true;
    private boolean isFindAll = false;
    private boolean isFindAllEnabled = false;
    private String moduleName;
    private String directoryName = null;
    private boolean isWithSubdirectories = true;
    private String fileFilter;
    private String customScopeName;
    private SearchScope customScope;
    private boolean isPreserveCase = false;

    public boolean isPreserveCase() {
        return this.isPreserveCase;
    }

    public void setPreserveCase(boolean preserveCase) {
        this.isPreserveCase = preserveCase;
    }

    public void copyFrom(FindModel model) {
        this.myStringToFind = model.myStringToFind;
        this.myStringToReplace = model.myStringToReplace;
        this.isReplaceState = model.isReplaceState;
        this.isWholeWordsOnly = model.isWholeWordsOnly;
        this.isFromCursor = model.isFromCursor;
        this.isForward = model.isForward;
        this.isGlobal = model.isGlobal;
        this.isRegularExpressions = model.isRegularExpressions;
        this.isCaseSensitive = model.isCaseSensitive;
        this.isMultipleFiles = model.isMultipleFiles;
        this.isPromptOnReplace = model.isPromptOnReplace;
        this.isReplaceAll = model.isReplaceAll;
        this.isOpenNewTab = model.isOpenNewTab;
        this.isOpenInNewTabEnabled = model.isOpenInNewTabEnabled;
        this.isOpenNewTabVisible = model.isOpenNewTabVisible;
        this.isProjectScope = model.isProjectScope;
        this.directoryName = model.directoryName;
        this.isWithSubdirectories = model.isWithSubdirectories;
        this.isPreserveCase = model.isPreserveCase;
        this.fileFilter = model.fileFilter;
        this.moduleName = model.moduleName;
        this.customScopeName = model.customScopeName;
        this.customScope = model.customScope;
        this.isFindAll = model.isFindAll;
        this.isInCommentsOnly = model.isInCommentsOnly;
        this.isInStringLiteralsOnly = model.isInStringLiteralsOnly;
    }

    @NotNull
    public String getStringToFind() {
        String string = this.myStringToFind;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/FindModel.getStringToFind must not return null");
        }
        return string;
    }

    public void setStringToFind(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/FindModel.setStringToFind must not be null");
        }
        LOG.assertTrue(s.length() > 0);
        this.myStringToFind = s;
    }

    @NotNull
    public String getStringToReplace() {
        String string = this.myStringToReplace;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/FindModel.getStringToReplace must not return null");
        }
        return string;
    }

    public void setStringToReplace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/FindModel.setStringToReplace must not be null");
        }
        this.myStringToReplace = s;
    }

    public boolean isReplaceState() {
        return this.isReplaceState;
    }

    public void setReplaceState(boolean val) {
        this.isReplaceState = val;
    }

    public boolean isFromCursor() {
        return this.isFromCursor;
    }

    public void setFromCursor(boolean val) {
        this.isFromCursor = val;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean val) {
        this.isForward = val;
    }

    public boolean isRegularExpressions() {
        return this.isRegularExpressions;
    }

    public void setRegularExpressions(boolean val) {
        this.isRegularExpressions = val;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean val) {
        this.isCaseSensitive = val;
    }

    public boolean isMultipleFiles() {
        return this.isMultipleFiles;
    }

    public void setMultipleFiles(boolean val) {
        this.isMultipleFiles = val;
    }

    public boolean isPromptOnReplace() {
        return this.isPromptOnReplace;
    }

    public void setPromptOnReplace(boolean val) {
        this.isPromptOnReplace = val;
    }

    public boolean isWholeWordsOnly() {
        return this.isWholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean isWholeWordsOnly) {
        this.isWholeWordsOnly = isWholeWordsOnly;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public boolean isReplaceAll() {
        return this.isReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.isReplaceAll = replaceAll;
    }

    public boolean isOpenInNewTab() {
        return this.isOpenNewTab;
    }

    public void setOpenInNewTab(boolean showInNewTab) {
        this.isOpenNewTab = showInNewTab;
    }

    public boolean isOpenInNewTabEnabled() {
        return this.isOpenInNewTabEnabled;
    }

    public void setOpenInNewTabEnabled(boolean showInNewTabEnabled) {
        this.isOpenInNewTabEnabled = showInNewTabEnabled;
    }

    public boolean isOpenInNewTabVisible() {
        return this.isOpenNewTabVisible;
    }

    public void setOpenInNewTabVisible(boolean showInNewTabVisible) {
        this.isOpenNewTabVisible = showInNewTabVisible;
    }

    @Nullable
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public boolean isWithSubdirectories() {
        return this.isWithSubdirectories;
    }

    public void setWithSubdirectories(boolean withSubdirectories) {
        this.isWithSubdirectories = withSubdirectories;
    }

    public boolean isProjectScope() {
        return this.isProjectScope;
    }

    public void setProjectScope(boolean projectScope) {
        this.isProjectScope = projectScope;
    }

    public Object clone() {
        return super.clone();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("--- FIND MODEL ---\n");
        buffer.append("myStringToFind =").append(this.myStringToFind).append("\n");
        buffer.append("myStringToReplace =").append(this.myStringToReplace).append("\n");
        buffer.append("isReplaceState =").append(this.isReplaceState).append("\n");
        buffer.append("isWholeWordsOnly =").append(this.isWholeWordsOnly).append("\n");
        buffer.append("isInStringLiterals =").append(this.isInStringLiteralsOnly).append("\n");
        buffer.append("isInComments =").append(this.isInCommentsOnly).append("\n");
        buffer.append("isFromCursor =").append(this.isFromCursor).append("\n");
        buffer.append("isForward =").append(this.isForward).append("\n");
        buffer.append("isGlobal =").append(this.isGlobal).append("\n");
        buffer.append("isRegularExpressions =").append(this.isRegularExpressions).append("\n");
        buffer.append("isCaseSensitive =").append(this.isCaseSensitive).append("\n");
        buffer.append("isMultipleFiles =").append(this.isMultipleFiles).append("\n");
        buffer.append("isPromptOnReplace =").append(this.isPromptOnReplace).append("\n");
        buffer.append("isReplaceAll =").append(this.isReplaceAll).append("\n");
        buffer.append("isOpenNewTab =").append(this.isOpenNewTab).append("\n");
        buffer.append("isOpenInNewTabEnabled =").append(this.isOpenInNewTabEnabled).append("\n");
        buffer.append("isOpenNewTabVisible =").append(this.isOpenNewTabVisible).append("\n");
        buffer.append("isProjectScope =").append(this.isProjectScope).append("\n");
        buffer.append("directoryName =").append(this.directoryName).append("\n");
        buffer.append("isWithSubdirectories =").append(this.isWithSubdirectories).append("\n");
        buffer.append("fileFilter =").append(this.fileFilter).append("\n");
        buffer.append("moduleName =").append(this.moduleName).append("\n");
        buffer.append("customScopeName =").append(this.customScopeName).append("\n");
        return buffer.toString();
    }

    public boolean searchHighlighters() {
        return this.isSearchHighlighters;
    }

    public void setSearchHighlighters(boolean search) {
        this.isSearchHighlighters = search;
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(String fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isFindAll() {
        return this.isFindAll;
    }

    public void setFindAll(boolean findAll) {
        this.isFindAll = findAll;
    }

    public boolean isFindAllEnabled() {
        return this.isFindAllEnabled;
    }

    public void setFindAllEnabled(boolean findAllEnabled) {
        this.isFindAllEnabled = findAllEnabled;
    }

    public String getCustomScopeName() {
        return this.customScopeName;
    }

    public void setCustomScopeName(String customScopeName) {
        this.customScopeName = customScopeName;
    }

    public SearchScope getCustomScope() {
        return this.customScope;
    }

    public void setCustomScope(SearchScope customScope) {
        this.customScope = customScope;
    }

    public boolean isInStringLiteralsOnly() {
        return this.isInStringLiteralsOnly;
    }

    public void setInStringLiteralsOnly(boolean inStringLiteralsOnly) {
        this.isInStringLiteralsOnly = inStringLiteralsOnly;
    }

    public boolean isInCommentsOnly() {
        return this.isInCommentsOnly;
    }

    public void setInCommentsOnly(boolean inCommentsOnly) {
        this.isInCommentsOnly = inCommentsOnly;
    }
}

