/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StateStorage {
    public static final Topic<Listener> STORAGE_TOPIC = new Topic("STORAGE_LISTENER", Listener.class, Topic.BroadcastDirection.TO_PARENT);

    @Nullable
    public <T> T getState(Object var1, String var2, Class<T> var3, @Nullable T var4) throws StateStorageException;

    public boolean hasState(Object var1, String var2, Class<?> var3, boolean var4) throws StateStorageException;

    @NotNull
    public ExternalizationSession startExternalization();

    @NotNull
    public SaveSession startSave(ExternalizationSession var1);

    public void finishSave(SaveSession var1);

    public void reload(Set<String> var1) throws StateStorageException;

    public static interface Listener {
        public void storageFileChanged(VirtualFileEvent var1, StateStorage var2);
    }

    public static class StateStorageException
    extends RuntimeException {
        public StateStorageException() {
        }

        public StateStorageException(String message) {
            super(message);
        }

        public StateStorageException(String message, Throwable cause) {
            super(message, cause);
        }

        public StateStorageException(Throwable cause) {
            super(cause);
        }
    }

    public static interface SaveSession {
        public void save() throws StateStorageException;

        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> var1);

        public Collection<IFile> getStorageFilesToSave() throws StateStorageException;

        public List<IFile> getAllStorageFiles();
    }

    public static interface ExternalizationSession {
        public void setState(Object var1, String var2, Object var3, @Nullable Storage var4) throws StateStorageException;
    }
}

