/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangesUtil.getFilePath must not be null");
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath = revision.getFile();
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/ChangesUtil.getFilePath must not return null");
        }
        return filePath;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangesUtil.getBeforePath must not be null");
        }
        ContentRevision revision = change.getBeforeRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangesUtil.getAfterPath must not be null");
        }
        ContentRevision revision = change.getAfterRevision();
        return revision == null ? null : revision.getFile();
    }

    public static AbstractVcs getVcsForChange(Change change, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(ChangesUtil.getFilePath(change));
    }

    public static AbstractVcs getVcsForFile(VirtualFile file, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(file);
    }

    public static AbstractVcs getVcsForFile(File file, Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(VcsContextFactory.SERVICE.getInstance().createFilePathOn(file));
    }

    public static List<FilePath> getPaths(Collection<Change> changes) {
        Adder adder = new Adder();
        for (Change change : changes) {
            ContentRevision afterRevision;
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision != null) {
                adder.add(beforeRevision.getFile());
            }
            if ((afterRevision = change.getAfterRevision()) == null) continue;
            adder.add(afterRevision.getFile());
        }
        return adder.getResult();
    }

    public static List<File> getIoFilesFromChanges(Collection<Change> changes) {
        ArrayList<File> result = new ArrayList<File>();
        for (Change change : changes) {
            File ioFile;
            if (change.getAfterRevision() != null && !result.contains(ioFile = change.getAfterRevision().getFile().getIOFile())) {
                result.add(ioFile);
            }
            if (change.getBeforeRevision() == null || result.contains(ioFile = change.getBeforeRevision().getFile().getIOFile())) continue;
            result.add(ioFile);
        }
        return result;
    }

    public static VirtualFile[] getFilesFromChanges(Collection<Change> changes) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (Change change : changes) {
            VirtualFile file;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || (file = afterRevision.getFile().getVirtualFile()) == null || !file.isValid()) continue;
            files.add(file);
        }
        return VfsUtil.toVirtualFileArray(files);
    }

    public static Navigatable[] getNavigatableArray(Project project, VirtualFile[] selectedFiles) {
        ArrayList<OpenFileDescriptor> result = new ArrayList<OpenFileDescriptor>();
        for (VirtualFile selectedFile : selectedFiles) {
            if (selectedFile.isDirectory()) continue;
            result.add(new OpenFileDescriptor(project, selectedFile));
        }
        return result.toArray(new Navigatable[result.size()]);
    }

    @Nullable
    public static boolean allChangesInOneList(@NotNull Project project, @Nullable Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangesUtil.allChangesInOneList must not be null");
        }
        return ChangeListManager.getInstance(project).getChangeListNameIfOnlyOne(changes) != null;
    }

    @Nullable
    public static ChangeList getChangeListIfOnlyOne(@NotNull Project project, @Nullable Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ChangesUtil.getChangeListIfOnlyOne must not be null");
        }
        ChangeListManager clManager = ChangeListManager.getInstance(project);
        String name = clManager.getChangeListNameIfOnlyOne(changes);
        return name == null ? null : clManager.findChangeList(name);
    }

    public static FilePath getCommittedPath(Project project, FilePath filePath) {
        Change change = ChangeListManager.getInstance(project).getChange(filePath);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath)) {
                filePath = beforeRevision.getFile();
            }
        }
        return filePath;
    }

    public static FilePath getLocalPath(final Project project, final FilePath filePath) {
        Change change = ApplicationManager.getApplication().runReadAction(new Computable<Change>(){

            @Nullable
            public Change compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return ChangeListManager.getInstance(project).getChange(filePath);
            }
        });
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath)) {
                return afterRevision.getFile();
            }
        }
        return filePath;
    }

    @Nullable
    public static VirtualFile findValidParent(FilePath file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile parent = file.getVirtualFile();
        if (parent == null) {
            parent = file.getVirtualFileParent();
        }
        if (parent == null) {
            File ioFile = file.getIOFile();
            while ((parent = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) == null) {
                if ((ioFile = ioFile.getParentFile()) != null) continue;
                return null;
            }
        }
        return parent;
    }

    @Nullable
    public static String getProjectRelativePath(Project project, @Nullable File fileName) {
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)new File(baseDir.getPath()), (File)fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isBinaryContentRevision(ContentRevision revision) {
        return revision != null && !revision.getFile().isDirectory() && revision instanceof BinaryContentRevision;
    }

    public static boolean isBinaryChange(Change change) {
        return ChangesUtil.isBinaryContentRevision(change.getBeforeRevision()) || ChangesUtil.isBinaryContentRevision(change.getAfterRevision());
    }

    public static <T> void processItemsByVcs(final Collection<T> items, final VcsSeparator<T> separator, PerVcsProcessor<T> processor) {
        final HashMap changesByVcs = new HashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (Object item : items) {
                    AbstractVcs vcs = separator.getVcsFor(item);
                    if (vcs == null) continue;
                    ArrayList vcsChanges = (ArrayList)changesByVcs.get(vcs);
                    if (vcsChanges == null) {
                        vcsChanges = new ArrayList();
                        changesByVcs.put(vcs, vcsChanges);
                    }
                    vcsChanges.add(item);
                }
            }
        });
        for (Map.Entry entry : changesByVcs.entrySet()) {
            processor.process((AbstractVcs)entry.getKey(), (List)entry.getValue());
        }
    }

    public static void processChangesByVcs(final Project project, Collection<Change> changes, PerVcsProcessor<Change> processor) {
        ChangesUtil.processItemsByVcs(changes, new VcsSeparator<Change>(){

            @Override
            public AbstractVcs getVcsFor(Change item) {
                return ChangesUtil.getVcsForChange(item, project);
            }
        }, processor);
    }

    public static void processVirtualFilesByVcs(final Project project, Collection<VirtualFile> files, PerVcsProcessor<VirtualFile> processor) {
        ChangesUtil.processItemsByVcs(files, new VcsSeparator<VirtualFile>(){

            @Override
            public AbstractVcs getVcsFor(VirtualFile item) {
                return ChangesUtil.getVcsForFile(item, project);
            }
        }, processor);
    }

    public static void processFilePathsByVcs(final Project project, Collection<FilePath> files, PerVcsProcessor<FilePath> processor) {
        ChangesUtil.processItemsByVcs(files, new VcsSeparator<FilePath>(){

            @Override
            public AbstractVcs getVcsFor(FilePath item) {
                return ChangesUtil.getVcsForFile(item.getIOFile(), project);
            }
        }, processor);
    }

    public static List<File> filePathsToFiles(Collection<FilePath> filePaths) {
        ArrayList<File> ioFiles = new ArrayList<File>();
        for (FilePath filePath : filePaths) {
            ioFiles.add(filePath.getIOFile());
        }
        return ioFiles;
    }

    public static boolean hasFileChanges(Collection<Change> changes) {
        for (Change change : changes) {
            FilePath path = ChangesUtil.getFilePath(change);
            if (path.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static String getDefaultChangeListName() {
        return VcsBundle.message("changes.default.changlist.name", new Object[0]);
    }

    public static interface VcsSeparator<T> {
        public AbstractVcs getVcsFor(T var1);
    }

    public static interface PerVcsProcessor<T> {
        public void process(AbstractVcs var1, List<T> var2);
    }

    private static class Adder {
        private final List<FilePath> myResult = new ArrayList<FilePath>();
        private final Set<String> myDuplicatesControlSet = new HashSet<String>();

        private Adder() {
        }

        public void add(FilePath file) {
            String path = file.getIOFile().getAbsolutePath();
            if (!this.myDuplicatesControlSet.contains(path)) {
                this.myResult.add(file);
                this.myDuplicatesControlSet.add(path);
            }
        }

        public List<FilePath> getResult() {
            return this.myResult;
        }
    }
}

