/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectAndLibrariesScope
extends GlobalSearchScope {
    protected final ProjectFileIndex myProjectFileIndex;

    public ProjectAndLibrariesScope(Project project) {
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
    }

    @Override
    public boolean contains(VirtualFile file) {
        return this.myProjectFileIndex.isInContent(file) || this.myProjectFileIndex.isInLibraryClasses(file) || this.myProjectFileIndex.isInLibrarySource(file);
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        List<OrderEntry> entries1 = this.myProjectFileIndex.getOrderEntriesForFile(file1);
        List<OrderEntry> entries2 = this.myProjectFileIndex.getOrderEntriesForFile(file2);
        if (entries1.size() != entries2.size()) {
            return 0;
        }
        int res = 0;
        for (OrderEntry entry1 : entries1) {
            Module module = entry1.getOwnerModule();
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            OrderEntry entry2 = moduleFileIndex.getOrderEntryForFile(file2);
            if (entry2 == null) {
                return 0;
            }
            int aRes = entry2.compareTo(entry1);
            if (aRes == 0) {
                return 0;
            }
            if (res == 0) {
                res = aRes;
                continue;
            }
            if (res == aRes) continue;
            return 0;
        }
        return res;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectAndLibrariesScope.isSearchInModuleContent must not be null");
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return PsiBundle.message("psi.search.scope.project.and.libraries", new Object[0]);
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectAndLibrariesScope.intersectWith must not be null");
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectAndLibrariesScope.intersectWith must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectAndLibrariesScope.uniteWith must not be null");
        }
        return this;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

