/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.filtered;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class FilteringTreeBuilder
extends AbstractTreeBuilder {
    private Object myLastSuccessfulSelect;
    private final Tree myTree;
    private MergingUpdateQueue myRefilterQueue;

    public FilteringTreeBuilder(Project project, Tree tree, ElementFilter filter, AbstractTreeStructure structure, Comparator<NodeDescriptor> comparator) {
        super(tree, (DefaultTreeModel)tree.getModel(), new FilteringTreeStructure(project, filter, structure), comparator);
        this.myTree = tree;
        this.initRootNode();
        if (filter instanceof ElementFilter.Active) {
            ((ElementFilter.Active)filter).addListener(new ElementFilter.Listener(){

                public ActionCallback update(Object preferredSelection, boolean adjustSelection, boolean now) {
                    return FilteringTreeBuilder.this.refilter(preferredSelection, adjustSelection, now);
                }
            }, this);
        }
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object element;
                TreePath newPath = e.getNewLeadSelectionPath();
                if (newPath != null && (element = FilteringTreeBuilder.this.getElementFor(newPath.getLastPathComponent())) != null) {
                    FilteringTreeBuilder.this.myLastSuccessfulSelect = element;
                }
            }
        });
    }

    @Override
    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return false;
    }

    @Override
    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return true;
    }

    protected final DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new PatchedDefaultMutableTreeNode(childDescr);
    }

    public void setFilteringMerge(int gap, @Nullable JComponent modalityStateComponent) {
        if (this.myRefilterQueue != null) {
            Disposer.dispose((Disposable)this.myRefilterQueue);
            this.myRefilterQueue = null;
        }
        if (gap >= 0) {
            JComponent stateComponent = modalityStateComponent;
            if (stateComponent == null) {
                stateComponent = this.myTree;
            }
            this.myRefilterQueue = new MergingUpdateQueue("FilteringTreeBuilder", gap, false, stateComponent, this, this.myTree);
            this.myRefilterQueue.setRestartTimerOnAdd(true);
        }
    }

    protected boolean isSelectable(Object nodeObject) {
        return true;
    }

    public void refilter() {
        this.refilter(null, true, false);
    }

    public ActionCallback refilter(final Object preferredSelection, final boolean adjustSelection, boolean now) {
        if (this.myRefilterQueue == null || now) {
            return this.refilterNow(preferredSelection, adjustSelection);
        }
        final ActionCallback result = new ActionCallback();
        this.myRefilterQueue.queue(new Update(this){

            @Override
            public void run() {
                FilteringTreeBuilder.this.refilterNow(preferredSelection, adjustSelection).notifyWhenDone(result);
            }

            @Override
            public void setRejected() {
                super.setRejected();
                result.setDone();
            }
        });
        return result;
    }

    protected ActionCallback refilterNow(final Object preferredSelection, final boolean adjustSelection) {
        final ActionCallback selectionDone = new ActionCallback();
        this.getFilteredStructure().refilter();
        this.updateFromRoot();
        this.getReady(this).doWhenDone(new Runnable(){

            @Override
            public void run() {
                Object toSelect;
                Object object = toSelect = preferredSelection != null ? preferredSelection : FilteringTreeBuilder.this.myLastSuccessfulSelect;
                if (adjustSelection && toSelect != null) {
                    final FilteringTreeStructure.Node nodeToSelect = FilteringTreeBuilder.this.getFilteredStructure().getVisibleNodeFor(toSelect);
                    if (nodeToSelect != null) {
                        FilteringTreeBuilder.this.select(nodeToSelect, new Runnable(){

                            @Override
                            public void run() {
                                if (FilteringTreeBuilder.this.getSelectedElements().contains(nodeToSelect)) {
                                    FilteringTreeBuilder.this.myLastSuccessfulSelect = FilteringTreeBuilder.this.getOriginalNode(nodeToSelect);
                                }
                                selectionDone.setDone();
                            }
                        });
                    } else {
                        TreeUtil.ensureSelection(FilteringTreeBuilder.this.myTree);
                        selectionDone.setDone();
                    }
                } else {
                    selectionDone.setDone();
                }
            }
        });
        final ActionCallback result = new ActionCallback();
        selectionDone.doWhenDone(new Runnable(){

            @Override
            public void run() {
                FilteringTreeBuilder.this.scrollSelectionToVisible(new Runnable(){

                    @Override
                    public void run() {
                        FilteringTreeBuilder.this.getReady(this).notify(result);
                    }
                }, false);
            }
        });
        return result;
    }

    private FilteringTreeStructure getFilteredStructure() {
        return (FilteringTreeStructure)this.getTreeStructure();
    }

    private boolean isSimpleTree() {
        return this.myTree instanceof SimpleTree;
    }

    @Nullable
    private Object getSelected() {
        if (this.isSimpleTree()) {
            FilteringTreeStructure.Node selected = (FilteringTreeStructure.Node)((SimpleTree)this.myTree).getSelectedNode();
            return selected != null ? selected.getDelegate() : null;
        }
        Object[] nodes = this.myTree.getSelectedNodes(Object.class, null);
        return nodes.length > 0 ? nodes[0] : null;
    }

    public FilteringTreeStructure.Node getVisibleNodeFor(Object nodeObject) {
        return this.getFilteredStructure().getVisibleNodeFor(nodeObject);
    }

    public Object getOriginalNode(Object node) {
        return ((FilteringTreeStructure.Node)node).getDelegate();
    }

    @Override
    protected Object transformElement(Object object) {
        return this.getOriginalNode(object);
    }

    @Nullable
    public Object getElementFor(Object node) {
        return this.getUi().getElementFor(node);
    }
}

