/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ListTreeTableModelOnColumns
extends DefaultTreeModel
implements TreeTableModel,
SortableColumnModel {
    private ColumnInfo[] myColumns;

    public ListTreeTableModelOnColumns(TreeNode root, ColumnInfo[] columns) {
        super(root);
        this.myColumns = columns;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public Object getValueAt(Object value, int column) {
        return this.myColumns[column].valueOf(value);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    @Override
    public Class getColumnClass(int column) {
        return this.myColumns[column].getColumnClass();
    }

    public ColumnInfo[] getColumns() {
        return this.myColumns;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.myColumns[column].isCellEditable(node);
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        this.myColumns[column].setValue(node, aValue);
    }

    public boolean setColumns(ColumnInfo[] columns) {
        if (this.myColumns != null && Arrays.equals(this.myColumns, columns)) {
            return false;
        }
        this.myColumns = columns;
        return true;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.myColumns;
    }

    public List getItems() {
        ArrayList result = new ArrayList();
        TreeNode root = (TreeNode)this.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.addElementsToCollection(root.getChildAt(i), result);
        }
        return result;
    }

    private void addElementsToCollection(TreeNode parent, Collection collection) {
        collection.add(parent);
        Enumeration<? extends TreeNode> children = parent.children();
        if (children == null) {
            return;
        }
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            this.addElementsToCollection(child, collection);
        }
    }

    public void sortByColumn(int columnIndex) {
    }

    public void sortByColumn(int columnIndex, int sortingType) {
    }

    public int getSortedColumnIndex() {
        return -1;
    }

    public int getSortingType() {
        return -1;
    }

    public void setSortable(boolean aBoolean) {
    }

    public boolean isSortable() {
        return false;
    }
}

