/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ReporterConfig;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestNGCommandLineArgs {
    private static final Logger LOGGER = Logger.getLogger(class$org$testng$TestNGCommandLineArgs == null ? (class$org$testng$TestNGCommandLineArgs = TestNGCommandLineArgs.class$("org.testng.TestNGCommandLineArgs")) : class$org$testng$TestNGCommandLineArgs);
    public static final String SHOW_TESTNG_STACK_FRAMES = "testng.show.stack.frames";
    public static final String TEST_CLASSPATH = "testng.test.classpath";
    public static final String PORT_COMMAND_OPT = "-port";
    public static final String HOST_COMMAND_OPT = "-host";
    public static final String LOG = "-log";
    public static final String TARGET_COMMAND_OPT = "-target";
    public static final String ANNOTATIONS_COMMAND_OPT = "-annotations";
    public static final String OUTDIR_COMMAND_OPT = "-d";
    public static final String EXCLUDED_GROUPS_COMMAND_OPT = "-excludegroups";
    public static final String GROUPS_COMMAND_OPT = "-groups";
    public static final String JUNIT_DEF_OPT = "-junit";
    public static final String LISTENER_COMMAND_OPT = "-listener";
    public static final String MASTER_OPT = "-master";
    public static final String OBJECT_FACTORY_COMMAND_OPT = "-objectfactory";
    public static final String REPORTER = "-reporter";
    public static final String REPORTERS_LIST = "-reporterslist";
    public static final String PARALLEL_MODE = "-parallel";
    public static final String SKIP_FAILED_INVOCATION_COUNT_OPT = "-skipfailedinvocationcounts";
    public static final String SLAVE_OPT = "-slave";
    public static final String SRC_COMMAND_OPT = "-sourcedir";
    public static final String SUITE_NAME_OPT = "-suitename";
    public static final String TESTCLASS_COMMAND_OPT = "-testclass";
    public static final String TESTJAR_COMMAND_OPT = "-testjar";
    public static final String TEST_NAME_OPT = "-testname";
    public static final String TESTRUNNER_FACTORY_COMMAND_OPT = "-testrunfactory";
    public static final String THREAD_COUNT = "-threadcount";
    public static final String DATA_PROVIDER_THREAD_COUNT = "-dataproviderthreadcount";
    public static final String USE_DEFAULT_LISTENERS = "-usedefaultlisteners";
    public static final String SUITE_DEF_OPT = "testng.suite.definitions";
    private static int m_lastGoodRootIndex = -1;
    static /* synthetic */ Class class$org$testng$TestNGCommandLineArgs;
    static /* synthetic */ Class class$org$testng$ITestRunnerFactory;
    static /* synthetic */ Class class$org$testng$ITestListener;
    static /* synthetic */ Class class$org$testng$ISuiteListener;

    private TestNGCommandLineArgs() {
    }

    public static Map parseCommandLine(String[] originalArgv) {
        for (int i = 0; i < originalArgv.length; ++i) {
            LOGGER.debug(new StringBuffer().append("originalArgv[").append(i).append("] = \"").append(originalArgv[i]).append("\"").toString());
        }
        LOGGER.debug("TestNG version: \"14\"");
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        String[] argv = TestNGCommandLineArgs.expandArgv(originalArgv);
        for (int i = 0; i < argv.length; ++i) {
            String propertiesFile;
            if (OUTDIR_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(OUTDIR_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    LOGGER.error("WARNING: missing output directory after -d.  ignored");
                }
                ++i;
                continue;
            }
            if (GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i]) || EXCLUDED_GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String option = null;
                    if (argv[i + 1].startsWith("\"")) {
                        if (argv[i + 1].endsWith("\"")) {
                            option = argv[i + 1].substring(1, argv[i + 1].length() - 1);
                        } else {
                            LOGGER.error(new StringBuffer().append("WARNING: groups option is not well quoted:").append(argv[i + 1]).toString());
                            option = argv[i + 1].substring(1);
                        }
                    } else {
                        option = argv[i + 1];
                    }
                    String opt = GROUPS_COMMAND_OPT.equalsIgnoreCase(argv[i]) ? GROUPS_COMMAND_OPT : EXCLUDED_GROUPS_COMMAND_OPT;
                    arguments.put(opt, option);
                } else {
                    LOGGER.error("WARNING: missing groups parameter after -groups. ignored");
                }
                ++i;
                continue;
            }
            if (LOG.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(LOG, Integer.valueOf(argv[i + 1].trim()));
                } else {
                    LOGGER.error("WARNING: missing log level after -log.  ignored");
                }
                ++i;
                continue;
            }
            if (JUNIT_DEF_OPT.equalsIgnoreCase(argv[i])) {
                arguments.put(JUNIT_DEF_OPT, Boolean.TRUE);
                continue;
            }
            if (TARGET_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(ANNOTATIONS_COMMAND_OPT, AnnotationTypeEnum.valueOf(argv[i + 1]));
                LOGGER.warn("The usage of -target has been deprecated. Please use -annotations instead.");
                ++i;
                continue;
            }
            if (ANNOTATIONS_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(ANNOTATIONS_COMMAND_OPT, AnnotationTypeEnum.valueOf(argv[i + 1]));
                ++i;
                continue;
            }
            if (TESTRUNNER_FACTORY_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(TESTRUNNER_FACTORY_COMMAND_OPT, TestNGCommandLineArgs.fileToClass(argv[++i]));
                    continue;
                }
                LOGGER.error("WARNING: missing ITestRunnerFactory class or file argument after -testrunfactory");
                continue;
            }
            if (OBJECT_FACTORY_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    Class<?> cls = TestNGCommandLineArgs.fileToClass(argv[++i]);
                    arguments.put(OBJECT_FACTORY_COMMAND_OPT, cls);
                    continue;
                }
                LOGGER.error("WARNING: missing IObjectFactory class/file list argument after -objectfactory");
                continue;
            }
            if (LISTENER_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String strClass = argv[++i];
                    String sep = ";";
                    if (strClass.indexOf(",") >= 0) {
                        sep = ",";
                    }
                    String[] strs = Utils.split(strClass, sep);
                    ArrayList classes = new ArrayList();
                    for (String cls : strs) {
                        classes.add(TestNGCommandLineArgs.fileToClass(cls));
                    }
                    arguments.put(LISTENER_COMMAND_OPT, classes);
                    continue;
                }
                LOGGER.error("WARNING: missing ITestListener class/file list argument after -listener");
                continue;
            }
            if (TESTCLASS_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    String nextArg;
                    while (i + 1 < argv.length && !(nextArg = argv[i + 1].trim()).toLowerCase().endsWith(".xml") && !nextArg.startsWith("-")) {
                        Class<?> cls;
                        ArrayList l = (ArrayList)arguments.get(TESTCLASS_COMMAND_OPT);
                        if (null == l) {
                            l = new ArrayList();
                            arguments.put(TESTCLASS_COMMAND_OPT, l);
                        }
                        if (null != (cls = TestNGCommandLineArgs.fileToClass(nextArg))) {
                            l.add(cls);
                        }
                        ++i;
                    }
                    continue;
                }
                TestNG.exitWithError("-testclass must be followed by a classname");
                continue;
            }
            if (TESTJAR_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(TESTJAR_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    TestNG.exitWithError("-testjar must be followed by a valid jar");
                }
                ++i;
                continue;
            }
            if (SRC_COMMAND_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 < argv.length) {
                    arguments.put(SRC_COMMAND_OPT, argv[i + 1].trim());
                } else {
                    TestNG.exitWithError("-sourcedir must be followed by a directory path");
                }
                ++i;
                continue;
            }
            if (HOST_COMMAND_OPT.equals(argv[i])) {
                String hostAddress = "127.0.0.1";
                if (i + 1 < argv.length) {
                    hostAddress = argv[i + 1].trim();
                    ++i;
                } else {
                    LOGGER.warn("WARNING: -host option should be followed by the host address. Using default localhost.");
                }
                arguments.put(HOST_COMMAND_OPT, hostAddress);
                continue;
            }
            if (PORT_COMMAND_OPT.equals(argv[i])) {
                String portNumber = null;
                if (i + 1 < argv.length) {
                    portNumber = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-port option should be followed by a valid port number.");
                }
                arguments.put(PORT_COMMAND_OPT, portNumber);
                ++i;
                continue;
            }
            if (SLAVE_OPT.equals(argv[i])) {
                propertiesFile = null;
                if (i + 1 < argv.length) {
                    propertiesFile = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-slave option should be followed by a valid file path.");
                }
                arguments.put(SLAVE_OPT, propertiesFile);
                ++i;
                continue;
            }
            if (MASTER_OPT.equals(argv[i])) {
                propertiesFile = null;
                if (i + 1 < argv.length) {
                    propertiesFile = argv[i + 1].trim();
                } else {
                    TestNG.exitWithError("-master option should be followed by a valid file path.");
                }
                arguments.put(MASTER_OPT, propertiesFile);
                ++i;
                continue;
            }
            if (PARALLEL_MODE.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(PARALLEL_MODE, argv[i + 1]);
                ++i;
                continue;
            }
            if (THREAD_COUNT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(THREAD_COUNT, argv[i + 1]);
                ++i;
                continue;
            }
            if (DATA_PROVIDER_THREAD_COUNT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(DATA_PROVIDER_THREAD_COUNT, argv[i + 1]);
                ++i;
                continue;
            }
            if (USE_DEFAULT_LISTENERS.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(USE_DEFAULT_LISTENERS, argv[i + 1]);
                ++i;
                continue;
            }
            if (SUITE_NAME_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(SUITE_NAME_OPT, TestNGCommandLineArgs.trim(argv[i + 1]));
                ++i;
                continue;
            }
            if (TEST_NAME_OPT.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                arguments.put(TEST_NAME_OPT, TestNGCommandLineArgs.trim(argv[i + 1]));
                ++i;
                continue;
            }
            if (REPORTER.equalsIgnoreCase(argv[i])) {
                if (i + 1 >= argv.length) continue;
                ReporterConfig reporterConfig = ReporterConfig.deserialize(TestNGCommandLineArgs.trim(argv[i + 1]));
                if (arguments.get(REPORTERS_LIST) == null) {
                    arguments.put(REPORTERS_LIST, new ArrayList());
                }
                ((List)arguments.get(REPORTERS_LIST)).add(reporterConfig);
                ++i;
                continue;
            }
            if (SKIP_FAILED_INVOCATION_COUNT_OPT.equalsIgnoreCase(argv[i])) {
                arguments.put(SKIP_FAILED_INVOCATION_COUNT_OPT, Boolean.TRUE);
                continue;
            }
            if (argv[i].startsWith("-")) {
                TestNG.exitWithError(new StringBuffer().append("Unknown option: ").append(argv[i]).toString());
                continue;
            }
            if (arguments.get(SUITE_DEF_OPT) != null) continue;
            ArrayList<String> suiteDefs = new ArrayList<String>();
            for (int k = i; k < argv.length; ++k) {
                String file = argv[k].trim();
                if (!file.toLowerCase().endsWith(".xml")) continue;
                suiteDefs.add(file);
            }
            arguments.put(SUITE_DEF_OPT, suiteDefs);
        }
        for (Map.Entry entry : arguments.entrySet()) {
            LOGGER.debug(new StringBuffer().append("parseCommandLine argument: \"").append(entry.getKey()).append("\" = \"").append(entry.getValue()).append("\"").toString());
        }
        return arguments;
    }

    private static String trim(String string) {
        String trimSpaces = string.trim();
        if (trimSpaces.startsWith("\"")) {
            if (trimSpaces.endsWith("\"")) {
                return trimSpaces.substring(1, trimSpaces.length() - 1);
            }
            return trimSpaces.substring(1);
        }
        return trimSpaces;
    }

    private static String[] expandArgv(String[] originalArgv) {
        ArrayList<String> vResult = new ArrayList<String>();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult.addAll(TestNGCommandLineArgs.readFile(fileName));
                continue;
            }
            vResult.add(arg);
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    public static List<String> readFile(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            LOGGER.error("IO exception reading command line file", e);
        }
        return result;
    }

    private static Class<?> fileToClass(String file) {
        int i;
        String className;
        Class<?> result = null;
        if (!file.endsWith(".class") && !file.endsWith(".java")) {
            result = ClassHelper.forName(file);
            if (null == result) {
                throw new TestNGException(new StringBuffer().append("Cannot load class from file: ").append(file).toString());
            }
            return result;
        }
        int classIndex = file.lastIndexOf(".class");
        if (-1 == classIndex) {
            classIndex = file.lastIndexOf(".java");
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != m_lastGoodRootIndex) {
            className = segments[m_lastGoodRootIndex];
            for (i = m_lastGoodRootIndex + 1; i < segments.length; ++i) {
                className = new StringBuffer().append(className).append(".").append(segments[i]).toString();
            }
            result = ClassHelper.forName(className);
            if (null != result) {
                return result;
            }
        }
        className = null;
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName(className = null == className ? segments[i] : new StringBuffer().append(segments[i]).append(".").append(className).toString());
            if (null == result) continue;
            m_lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException(new StringBuffer().append("Cannot load class from file: ").append(file).toString());
        }
        return result;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("[-d output-directory]");
        System.out.println("\t\tdefault output directory to : test-output");
        System.out.println("[-testclass list of .class files or list of class names]");
        System.out.println("[-sourcedir a source directory]");
        System.out.println(new StringBuffer().append("[-annotations ").append(AnnotationTypeEnum.JAVADOC.getName()).append("]").toString());
        System.out.println("\t\tSpecifies the default annotation type to be used in suites when none is explicitly specified.");
        System.out.println(new StringBuffer().append("\t\tThis version of TestNG (14) only supports ").append(AnnotationTypeEnum.JAVADOC.getName()).append(" annotation type.").toString());
        System.out.println(new StringBuffer().append("\t\tFor interface compatibility reasons, we allow this value to be explicitly set to ").append(AnnotationTypeEnum.JAVADOC.getName()).append("\"  ").toString());
        System.out.println("[-groups comma-separated list of group names to be run]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println("[-excludegroups comma-separated list of group names to be excluded]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println(new StringBuffer().append("[-testrunfactory list of .class files or list of class names implementing ").append((class$org$testng$ITestRunnerFactory == null ? (class$org$testng$ITestRunnerFactory = TestNGCommandLineArgs.class$("org.testng.ITestRunnerFactory")) : class$org$testng$ITestRunnerFactory).getName()).append("]").toString());
        System.out.println(new StringBuffer().append("[-listener list of .class files or list of class names implementing ").append((class$org$testng$ITestListener == null ? (class$org$testng$ITestListener = TestNGCommandLineArgs.class$("org.testng.ITestListener")) : class$org$testng$ITestListener).getName()).append(" and/or ").append((class$org$testng$ISuiteListener == null ? (class$org$testng$ISuiteListener = TestNGCommandLineArgs.class$("org.testng.ISuiteListener")) : class$org$testng$ISuiteListener).getName()).append("]").toString());
        System.out.println("[-parallel methods|tests]");
        System.out.println("\t\trun tests in parallel using the specified mode");
        System.out.println("[-threadcount number of threads to use when running tests in parallel]");
        System.out.println("[-suitename name]");
        System.out.println("\t\tDefault name of test suite, if not specified in suite definition file or source code");
        System.out.println("[-testname Name]");
        System.out.println("\t\tDefault name of test, if not specified in suite definition file or source code");
        System.out.println("[-reporter Extended configuration for custom report listener]");
        System.out.println("[suite definition files*]");
        System.out.println("");
        System.out.println("For details, please consult the documentation at http://testng.org.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

