/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.annotate;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.annotate.CvsFileAnnotation;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.AnnotateOperation;
import com.intellij.cvsSupport2.history.CvsHistoryProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;

public class CvsAnnotationProvider
implements AnnotationProvider {
    private final Project myProject;

    public CvsAnnotationProvider(Project project) {
        this.myProject = project;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        AnnotateOperation operation = AnnotateOperation.createForFile(new File(file.getPath()));
        CvsOperationExecutor executor = new CvsOperationExecutor(true, this.myProject, ModalityState.defaultModalityState());
        executor.performActionSync(new CommandCvsHandler(CvsBundle.getAnnotateOperationName(), operation), CvsOperationExecutorCallback.EMPTY);
        if (executor.getResult().hasNoErrors()) {
            CvsHistoryProvider historyProvider = (CvsHistoryProvider)CvsVcs2.getInstance(this.myProject).getVcsHistoryProvider();
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
            List<VcsFileRevision> revisions = historyProvider.createRevisions(filePath);
            return new CvsFileAnnotation(operation.getContent(), operation.getLineAnnotations(), revisions, file);
        }
        throw executor.getFirstError();
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParent());
        return CvsVcs2.getInstance(this.myProject).createAnnotation(file, revision.getRevisionNumber().asString(), settings);
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        return true;
    }
}

