/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class EqualsPredicate
implements PsiElementPredicate {
    EqualsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        if (!"equals".equals(methodName)) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

