/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodOnlyUsedFromInnerClassInspection
extends BaseInspection {
    public boolean ignoreMethodsAccessedFromAnonymousClass = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String name = element.getName();
        if (infos.length > 1) {
            if (!(Boolean.TRUE.equals(infos[1]) ? (string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.extending", name)) != null : (string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.implementing", name)) != null)) throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor", name);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection.buildErrorString must not return null");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("method.only.used.from.inner.class.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreMethodsAccessedFromAnonymousClass");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOnlyUsedFromInnerClassVisitor();
    }

    private class MethodReferenceFinder
    implements Processor<PsiReference> {
        private final PsiClass methodClass;
        private final PsiMethod method;
        private boolean onlyAccessedFromInnerClass;
        private PsiClass cache;

        MethodReferenceFinder(PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection$MethodReferenceFinder.<init> must not be null");
            }
            this.onlyAccessedFromInnerClass = false;
            this.cache = null;
            this.method = method;
            this.methodClass = method.getContainingClass();
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (this.method.equals(containingMethod)) {
                return true;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(element);
            if (containingClass == null) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            if (MethodOnlyUsedFromInnerClassInspection.this.ignoreMethodsAccessedFromAnonymousClass && containingClass instanceof PsiAnonymousClass) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            if (this.cache != null) {
                if (!this.cache.equals(containingClass)) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
            } else if (!PsiTreeUtil.isAncestor((PsiElement)this.methodClass, (PsiElement)containingClass, (boolean)true)) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            this.onlyAccessedFromInnerClass = true;
            this.cache = containingClass;
            return true;
        }

        public boolean isOnlyAccessedFromInnerClass() {
            Query query = ReferencesSearch.search((PsiElement)this.method);
            query.forEach((Processor)this);
            return this.onlyAccessedFromInnerClass;
        }

        public PsiClass getContainingClass() {
            return this.cache;
        }
    }

    private class MethodOnlyUsedFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private MethodOnlyUsedFromInnerClassVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("private") || method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            MethodReferenceFinder processor = new MethodReferenceFinder(method);
            if (!processor.isOnlyAccessedFromInnerClass()) {
                return;
            }
            PsiClass containingClass = processor.getContainingClass();
            if (containingClass instanceof PsiAnonymousClass) {
                PsiClass[] interfaces = containingClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method, superClass, false);
                } else {
                    PsiClass superClass = containingClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method, superClass, true);
                }
            } else {
                this.registerMethodError(method, containingClass);
            }
        }
    }
}

