/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DoubleNegationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DoubleNegationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return;
            }
            this.checkParent((PsiExpression)expression);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return;
            }
            this.checkParent((PsiExpression)expression);
        }

        private void checkParent(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(parentTokenType)) {
                return;
            }
            this.registerError((PsiElement)prefixExpression, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPrefixExpression expression = (PsiPrefixExpression)descriptor.getPsiElement();
            PsiExpression operand = expression.getOperand();
            while (operand instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)operand;
                operand = parenthesizedExpression.getExpression();
            }
            if (operand instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)operand;
                PsiExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                expression.replace((PsiElement)innerOperand);
            } else if (operand instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
                PsiExpression lhs = binaryExpression.getLOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                PsiManager manager = binaryExpression.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiExpression newExpression = factory.createExpressionFromText(builder.toString(), (PsiElement)binaryExpression);
                expression.replace((PsiElement)newExpression);
            }
        }
    }
}

