/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ThisEscapedInConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ThisEscapedInObjectConstruction" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/ThisEscapedInConstructorInspection.getID must not return null");
        }
        return "ThisEscapedInObjectConstruction";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("this.reference.escaped.in.construction.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/ThisEscapedInConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("this.reference.escaped.in.construction.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/ThisEscapedInConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThisExposedInConstructorInspectionVisitor();
    }

    private static class ThisExposedInConstructorInspectionVisitor
    extends BaseInspectionVisitor {
        private ThisExposedInConstructorInspectionVisitor() {
        }

        public void visitThisExpression(PsiThisExpression expression) {
            PsiElement parent;
            super.visitThisExpression(expression);
            if (!ThisExposedInConstructorInspectionVisitor.isInInitializer((PsiElement)expression)) {
                return;
            }
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (qualifier != null) {
                PsiElement element = qualifier.resolve();
                if (!(element instanceof PsiClass)) {
                    return;
                }
                PsiClass aClass = (PsiClass)element;
                if (!aClass.equals(containingClass)) {
                    return;
                }
            }
            if ((parent = expression.getParent()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToField(expression, assignmentExpression)) {
                    return;
                }
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)grandParent;
                    if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToConstructor(expression, newExpression)) {
                        return;
                    }
                    this.registerError((PsiElement)expression, new Object[0]);
                } else if (grandParent instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                    if (!ThisExposedInConstructorInspectionVisitor.thisEscapesToMethod(expression, methodCallExpression)) {
                        return;
                    }
                    this.registerError((PsiElement)expression, new Object[0]);
                }
            }
        }

        private static boolean thisEscapesToMethod(PsiThisExpression expression, PsiMethodCallExpression methodCallExpression) {
            PsiField field;
            PsiClass fieldClass;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (containingClass == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (!method.hasModifierProperty("static") && containingClass.isInheritor(methodClass, true)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression qualifiedExpression = (PsiReferenceExpression)qualifier;
            PsiElement referent = qualifiedExpression.resolve();
            return !(referent instanceof PsiField) || !containingClass.equals(fieldClass = (field = (PsiField)referent).getContainingClass()) && !containingClass.isInheritor(fieldClass, true);
        }

        private static boolean thisEscapesToConstructor(PsiThisExpression expression, PsiNewExpression newExpression) {
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression);
            PsiJavaCodeReferenceElement referenceElement = newExpression.getClassReference();
            if (referenceElement == null) {
                return false;
            }
            PsiElement element = referenceElement.resolve();
            if (!(element instanceof PsiClass)) {
                return false;
            }
            PsiClass constructorClass = (PsiClass)element;
            return !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)constructorClass, (boolean)false) || constructorClass.hasModifierProperty("static");
        }

        private static boolean thisEscapesToField(PsiThisExpression expression, PsiAssignmentExpression assignmentExpression) {
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!expression.equals(rhs)) {
                return false;
            }
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (!(lExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression leftExpression = (PsiReferenceExpression)lExpression;
            PsiElement element = leftExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("static")) {
                return true;
            }
            PsiClass assignmentClass = ClassUtils.getContainingClass((PsiElement)assignmentExpression);
            PsiClass fieldClass = field.getContainingClass();
            return assignmentClass != null && !assignmentClass.isInheritor(fieldClass, true) && !PsiTreeUtil.isAncestor((PsiElement)assignmentClass, (PsiElement)fieldClass, (boolean)false);
        }

        private static boolean isInInitializer(PsiElement call) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            if (method != null) {
                return method.isConstructor();
            }
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)call, PsiField.class);
            if (field != null) {
                return true;
            }
            PsiClassInitializer classInitializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)call, PsiClassInitializer.class);
            return classInitializer != null && !classInitializer.hasModifierProperty("static");
        }
    }
}

