/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import org.jetbrains.annotations.NotNull;

public class OctalLiteralInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("OctalInteger" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OctalLiteralInspection.getID must not return null");
        }
        return "OctalInteger";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("octal.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OctalLiteralInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("octal.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OctalLiteralInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OctalLiteralInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalLiteralVisitor();
    }

    private static class OctalLiteralVisitor
    extends BaseInspectionVisitor {
        private OctalLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/OctalLiteralInspection$OctalLiteralVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(literal);
            PsiType type = literal.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.INT) && !type.equals(PsiType.LONG)) {
                return;
            }
            String text = literal.getText();
            if ("0".equals(text) || "0L".equals(text) || "0l".equals(text)) {
                return;
            }
            if (text.charAt(0) != '0') {
                return;
            }
            if (text.startsWith("0x") || text.startsWith("0X")) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }
    }
}

