/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryUnaryMinusInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryUnaryMinusFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryUnaryMinusVisitor();
    }

    private static class UnnecessaryUnaryMinusVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryUnaryMinusVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            IElementType operationTokenType = expression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(operationTokenType)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                IElementType binaryExpressionTokenType = binaryExpression.getOperationTokenType();
                if (!JavaTokenType.PLUS.equals(binaryExpressionTokenType)) {
                    return;
                }
                PsiExpression rhs = binaryExpression.getROperand();
                if (!expression.equals(rhs)) {
                    return;
                }
                this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                IElementType assignmentTokenType = assignmentExpression.getOperationTokenType();
                if (!JavaTokenType.PLUSEQ.equals(assignmentTokenType)) {
                    return;
                }
                this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
            }
        }
    }

    private static class UnnecessaryUnaryMinusFix
    extends InspectionGadgetsFix {
        private UnnecessaryUnaryMinusFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.unary.minus.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/UnnecessaryUnaryMinusInspection$UnnecessaryUnaryMinusFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element.getParent();
            PsiExpression parentExpression = (PsiExpression)prefixExpression.getParent();
            StringBuilder newExpression = new StringBuilder();
            if (parentExpression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parentExpression;
                PsiExpression lhs = assignmentExpression.getLExpression();
                newExpression.append(lhs.getText());
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.PLUSEQ)) {
                    newExpression.append("-=");
                } else {
                    newExpression.append("+=");
                }
            } else if (parentExpression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parentExpression;
                PsiExpression lhs = binaryExpression.getLOperand();
                newExpression.append(lhs.getText());
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.PLUS)) {
                    newExpression.append('-');
                } else {
                    newExpression.append('+');
                }
            }
            PsiExpression operand = prefixExpression.getOperand();
            if (operand == null) {
                return;
            }
            newExpression.append(operand.getText());
            UnnecessaryUnaryMinusFix.replaceExpression(parentExpression, newExpression.toString());
        }
    }
}

