/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsHashCodeCalledOnUrlInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.hashcode.called.on.url.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/EqualsHashCodeCalledOnUrlInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.hashcode.called.on.url.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/EqualsHashCodeCalledOnUrlInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsHashCodeCalledOnUrlVisitor();
    }

    private static class EqualsHashCodeCalledOnUrlVisitor
    extends BaseInspectionVisitor {
        private EqualsHashCodeCalledOnUrlVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiMethod method = expression.resolveMethod();
            if (!MethodUtils.isEquals(method) && !MethodUtils.isHashCode(method)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasType("java.net.URL", qualifier)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

