/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquivalenceChecker {
    private EquivalenceChecker() {
    }

    public static boolean modifierListsAreEquivalent(@Nullable PsiModifierList list1, @Nullable PsiModifierList list2) {
        PsiAnnotation[] annotations;
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        for (PsiAnnotation annotation : annotations = list1.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            if (list2.findAnnotation(qualifiedName) != null) continue;
            return false;
        }
        if (list1.hasModifierProperty("abstract") && !list2.hasModifierProperty("abstract")) {
            return false;
        }
        if (list1.hasModifierProperty("final") && !list2.hasModifierProperty("final")) {
            return false;
        }
        if (list1.hasModifierProperty("native") && !list2.hasModifierProperty("native")) {
            return false;
        }
        if (list1.hasModifierProperty("packageLocal") && !list2.hasModifierProperty("packageLocal")) {
            return false;
        }
        if (list1.hasModifierProperty("private") && !list2.hasModifierProperty("private")) {
            return false;
        }
        if (list1.hasModifierProperty("protected") && !list2.hasModifierProperty("protected")) {
            return false;
        }
        if (list1.hasModifierProperty("public") && !list2.hasModifierProperty("public")) {
            return false;
        }
        if (list1.hasModifierProperty("static") && !list2.hasModifierProperty("static")) {
            return false;
        }
        if (list1.hasModifierProperty("strictfp") && !list2.hasModifierProperty("strictfp")) {
            return false;
        }
        if (list1.hasModifierProperty("synchronized") && !list2.hasModifierProperty("synchronized")) {
            return false;
        }
        if (list1.hasModifierProperty("transient") && !list2.hasModifierProperty("transient")) {
            return false;
        }
        return !list1.hasModifierProperty("volatile") || list2.hasModifierProperty("volatile");
    }

    public static boolean statementsAreEquivalent(@Nullable PsiStatement statement1, @Nullable PsiStatement statement2) {
        if (statement1 == null && statement2 == null) {
            return true;
        }
        if (statement1 == null || statement2 == null) {
            return false;
        }
        if (statement1.getClass() != statement2.getClass()) {
            return false;
        }
        if (statement1 instanceof PsiAssertStatement) {
            PsiAssertStatement assertStatement1 = (PsiAssertStatement)statement1;
            PsiAssertStatement assertStatement2 = (PsiAssertStatement)statement2;
            return EquivalenceChecker.assertStatementsAreEquivalent(assertStatement1, assertStatement2);
        }
        if (statement1 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement1 = (PsiBlockStatement)statement1;
            PsiBlockStatement blockStatement2 = (PsiBlockStatement)statement2;
            return EquivalenceChecker.blockStatementsAreEquivalent(blockStatement1, blockStatement2);
        }
        if (statement1 instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement1 = (PsiBreakStatement)statement1;
            PsiBreakStatement breakStatement2 = (PsiBreakStatement)statement2;
            return EquivalenceChecker.breakStatementsAreEquivalent(breakStatement1, breakStatement2);
        }
        if (statement1 instanceof PsiContinueStatement) {
            PsiContinueStatement continueStatement1 = (PsiContinueStatement)statement1;
            PsiContinueStatement continueStatement2 = (PsiContinueStatement)statement2;
            return EquivalenceChecker.continueStatementsAreEquivalent(continueStatement1, continueStatement2);
        }
        if (statement1 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement1 = (PsiDeclarationStatement)statement1;
            PsiDeclarationStatement declarationStatement2 = (PsiDeclarationStatement)statement2;
            return EquivalenceChecker.declarationStatementsAreEquivalent(declarationStatement1, declarationStatement2);
        }
        if (statement1 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement1 = (PsiDoWhileStatement)statement1;
            PsiDoWhileStatement doWhileStatement2 = (PsiDoWhileStatement)statement2;
            return EquivalenceChecker.doWhileStatementsAreEquivalent(doWhileStatement1, doWhileStatement2);
        }
        if (statement1 instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement1 instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement expressionListStatement1 = (PsiExpressionListStatement)statement1;
            PsiExpressionListStatement expressionListStatement2 = (PsiExpressionListStatement)statement2;
            return EquivalenceChecker.expressionListStatementsAreEquivalent(expressionListStatement1, expressionListStatement2);
        }
        if (statement1 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement1 = (PsiExpressionStatement)statement1;
            PsiExpressionStatement expressionStatement2 = (PsiExpressionStatement)statement2;
            return EquivalenceChecker.expressionStatementsAreEquivalent(expressionStatement1, expressionStatement2);
        }
        if (statement1 instanceof PsiForStatement) {
            PsiForStatement forStatement1 = (PsiForStatement)statement1;
            PsiForStatement forStatement2 = (PsiForStatement)statement2;
            return EquivalenceChecker.forStatementsAreEquivalent(forStatement1, forStatement2);
        }
        if (statement1 instanceof PsiForeachStatement) {
            PsiForeachStatement forEachStatement1 = (PsiForeachStatement)statement1;
            PsiForeachStatement forEachStatement2 = (PsiForeachStatement)statement2;
            return EquivalenceChecker.forEachStatementsAreEquivalent(forEachStatement1, forEachStatement2);
        }
        if (statement1 instanceof PsiIfStatement) {
            return EquivalenceChecker.ifStatementsAreEquivalent((PsiIfStatement)statement1, (PsiIfStatement)statement2);
        }
        if (statement1 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement1 = (PsiLabeledStatement)statement1;
            PsiLabeledStatement labeledStatement2 = (PsiLabeledStatement)statement2;
            return EquivalenceChecker.labeledStatementsAreEquivalent(labeledStatement1, labeledStatement2);
        }
        if (statement1 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement1 = (PsiReturnStatement)statement1;
            PsiReturnStatement returnStatement2 = (PsiReturnStatement)statement2;
            return EquivalenceChecker.returnStatementsAreEquivalent(returnStatement1, returnStatement2);
        }
        if (statement1 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement1 = (PsiSwitchStatement)statement1;
            PsiSwitchStatement switchStatement2 = (PsiSwitchStatement)statement2;
            return EquivalenceChecker.switchStatementsAreEquivalent(switchStatement1, switchStatement2);
        }
        if (statement1 instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatement switchLabelStatement1 = (PsiSwitchLabelStatement)statement1;
            PsiSwitchLabelStatement switchLabelStatement2 = (PsiSwitchLabelStatement)statement2;
            return EquivalenceChecker.switchLabelStatementsAreEquivalent(switchLabelStatement1, switchLabelStatement2);
        }
        if (statement1 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement1 = (PsiSynchronizedStatement)statement1;
            PsiSynchronizedStatement synchronizedStatement2 = (PsiSynchronizedStatement)statement2;
            return EquivalenceChecker.synchronizedStatementsAreEquivalent(synchronizedStatement1, synchronizedStatement2);
        }
        if (statement1 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement1 = (PsiThrowStatement)statement1;
            PsiThrowStatement throwStatement2 = (PsiThrowStatement)statement2;
            return EquivalenceChecker.throwStatementsAreEquivalent(throwStatement1, throwStatement2);
        }
        if (statement1 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement1 = (PsiTryStatement)statement1;
            PsiTryStatement tryStatement2 = (PsiTryStatement)statement2;
            return EquivalenceChecker.tryStatementsAreEquivalent(tryStatement1, tryStatement2);
        }
        if (statement1 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement1 = (PsiWhileStatement)statement1;
            PsiWhileStatement whileStatement2 = (PsiWhileStatement)statement2;
            return EquivalenceChecker.whileStatementsAreEquivalent(whileStatement1, whileStatement2);
        }
        String text1 = statement1.getText();
        String text2 = statement2.getText();
        return text1.equals(text2);
    }

    private static boolean declarationStatementsAreEquivalent(@NotNull PsiDeclarationStatement statement1, @NotNull PsiDeclarationStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.declarationStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.declarationStatementsAreEquivalent must not be null");
        }
        PsiElement[] elements1 = statement1.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars1 = new ArrayList<PsiLocalVariable>(elements1.length);
        for (PsiElement anElement : elements1) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars1.add((PsiLocalVariable)anElement);
        }
        PsiElement[] elements2 = statement2.getDeclaredElements();
        ArrayList<PsiLocalVariable> vars2 = new ArrayList<PsiLocalVariable>(elements2.length);
        for (PsiElement anElement : elements2) {
            if (!(anElement instanceof PsiLocalVariable)) continue;
            vars2.add((PsiLocalVariable)anElement);
        }
        int size = vars1.size();
        if (size != vars2.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            PsiLocalVariable var2;
            PsiLocalVariable var1 = (PsiLocalVariable)vars1.get(i);
            if (EquivalenceChecker.localVariableAreEquivalent(var1, var2 = (PsiLocalVariable)vars2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean localVariableAreEquivalent(@NotNull PsiLocalVariable var1, @NotNull PsiLocalVariable var2) {
        String name2;
        PsiType type2;
        if (var1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.localVariableAreEquivalent must not be null");
        }
        if (var2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.localVariableAreEquivalent must not be null");
        }
        PsiType type1 = var1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = var2.getType())) {
            return false;
        }
        String name1 = var1.getName();
        if (!name1.equals(name2 = var2.getName())) {
            return false;
        }
        PsiExpression initializer1 = var1.getInitializer();
        PsiExpression initializer2 = var2.getInitializer();
        return EquivalenceChecker.expressionsAreEquivalent(initializer1, initializer2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull PsiTryStatement statement1, @NotNull PsiTryStatement statement2) {
        PsiParameter[] catchParameters2;
        PsiCodeBlock[] catchBlocks2;
        PsiCodeBlock finallyBlock2;
        PsiCodeBlock tryBlock2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.tryStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.tryStatementsAreEquivalent must not be null");
        }
        PsiCodeBlock tryBlock1 = statement1.getTryBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(tryBlock1, tryBlock2 = statement2.getTryBlock())) {
            return false;
        }
        PsiCodeBlock finallyBlock1 = statement1.getFinallyBlock();
        if (!EquivalenceChecker.codeBlocksAreEquivalent(finallyBlock1, finallyBlock2 = statement2.getFinallyBlock())) {
            return false;
        }
        PsiCodeBlock[] catchBlocks1 = statement1.getCatchBlocks();
        if (catchBlocks1.length != (catchBlocks2 = statement2.getCatchBlocks()).length) {
            return false;
        }
        for (int i = 0; i < catchBlocks2.length; ++i) {
            if (EquivalenceChecker.codeBlocksAreEquivalent(catchBlocks1[i], catchBlocks2[i])) continue;
            return false;
        }
        PsiParameter[] catchParameters1 = statement1.getCatchBlockParameters();
        if (catchParameters1.length != (catchParameters2 = statement2.getCatchBlockParameters()).length) {
            return false;
        }
        for (int i = 0; i < catchParameters2.length; ++i) {
            if (EquivalenceChecker.parametersAreEquivalent(catchParameters2[i], catchParameters1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean parametersAreEquivalent(@NotNull PsiParameter parameter1, @NotNull PsiParameter parameter2) {
        PsiType type2;
        if (parameter1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.parametersAreEquivalent must not be null");
        }
        if (parameter2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.parametersAreEquivalent must not be null");
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        return name1.equals(name2);
    }

    public static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        String type1Text = type1.getCanonicalText();
        String type2Text = type2.getCanonicalText();
        return type1Text.equals(type2Text);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull PsiWhileStatement statement1, @NotNull PsiWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.whileStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.whileStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forStatementsAreEquivalent(@NotNull PsiForStatement statement1, @NotNull PsiForStatement statement2) {
        PsiStatement update2;
        PsiStatement initialization2;
        PsiExpression condition2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.forStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.forStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        if (!EquivalenceChecker.expressionsAreEquivalent(condition1, condition2 = statement2.getCondition())) {
            return false;
        }
        PsiStatement initialization1 = statement1.getInitialization();
        if (!EquivalenceChecker.statementsAreEquivalent(initialization1, initialization2 = statement2.getInitialization())) {
            return false;
        }
        PsiStatement update1 = statement1.getUpdate();
        if (!EquivalenceChecker.statementsAreEquivalent(update1, update2 = statement2.getUpdate())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forEachStatementsAreEquivalent(@NotNull PsiForeachStatement statement1, @NotNull PsiForeachStatement statement2) {
        String name2;
        PsiExpression value2;
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.forEachStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.forEachStatementsAreEquivalent must not be null");
        }
        PsiExpression value1 = statement1.getIteratedValue();
        if (!EquivalenceChecker.expressionsAreEquivalent(value1, value2 = statement2.getIteratedValue())) {
            return false;
        }
        PsiParameter parameter1 = statement1.getIterationParameter();
        PsiParameter parameter2 = statement1.getIterationParameter();
        String name1 = parameter1.getName();
        if (!name1.equals(name2 = parameter2.getName())) {
            return false;
        }
        PsiType type1 = parameter1.getType();
        if (!type1.equals(parameter2.getType())) {
            return false;
        }
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean switchStatementsAreEquivalent(@NotNull PsiSwitchStatement statement1, @NotNull PsiSwitchStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.switchStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.switchStatementsAreEquivalent must not be null");
        }
        PsiExpression switchExpression1 = statement1.getExpression();
        PsiExpression swithcExpression2 = statement2.getExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(switchExpression1, swithcExpression2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean doWhileStatementsAreEquivalent(@NotNull PsiDoWhileStatement statement1, @NotNull PsiDoWhileStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.doWhileStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.doWhileStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement body1 = statement1.getBody();
        PsiStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean assertStatementsAreEquivalent(@NotNull PsiAssertStatement statement1, @NotNull PsiAssertStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.assertStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.assertStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getAssertCondition();
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description1 = statement1.getAssertDescription();
        PsiExpression description2 = statement2.getAssertDescription();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(description1, description2);
    }

    private static boolean synchronizedStatementsAreEquivalent(@NotNull PsiSynchronizedStatement statement1, @NotNull PsiSynchronizedStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.synchronizedStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.synchronizedStatementsAreEquivalent must not be null");
        }
        PsiExpression lock1 = statement1.getLockExpression();
        PsiExpression lock2 = statement2.getLockExpression();
        PsiCodeBlock body1 = statement1.getBody();
        PsiCodeBlock body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(lock1, lock2) && EquivalenceChecker.codeBlocksAreEquivalent(body1, body2);
    }

    private static boolean blockStatementsAreEquivalent(@NotNull PsiBlockStatement statement1, @NotNull PsiBlockStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.blockStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.blockStatementsAreEquivalent must not be null");
        }
        PsiCodeBlock block1 = statement1.getCodeBlock();
        PsiCodeBlock block2 = statement2.getCodeBlock();
        return EquivalenceChecker.codeBlocksAreEquivalent(block1, block2);
    }

    private static boolean breakStatementsAreEquivalent(@NotNull PsiBreakStatement statement1, @NotNull PsiBreakStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.breakStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.breakStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean continueStatementsAreEquivalent(@NotNull PsiContinueStatement statement1, @NotNull PsiContinueStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.continueStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.continueStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        if (identifier1 == null) {
            return identifier2 == null;
        }
        if (identifier2 == null) {
            return false;
        }
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    private static boolean switchLabelStatementsAreEquivalent(@NotNull PsiSwitchLabelStatement statement1, @NotNull PsiSwitchLabelStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.switchLabelStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.switchLabelStatementsAreEquivalent must not be null");
        }
        if (statement1.isDefaultCase()) {
            return statement2.isDefaultCase();
        }
        if (statement2.isDefaultCase()) {
            return false;
        }
        PsiExpression caseExpression1 = statement1.getCaseValue();
        PsiExpression caseExpression2 = statement2.getCaseValue();
        return EquivalenceChecker.expressionsAreEquivalent(caseExpression1, caseExpression2);
    }

    private static boolean labeledStatementsAreEquivalent(@NotNull PsiLabeledStatement statement1, @NotNull PsiLabeledStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.labeledStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.labeledStatementsAreEquivalent must not be null");
        }
        PsiIdentifier identifier1 = statement1.getLabelIdentifier();
        PsiIdentifier identifier2 = statement2.getLabelIdentifier();
        String text1 = identifier1.getText();
        String text2 = identifier2.getText();
        return text1.equals(text2);
    }

    public static boolean codeBlocksAreEquivalent(@Nullable PsiCodeBlock block1, @Nullable PsiCodeBlock block2) {
        if (block1 == null && block2 == null) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        PsiStatement[] statements1 = block1.getStatements();
        PsiStatement[] statements2 = block2.getStatements();
        if (statements2.length != statements1.length) {
            return false;
        }
        for (int i = 0; i < statements2.length; ++i) {
            if (EquivalenceChecker.statementsAreEquivalent(statements2[i], statements1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean ifStatementsAreEquivalent(@NotNull PsiIfStatement statement1, @NotNull PsiIfStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.ifStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.ifStatementsAreEquivalent must not be null");
        }
        PsiExpression condition1 = statement1.getCondition();
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenBranch1 = statement1.getThenBranch();
        PsiStatement thenBranch2 = statement2.getThenBranch();
        PsiStatement elseBranch1 = statement1.getElseBranch();
        PsiStatement elseBranch2 = statement2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(thenBranch1, thenBranch2) && EquivalenceChecker.statementsAreEquivalent(elseBranch1, elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull PsiExpressionStatement statement1, @NotNull PsiExpressionStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.expressionStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.expressionStatementsAreEquivalent must not be null");
        }
        PsiExpression expression1 = statement1.getExpression();
        PsiExpression expression2 = statement2.getExpression();
        return EquivalenceChecker.expressionsAreEquivalent(expression1, expression2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull PsiReturnStatement statement1, @NotNull PsiReturnStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.returnStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.returnStatementsAreEquivalent must not be null");
        }
        PsiExpression returnValue1 = statement1.getReturnValue();
        PsiExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull PsiThrowStatement statement1, @NotNull PsiThrowStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.throwStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.throwStatementsAreEquivalent must not be null");
        }
        PsiExpression exception1 = statement1.getException();
        PsiExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    private static boolean expressionListStatementsAreEquivalent(@NotNull PsiExpressionListStatement statement1, @NotNull PsiExpressionListStatement statement2) {
        if (statement1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.expressionListStatementsAreEquivalent must not be null");
        }
        if (statement2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.expressionListStatementsAreEquivalent must not be null");
        }
        PsiExpressionList expressionList1 = statement1.getExpressionList();
        PsiExpression[] expressions1 = expressionList1.getExpressions();
        PsiExpressionList expressionList2 = statement2.getExpressionList();
        PsiExpression[] expressions2 = expressionList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(expressions1, expressions2);
    }

    public static boolean expressionsAreEquivalent(@Nullable PsiExpression exp1, @Nullable PsiExpression exp2) {
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        PsiExpression expToCompare1 = ParenthesesUtils.stripParentheses(exp1);
        PsiExpression expToCompare2 = ParenthesesUtils.stripParentheses(exp2);
        if (expToCompare1 == null && expToCompare2 == null) {
            return true;
        }
        if (expToCompare1 == null || expToCompare2 == null) {
            return false;
        }
        if (expToCompare1.getClass() != expToCompare2.getClass()) {
            return false;
        }
        if (expToCompare1 instanceof PsiThisExpression) {
            return true;
        }
        if (expToCompare1 instanceof PsiSuperExpression) {
            return true;
        }
        if (expToCompare1 instanceof PsiLiteralExpression) {
            String text1 = expToCompare1.getText();
            String text2 = expToCompare2.getText();
            return text1.equals(text2);
        }
        if (expToCompare1 instanceof PsiClassObjectAccessExpression) {
            String text1 = expToCompare1.getText();
            String text2 = expToCompare2.getText();
            return text1.equals(text2);
        }
        if (expToCompare1 instanceof PsiReferenceExpression) {
            return EquivalenceChecker.referenceExpressionsAreEquivalent((PsiReferenceExpression)expToCompare1, (PsiReferenceExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiMethodCallExpression) {
            return EquivalenceChecker.methodCallExpressionsAreEquivalent((PsiMethodCallExpression)expToCompare1, (PsiMethodCallExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiNewExpression) {
            return EquivalenceChecker.newExpressionsAreEquivalent((PsiNewExpression)expToCompare1, (PsiNewExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiArrayInitializerExpression) {
            return EquivalenceChecker.arrayInitializerExpressionsAreEquivalent((PsiArrayInitializerExpression)expToCompare1, (PsiArrayInitializerExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiTypeCastExpression) {
            return EquivalenceChecker.typecastExpressionsAreEquivalent((PsiTypeCastExpression)expToCompare1, (PsiTypeCastExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiArrayAccessExpression) {
            return EquivalenceChecker.arrayAccessExpressionsAreEquivalent((PsiArrayAccessExpression)expToCompare2, (PsiArrayAccessExpression)expToCompare1);
        }
        if (expToCompare1 instanceof PsiPrefixExpression) {
            return EquivalenceChecker.prefixExpressionsAreEquivalent((PsiPrefixExpression)expToCompare1, (PsiPrefixExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiPostfixExpression) {
            return EquivalenceChecker.postfixExpressionsAreEquivalent((PsiPostfixExpression)expToCompare1, (PsiPostfixExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiBinaryExpression) {
            return EquivalenceChecker.binaryExpressionsAreEquivalent((PsiBinaryExpression)expToCompare1, (PsiBinaryExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiAssignmentExpression) {
            return EquivalenceChecker.assignmentExpressionsAreEquivalent((PsiAssignmentExpression)expToCompare1, (PsiAssignmentExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiConditionalExpression) {
            return EquivalenceChecker.conditionalExpressionsAreEquivalent((PsiConditionalExpression)expToCompare1, (PsiConditionalExpression)expToCompare2);
        }
        if (expToCompare1 instanceof PsiInstanceOfExpression) {
            return EquivalenceChecker.instanceofExpressionsAreEquivalent((PsiInstanceOfExpression)expToCompare1, (PsiInstanceOfExpression)expToCompare2);
        }
        return false;
    }

    private static boolean referenceExpressionsAreEquivalent(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement element1 = referenceExpression1.resolve();
        PsiElement element2 = referenceExpression2.resolve();
        if (element1 != null) {
            if (!element1.equals(element2)) {
                return false;
            }
        } else {
            return element2 == null;
        }
        if (element1 instanceof PsiMember) {
            PsiMember member1 = (PsiMember)element1;
            if (member1.hasModifierProperty("static")) {
                return true;
            }
            if (member1 instanceof PsiClass) {
                return true;
            }
        } else {
            return true;
        }
        PsiExpression qualifier1 = referenceExpression1.getQualifierExpression();
        PsiExpression qualifier2 = referenceExpression2.getQualifierExpression();
        if (qualifier1 != null && !(qualifier1 instanceof PsiThisExpression) && !(qualifier1 instanceof PsiSuperExpression)) {
            if (qualifier2 == null) {
                return false;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2)) {
                return false;
            }
        } else if (qualifier2 != null && !(qualifier2 instanceof PsiThisExpression) && !(qualifier2 instanceof PsiSuperExpression)) {
            return false;
        }
        String text1 = referenceExpression1.getText();
        String text2 = referenceExpression2.getText();
        return text1.equals(text2);
    }

    private static boolean instanceofExpressionsAreEquivalent(PsiInstanceOfExpression instanceOfExpression1, PsiInstanceOfExpression instanceOfExpression2) {
        PsiExpression operand2;
        PsiExpression operand1 = instanceOfExpression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = instanceOfExpression2.getOperand())) {
            return false;
        }
        PsiTypeElement typeElement1 = instanceOfExpression1.getCheckType();
        PsiTypeElement typeElement2 = instanceOfExpression2.getCheckType();
        if (typeElement1 == null) {
            return typeElement2 == null;
        }
        if (typeElement2 == null) {
            return false;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull PsiMethodCallExpression methodExp1, @NotNull PsiMethodCallExpression methodExp2) {
        PsiReferenceExpression methodExpression2;
        if (methodExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.methodCallExpressionsAreEquivalent must not be null");
        }
        if (methodExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.methodCallExpressionsAreEquivalent must not be null");
        }
        PsiReferenceExpression methodExpression1 = methodExp1.getMethodExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)methodExpression1, (PsiExpression)(methodExpression2 = methodExp2.getMethodExpression()))) {
            return false;
        }
        PsiExpressionList argumentList1 = methodExp1.getArgumentList();
        PsiExpression[] args1 = argumentList1.getExpressions();
        PsiExpressionList argumentList2 = methodExp2.getArgumentList();
        PsiExpression[] args2 = argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean newExpressionsAreEquivalent(@NotNull PsiNewExpression newExp1, @NotNull PsiNewExpression newExp2) {
        PsiExpression qualifier2;
        PsiArrayInitializerExpression arrayInitializer2;
        PsiExpression[] arrayDimensions2;
        if (newExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.newExpressionsAreEquivalent must not be null");
        }
        if (newExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.newExpressionsAreEquivalent must not be null");
        }
        PsiJavaCodeReferenceElement classRef1 = newExp1.getClassReference();
        PsiJavaCodeReferenceElement classRef2 = newExp2.getClassReference();
        if (classRef1 == null || classRef2 == null) {
            return false;
        }
        String text = classRef1.getText();
        if (!text.equals(classRef2.getText())) {
            return false;
        }
        PsiExpression[] arrayDimensions1 = newExp1.getArrayDimensions();
        if (!EquivalenceChecker.expressionListsAreEquivalent(arrayDimensions1, arrayDimensions2 = newExp2.getArrayDimensions())) {
            return false;
        }
        PsiArrayInitializerExpression arrayInitializer1 = newExp1.getArrayInitializer();
        if (!EquivalenceChecker.expressionsAreEquivalent((PsiExpression)arrayInitializer1, (PsiExpression)(arrayInitializer2 = newExp2.getArrayInitializer()))) {
            return false;
        }
        PsiExpression qualifier1 = newExp1.getQualifier();
        if (!EquivalenceChecker.expressionsAreEquivalent(qualifier1, qualifier2 = newExp2.getQualifier())) {
            return false;
        }
        PsiExpressionList argumentList1 = newExp1.getArgumentList();
        PsiExpression[] args1 = argumentList1 == null ? null : argumentList1.getExpressions();
        PsiExpressionList argumentList2 = newExp2.getArgumentList();
        PsiExpression[] args2 = argumentList2 == null ? null : argumentList2.getExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(args1, args2);
    }

    private static boolean arrayInitializerExpressionsAreEquivalent(@NotNull PsiArrayInitializerExpression arrInitExp1, @NotNull PsiArrayInitializerExpression arrInitExp2) {
        if (arrInitExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.arrayInitializerExpressionsAreEquivalent must not be null");
        }
        if (arrInitExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.arrayInitializerExpressionsAreEquivalent must not be null");
        }
        PsiExpression[] initializers1 = arrInitExp1.getInitializers();
        PsiExpression[] initializers2 = arrInitExp2.getInitializers();
        return EquivalenceChecker.expressionListsAreEquivalent(initializers1, initializers2);
    }

    private static boolean typecastExpressionsAreEquivalent(@NotNull PsiTypeCastExpression typecastExp1, @NotNull PsiTypeCastExpression typecastExp2) {
        PsiType type2;
        if (typecastExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.typecastExpressionsAreEquivalent must not be null");
        }
        if (typecastExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.typecastExpressionsAreEquivalent must not be null");
        }
        PsiTypeElement typeElement1 = typecastExp1.getCastType();
        PsiTypeElement typeElement2 = typecastExp2.getCastType();
        if (typeElement1 == null && typeElement2 == null) {
            return true;
        }
        if (typeElement1 == null || typeElement2 == null) {
            return false;
        }
        PsiType type1 = typeElement1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = typeElement2.getType())) {
            return false;
        }
        PsiExpression operand1 = typecastExp1.getOperand();
        PsiExpression operand2 = typecastExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean arrayAccessExpressionsAreEquivalent(@NotNull PsiArrayAccessExpression arrAccessExp2, @NotNull PsiArrayAccessExpression arrAccessExp1) {
        if (arrAccessExp2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.arrayAccessExpressionsAreEquivalent must not be null");
        }
        if (arrAccessExp1 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.arrayAccessExpressionsAreEquivalent must not be null");
        }
        PsiExpression arrayExpression2 = arrAccessExp2.getArrayExpression();
        PsiExpression arrayExpression1 = arrAccessExp1.getArrayExpression();
        PsiExpression indexExpression2 = arrAccessExp2.getIndexExpression();
        PsiExpression indexExpression1 = arrAccessExp1.getIndexExpression();
        return EquivalenceChecker.expressionsAreEquivalent(arrayExpression2, arrayExpression1) && EquivalenceChecker.expressionsAreEquivalent(indexExpression2, indexExpression1);
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull PsiPrefixExpression prefixExp1, @NotNull PsiPrefixExpression prefixExp2) {
        if (prefixExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.prefixExpressionsAreEquivalent must not be null");
        }
        if (prefixExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.prefixExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = prefixExp1.getOperationSign();
        PsiJavaToken sign2 = prefixExp2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression operand1 = prefixExp1.getOperand();
        PsiExpression operand2 = prefixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull PsiPostfixExpression postfixExp1, @NotNull PsiPostfixExpression postfixExp2) {
        if (postfixExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.postfixExpressionsAreEquivalent must not be null");
        }
        if (postfixExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.postfixExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = postfixExp1.getOperationSign();
        PsiJavaToken sign2 = postfixExp2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression operand1 = postfixExp1.getOperand();
        PsiExpression operand2 = postfixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean binaryExpressionsAreEquivalent(@NotNull PsiBinaryExpression binaryExp1, @NotNull PsiBinaryExpression binaryExp2) {
        if (binaryExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.binaryExpressionsAreEquivalent must not be null");
        }
        if (binaryExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.binaryExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = binaryExp1.getOperationSign();
        PsiJavaToken sign2 = binaryExp2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression lhs1 = binaryExp1.getLOperand();
        PsiExpression lhs2 = binaryExp2.getLOperand();
        PsiExpression rhs1 = binaryExp1.getROperand();
        PsiExpression rhs2 = binaryExp2.getROperand();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean assignmentExpressionsAreEquivalent(@NotNull PsiAssignmentExpression assignExp1, @NotNull PsiAssignmentExpression assignExp2) {
        if (assignExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.assignmentExpressionsAreEquivalent must not be null");
        }
        if (assignExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.assignmentExpressionsAreEquivalent must not be null");
        }
        PsiJavaToken sign1 = assignExp1.getOperationSign();
        PsiJavaToken sign2 = assignExp2.getOperationSign();
        IElementType tokenType1 = sign1.getTokenType();
        if (!tokenType1.equals(sign2.getTokenType())) {
            return false;
        }
        PsiExpression lhs1 = assignExp1.getLExpression();
        PsiExpression lhs2 = assignExp2.getLExpression();
        PsiExpression rhs1 = assignExp1.getRExpression();
        PsiExpression rhs2 = assignExp2.getRExpression();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull PsiConditionalExpression condExp1, @NotNull PsiConditionalExpression condExp2) {
        if (condExp1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.conditionalExpressionsAreEquivalent must not be null");
        }
        if (condExp2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/EquivalenceChecker.conditionalExpressionsAreEquivalent must not be null");
        }
        PsiExpression condition1 = condExp1.getCondition();
        PsiExpression condition2 = condExp2.getCondition();
        PsiExpression thenExpression1 = condExp1.getThenExpression();
        PsiExpression thenExpression2 = condExp2.getThenExpression();
        PsiExpression elseExpression1 = condExp1.getElseExpression();
        PsiExpression elseExpression2 = condExp2.getElseExpression();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(@Nullable PsiExpression[] expressions1, @Nullable PsiExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        if (expressions1.length != expressions2.length) {
            return false;
        }
        for (int i = 0; i < expressions1.length; ++i) {
            if (EquivalenceChecker.expressionsAreEquivalent(expressions1[i], expressions2[i])) continue;
            return false;
        }
        return true;
    }
}

