/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.util;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;

public abstract class ParserUtils {
    public static boolean getToken(PsiBuilder builder, IElementType elem, String errorMsg) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        if (errorMsg != null) {
            builder.error(errorMsg);
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, IElementType elem) {
        if (elem.equals(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, TokenSet tokenSet) {
        if (tokenSet.contains(builder.getTokenType())) {
            return ParserUtils.getToken(builder, builder.getTokenType(), null);
        }
        return false;
    }

    public static boolean getToken(PsiBuilder builder, TokenSet tokenSet, String msg) {
        if (tokenSet.contains(builder.getTokenType())) {
            return ParserUtils.getToken(builder, builder.getTokenType(), msg);
        }
        return false;
    }

    public static boolean lookAhead(PsiBuilder builder, IElementType ... elems) {
        int i;
        if (!elems[0].equals(builder.getTokenType())) {
            return false;
        }
        if (elems.length == 1) {
            return true;
        }
        PsiBuilder.Marker rb = builder.mark();
        builder.advanceLexer();
        for (i = 1; !builder.eof() && i < elems.length && elems[i].equals(builder.getTokenType()); ++i) {
            builder.advanceLexer();
        }
        rb.rollbackTo();
        return i == elems.length;
    }

    public static boolean lookAhead(PsiBuilder builder, boolean dropMarker, IElementType ... elems) {
        int i;
        if (elems.length == 0) {
            return false;
        }
        if (elems.length == 1) {
            return elems[0].equals(builder.getTokenType());
        }
        PsiBuilder.Marker rb = builder.mark();
        for (i = 0; !builder.eof() && i < elems.length && elems[i].equals(builder.getTokenType()); ++i) {
            builder.advanceLexer();
        }
        if (dropMarker && i == elems.length) {
            rb.drop();
        } else {
            rb.rollbackTo();
        }
        return i == elems.length;
    }

    public static IElementType eatElement(PsiBuilder builder, IElementType elem) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(elem);
        return elem;
    }

    public static void wrapError(PsiBuilder builder, String msg) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.error(msg);
    }

    public static void waitNextRCurly(PsiBuilder builder) {
        int i = 0;
        PsiBuilder.Marker em = builder.mark();
        while (!builder.eof() && !GroovyElementTypes.mRCURLY.equals(builder.getTokenType())) {
            builder.advanceLexer();
            ++i;
        }
        if (i > 0) {
            em.error(GroovyBundle.message("rcurly.expected", new Object[0]));
        } else {
            em.drop();
        }
    }

    public static void advance(PsiBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.getTokenText();
            builder.advanceLexer();
        }
    }

    public static void advance(PsiBuilder builder) {
        ParserUtils.advance(builder, 1);
    }
}

