/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.bodies;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;

public class GrTypeDefinitionBodyImpl
extends GroovyPsiElementImpl
implements GrTypeDefinitionBody {
    private GrField[] myFields;

    public GrTypeDefinitionBodyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/bodies/GrTypeDefinitionBodyImpl.<init> must not be null");
        }
        super(node);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myFields = null;
        for (GrField field : this.getFields()) {
            ((GrFieldImpl)field).clearCaches();
        }
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTypeDefinitionBody(this);
    }

    public String toString() {
        return "Type definition body";
    }

    @Override
    public GrField[] getFields() {
        if (this.myFields == null) {
            GrVariableDeclaration[] declarations = (GrVariableDeclaration[])this.findChildrenByClass(GrVariableDeclaration.class);
            if (declarations.length == 0) {
                return GrField.EMPTY_ARRAY;
            }
            ArrayList<GrField> result = new ArrayList<GrField>();
            for (GrVariableDeclaration declaration : declarations) {
                GrVariable[] variables;
                for (GrVariable variable : variables = declaration.getVariables()) {
                    if (!(variable instanceof GrField)) continue;
                    result.add((GrField)variable);
                }
            }
            this.myFields = result.toArray(new GrField[result.size()]);
        }
        return this.myFields;
    }

    @Override
    public GrMethod[] getGroovyMethods() {
        return (GrMethod[])this.findChildrenByClass(GrMethod.class);
    }

    @Override
    public List<PsiMethod> getMethods() {
        GrMethod[] groovyMethods = this.getGroovyMethods();
        GrField[] fields = this.getFields();
        if (fields.length == 0) {
            return Arrays.asList(groovyMethods);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        result.addAll(Arrays.asList(groovyMethods));
        for (GrField field : fields) {
            GrAccessorMethod setter;
            if (!field.isProperty()) continue;
            GrAccessorMethod[] getters = field.getGetters();
            if (getters.length > 0) {
                result.addAll(Arrays.asList(getters));
            }
            if ((setter = field.getSetter()) == null) continue;
            result.add(setter);
        }
        return result;
    }

    @Override
    public GrMembersDeclaration[] getMemberDeclarations() {
        return (GrMembersDeclaration[])this.findChildrenByClass(GrMembersDeclaration.class);
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(GroovyTokenTypes.mRCURLY);
    }

    @Override
    @NotNull
    public GrClassInitializer[] getInitializers() {
        GrClassInitializer[] grClassInitializerArray = (GrClassInitializer[])this.findChildrenByClass(GrClassInitializer.class);
        if (grClassInitializerArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/bodies/GrTypeDefinitionBodyImpl.getInitializers must not return null");
        }
        return grClassInitializerArray;
    }

    @Override
    public PsiClass[] getInnerClasses() {
        return (PsiClass[])this.findChildrenByClass(PsiClass.class);
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        PsiElement rBrace = this.getRBrace();
        if (anchor == null && rBrace == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        ASTNode elemNode = declaration.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : rBrace.getNode();
        this.getNode().addChild(elemNode, anchorNode);
        this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        return (GrVariableDeclaration)elemNode.getPsi();
    }
}

