/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.KeyRep;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

final class PBEKey
implements SecretKey {
    static final long serialVersionUID = -2234768909660948176L;
    private byte[] key;
    private String type;

    PBEKey(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        int n;
        char[] cArray = pBEKeySpec.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] >= ' ' && cArray[n] <= '~') continue;
            throw new InvalidKeySpecException("Password is not ASCII");
        }
        this.key = new byte[cArray.length];
        for (n = 0; n < cArray.length; ++n) {
            this.key[n] = (byte)(cArray[n] & 0x7F);
        }
        Arrays.fill(cArray, ' ');
        this.type = string;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return this.type;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        return n ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.type)) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

