/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.StoreInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCMemoryInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

public class SPARCStoreInstruction
extends SPARCMemoryInstruction
implements StoreInstruction {
    protected final SPARCRegister register2;
    protected final Register[] storeSources;

    public SPARCStoreInstruction(String name, int opcode, SPARCRegisterIndirectAddress address, SPARCRegister register, int dataType) {
        super(name, opcode, address, register, dataType);
        if (opcode == 7 || opcode == 23) {
            this.storeSources = new Register[2];
            this.storeSources[0] = register;
            int nextRegNum = (register.getNumber() + 1) % 32;
            this.register2 = SPARCRegisters.getRegister(nextRegNum);
            this.storeSources[1] = this.register2;
        } else {
            this.storeSources = new Register[1];
            this.storeSources[0] = register;
            this.register2 = null;
        }
    }

    private String defaultInitDescription(StringBuffer buf) {
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.register.toString());
        buf.append(comma);
        buf.append(this.address.toString());
        return buf.toString();
    }

    @Override
    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.register == SPARCRegisters.G0) {
            switch (this.opcode) {
                case 4: {
                    buf.append("clr");
                    break;
                }
                case 6: {
                    buf.append("clrh");
                    break;
                }
                case 5: {
                    buf.append("clrb");
                    break;
                }
                default: {
                    return this.defaultInitDescription(buf);
                }
            }
            buf.append(spaces);
            buf.append(this.address.toString());
            return buf.toString();
        }
        return this.defaultInitDescription(buf);
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public Address getStoreDestination() {
        return this.address;
    }

    @Override
    public Register[] getStoreSources() {
        return this.storeSources;
    }

    @Override
    public boolean isStore() {
        return true;
    }
}

