/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import sun.jvm.hotspot.bugspot.BugSpotAgent;
import sun.jvm.hotspot.bugspot.PackageScanner;
import sun.jvm.hotspot.bugspot.RegisterPanel;
import sun.jvm.hotspot.bugspot.StackTraceEntry;
import sun.jvm.hotspot.bugspot.StackTracePanel;
import sun.jvm.hotspot.bugspot.ThreadListPanel;
import sun.jvm.hotspot.bugspot.VariablePanel;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.MachineDescriptionIntelX86;
import sun.jvm.hotspot.debugger.ProcessInfo;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.DebugEvent;
import sun.jvm.hotspot.debugger.cdbg.LineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.LineNumberVisitor;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.ProcessControl;
import sun.jvm.hotspot.debugger.windbg.WindbgDebuggerLocal;
import sun.jvm.hotspot.livejvm.BreakpointEvent;
import sun.jvm.hotspot.livejvm.Event;
import sun.jvm.hotspot.livejvm.ExceptionEvent;
import sun.jvm.hotspot.livejvm.ServiceabilityAgentJVMDIModule;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.Editor;
import sun.jvm.hotspot.ui.EditorCommands;
import sun.jvm.hotspot.ui.EditorFactory;
import sun.jvm.hotspot.ui.FrameWrapper;
import sun.jvm.hotspot.ui.GraphicsUtilities;
import sun.jvm.hotspot.ui.JFrameWrapper;
import sun.jvm.hotspot.ui.JInternalFrameWrapper;
import sun.jvm.hotspot.ui.MemoryViewer;
import sun.jvm.hotspot.ui.ProcessListPanel;
import sun.jvm.hotspot.ui.SourceCodePanel;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.PlatformInfo;
import sun.jvm.hotspot.utilities.WorkerThread;

public class BugSpot
extends JPanel {
    private WorkerThread workerThread;
    private boolean mdiMode;
    private JVMDebugger localDebugger;
    private BugSpotAgent agent = new BugSpotAgent();
    private JMenuBar menuBar;
    private List attachMenuItems;
    private List detachMenuItems;
    private List debugMenuItems;
    private List suspendDebugMenuItems;
    private List resumeDebugMenuItems;
    private FrameWrapper stackFrame;
    private VariablePanel localsPanel;
    private StackTracePanel stackTracePanel;
    private FrameWrapper registerFrame;
    private RegisterPanel registerPanel;
    private Map threadToJavaThreadMap;
    private JMenu debugMenu;
    private JDesktopPane desktop;
    private boolean attached;
    private boolean suspended;
    private Font fixedWidthFont;
    private Map sourceFileToLineNumberInfoMap;
    private Map fileToBreakpointMap;
    private Timer debugEventTimer;
    private boolean javaEventPending;
    private Map editors;
    private EditorFactory editorFact = new DefaultEditorFactory();
    private EditorCommands editorComm = new EditorCommands(){

        @Override
        public void windowClosed(Editor editor) {
            BugSpot.this.editors.remove(editor.getSourceFileName());
        }

        @Override
        public void toggleBreakpointAtLine(Editor editor, int lineNumber) {
            BreakpointResult res = BugSpot.this.handleBreakpointToggle(editor, lineNumber);
            if (res.succeeded()) {
                if (res.set()) {
                    editor.showBreakpointAtLine(res.getLine());
                } else {
                    editor.clearBreakpointAtLine(res.getLine());
                }
            } else {
                String why = res.getWhy();
                why = why == null ? "" : ": " + why;
                BugSpot.this.showMessageDialog("Unable to toggle breakpoint" + why, "Unable to toggle breakpoint", 2);
            }
        }
    };

    public BugSpot() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BugSpot.this.detachDebugger();
            }
        });
    }

    public void setMDIMode(boolean onOrOff) {
        this.mdiMode = onOrOff;
    }

    public boolean getMDIMode() {
        return this.mdiMode;
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.menuBar = new JMenuBar();
        this.attachMenuItems = new ArrayList();
        this.detachMenuItems = new ArrayList();
        this.debugMenuItems = new ArrayList();
        this.suspendDebugMenuItems = new ArrayList();
        this.resumeDebugMenuItems = new ArrayList();
        JMenu menu = BugSpot.createMenu("File", 'F', 0);
        JMenuItem item = BugSpot.createMenuItem("Open source file...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.openSourceFile();
            }
        }, 79, 2, 'O', 0);
        menu.add(item);
        this.detachMenuItems.add(item);
        menu.addSeparator();
        item = BugSpot.createMenuItem("Attach to process...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.showAttachDialog();
            }
        }, 'A', 0);
        menu.add(item);
        this.attachMenuItems.add(item);
        item = BugSpot.createMenuItem("Detach", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.detach();
            }
        }, 'D', 0);
        menu.add(item);
        this.detachMenuItems.add(item);
        this.setMenuItemsEnabled(this.detachMenuItems, false);
        menu.addSeparator();
        menu.add(BugSpot.createMenuItem("Exit", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.detach();
                System.exit(0);
            }
        }, 'x', 1));
        this.menuBar.add(menu);
        this.debugMenu = BugSpot.createMenu("Debug", 'D', 0);
        item = BugSpot.createMenuItem("Go", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BugSpot.this.attached) {
                    return;
                }
                if (!BugSpot.this.isSuspended()) {
                    return;
                }
                BugSpot.this.resume();
            }
        }, 116, 0, 'G', 0);
        this.debugMenu.add(item);
        this.resumeDebugMenuItems.add(item);
        item = BugSpot.createMenuItem("Break", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BugSpot.this.attached) {
                    System.err.println("Not attached");
                    return;
                }
                if (BugSpot.this.isSuspended()) {
                    System.err.println("Already suspended");
                    return;
                }
                BugSpot.this.suspend();
            }
        }, 'B', 0);
        this.debugMenu.add(item);
        this.suspendDebugMenuItems.add(item);
        this.debugMenu.addSeparator();
        item = BugSpot.createMenuItem("Threads...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.showThreadsDialog();
            }
        }, 'T', 0);
        this.debugMenu.add(item);
        this.debugMenuItems.add(item);
        item = BugSpot.createMenuItem("Memory", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.showMemoryDialog();
            }
        }, 'M', 0);
        this.debugMenu.add(item);
        this.debugMenuItems.add(item);
        this.debugMenu.setEnabled(false);
        this.menuBar.add(this.debugMenu);
        if (this.mdiMode) {
            this.desktop = new JDesktopPane();
            this.add((Component)this.desktop, "Center");
        }
        this.fixedWidthFont = GraphicsUtilities.lookupFont("Courier");
        this.debugEventTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugSpot.this.pollForDebugEvent();
            }
        });
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void showAttachDialog() {
        this.setMenuItemsEnabled(this.attachMenuItems, false);
        final FrameWrapper attachDialog = this.newFrame("Attach to process");
        attachDialog.getContentPane().setLayout(new BorderLayout());
        attachDialog.setClosable(true);
        attachDialog.setResizable(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(GraphicsUtilities.newBorder(5));
        attachDialog.setBackground(panel.getBackground());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        final ProcessListPanel plist = new ProcessListPanel(this.getLocalDebugger());
        panel.add((Component)plist, "Center");
        JCheckBox check = new JCheckBox("Update list continuously");
        check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    plist.start();
                } else {
                    plist.stop();
                }
            }
        });
        listPanel.add((Component)plist, "Center");
        listPanel.add((Component)check, "South");
        panel.add((Component)listPanel, "Center");
        attachDialog.getContentPane().add((Component)panel, "Center");
        attachDialog.setClosingActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plist.stop();
                BugSpot.this.setMenuItemsEnabled(BugSpot.this.attachMenuItems, true);
            }
        });
        ActionListener attacher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plist.stop();
                attachDialog.setVisible(false);
                BugSpot.this.removeFrame(attachDialog);
                ProcessInfo info = plist.getSelectedProcess();
                if (info != null) {
                    BugSpot.this.attach(info.getPid());
                }
            }
        };
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("OK");
        button.addActionListener(attacher);
        hbox.add(button);
        hbox.add(Box.createHorizontalStrut(20));
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plist.stop();
                attachDialog.setVisible(false);
                BugSpot.this.removeFrame(attachDialog);
                BugSpot.this.setMenuItemsEnabled(BugSpot.this.attachMenuItems, true);
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        panel = new JPanel();
        panel.setBorder(GraphicsUtilities.newBorder(5));
        panel.add(hbox);
        attachDialog.getContentPane().add((Component)panel, "South");
        this.addFrame(attachDialog);
        attachDialog.pack();
        attachDialog.setSize(400, 300);
        GraphicsUtilities.centerInContainer(attachDialog.getComponent(), this.getParentDimension(attachDialog.getComponent()));
        attachDialog.setVisible(true);
    }

    public void showThreadsDialog() {
        FrameWrapper threadsDialog = this.newFrame("Threads");
        threadsDialog.getContentPane().setLayout(new BorderLayout());
        threadsDialog.setClosable(true);
        threadsDialog.setResizable(true);
        ThreadListPanel threads = new ThreadListPanel(this.getCDebugger(), this.getAgent().isJavaMode());
        threads.addListener(new ThreadListPanel.Listener(){

            @Override
            public void setFocus(ThreadProxy thread, JavaThread jthread) {
                BugSpot.this.setCurrentThread(thread);
                System.err.println("Focus changed to thread " + thread);
            }
        });
        threads.setBorder(GraphicsUtilities.newBorder(5));
        threadsDialog.getContentPane().add(threads);
        this.addFrame(threadsDialog);
        threadsDialog.pack();
        GraphicsUtilities.reshapeToAspectRatio(threadsDialog.getComponent(), 3.0f, 0.9f, this.getParentDimension(threadsDialog.getComponent()));
        GraphicsUtilities.centerInContainer(threadsDialog.getComponent(), this.getParentDimension(threadsDialog.getComponent()));
        threadsDialog.setVisible(true);
    }

    public void showMemoryDialog() {
        FrameWrapper memoryDialog = this.newFrame("Memory");
        memoryDialog.getContentPane().setLayout(new BorderLayout());
        memoryDialog.setClosable(true);
        memoryDialog.setResizable(true);
        memoryDialog.getContentPane().add((Component)new MemoryViewer(this.getDebugger(), this.getDebugger().getMachineDescription().getAddressSize() == 8L), "Center");
        this.addFrame(memoryDialog);
        memoryDialog.pack();
        GraphicsUtilities.reshapeToAspectRatio(memoryDialog.getComponent(), 1.0f, 0.7f, this.getParentDimension(memoryDialog.getComponent()));
        GraphicsUtilities.centerInContainer(memoryDialog.getComponent(), this.getParentDimension(memoryDialog.getComponent()));
        memoryDialog.setVisible(true);
    }

    public void setEditorFactory(EditorFactory fact) {
        this.editorFact = fact != null ? fact : new DefaultEditorFactory();
    }

    private void attach(int pid) {
        try {
            this.getAgent().attach(pid);
            this.setMenuItemsEnabled(this.detachMenuItems, true);
            this.setMenuItemsEnabled(this.suspendDebugMenuItems, false);
            this.setMenuItemsEnabled(this.resumeDebugMenuItems, true);
            this.debugMenu.setEnabled(true);
            this.attached = true;
            this.suspended = true;
            if (this.getAgent().isJavaMode()) {
                System.err.println("Java HotSpot(TM) virtual machine detected.");
            } else {
                System.err.println("(No Java(TM) virtual machine detected)");
            }
            this.editors = new HashMap();
            this.fileToBreakpointMap = new HashMap();
            JPanel framePanel = new JPanel();
            framePanel.setLayout(new BorderLayout());
            framePanel.setBorder(GraphicsUtilities.newBorder(5));
            this.localsPanel = new VariablePanel();
            JTabbedPane tab = new JTabbedPane();
            tab.addTab("Locals", this.localsPanel);
            tab.setTabPlacement(3);
            framePanel.add((Component)tab, "Center");
            JPanel stackPanel = new JPanel();
            stackPanel.setLayout(new BoxLayout(stackPanel, 0));
            stackPanel.add(new JLabel("Context:"));
            stackPanel.add(Box.createHorizontalStrut(5));
            this.stackTracePanel = new StackTracePanel();
            this.stackTracePanel.addListener(new StackTracePanel.Listener(){

                @Override
                public void frameChanged(CFrame fr, JavaVFrame jfr) {
                    BugSpot.this.setCurrentFrame(fr, jfr);
                }
            });
            stackPanel.add(this.stackTracePanel);
            framePanel.add((Component)stackPanel, "North");
            this.stackFrame = this.newFrame("Stack");
            this.stackFrame.getContentPane().setLayout(new BorderLayout());
            this.stackFrame.getContentPane().add((Component)framePanel, "Center");
            this.stackFrame.setResizable(true);
            this.stackFrame.setClosable(false);
            this.addFrame(this.stackFrame);
            this.stackFrame.setSize(400, 200);
            GraphicsUtilities.moveToInContainer(this.stackFrame.getComponent(), 0.0f, 1.0f, 0, 20);
            this.stackFrame.setVisible(true);
            this.registerPanel = new RegisterPanel();
            this.registerPanel.setFont(this.fixedWidthFont);
            this.registerFrame = this.newFrame("Registers");
            this.registerFrame.getContentPane().setLayout(new BorderLayout());
            this.registerFrame.getContentPane().add((Component)this.registerPanel, "Center");
            this.addFrame(this.registerFrame);
            this.registerFrame.setResizable(true);
            this.registerFrame.setClosable(false);
            this.registerFrame.setSize(225, 200);
            GraphicsUtilities.moveToInContainer(this.registerFrame.getComponent(), 1.0f, 0.0f, 0, 0);
            this.registerFrame.setVisible(true);
            this.resetCurrentThread();
        }
        catch (DebuggerException e) {
            String errMsg = BugSpot.formatMessage(e.getMessage(), 80);
            this.setMenuItemsEnabled(this.attachMenuItems, true);
            this.showMessageDialog("Unable to connect to process ID " + pid + ":\n\n" + errMsg, "Unable to Connect", 2);
            this.getAgent().detach();
        }
    }

    private synchronized void detachDebugger() {
        if (!this.attached) {
            return;
        }
        if (this.isSuspended()) {
            this.resume();
        }
        this.getAgent().detach();
        this.sourceFileToLineNumberInfoMap = null;
        this.fileToBreakpointMap = null;
        this.threadToJavaThreadMap = null;
        this.editors = null;
        this.attached = false;
    }

    private synchronized void detach() {
        this.detachDebugger();
        this.setMenuItemsEnabled(this.attachMenuItems, true);
        this.setMenuItemsEnabled(this.detachMenuItems, false);
        this.debugMenu.setEnabled(false);
        if (this.mdiMode) {
            this.desktop.removeAll();
            this.desktop.invalidate();
            this.desktop.validate();
            this.desktop.repaint();
        }
        this.debugEventTimer.stop();
    }

    private Debugger getLocalDebugger() {
        if (this.localDebugger == null) {
            String os = PlatformInfo.getOS();
            String cpu = PlatformInfo.getCPU();
            if (os.equals("win32")) {
                if (!cpu.equals("x86")) {
                    throw new DebuggerException("Unsupported CPU \"" + cpu + "\" for Windows");
                }
            } else {
                if (os.equals("linux")) {
                    if (!cpu.equals("x86")) {
                        throw new DebuggerException("Unsupported CPU \"" + cpu + "\" for Linux");
                    }
                    throw new RuntimeException("FIXME: figure out how to specify path to debugger module");
                }
                throw new DebuggerException("Unsupported OS \"" + os + "\"");
            }
            this.localDebugger = new WindbgDebuggerLocal(new MachineDescriptionIntelX86(), true);
            this.localDebugger.configureJavaPrimitiveTypeSizes(1L, 1L, 2L, 8L, 4L, 4L, 8L, 2L);
        }
        return this.localDebugger;
    }

    private BugSpotAgent getAgent() {
        return this.agent;
    }

    private Debugger getDebugger() {
        return this.getAgent().getDebugger();
    }

    private CDebugger getCDebugger() {
        return this.getAgent().getCDebugger();
    }

    private void resetCurrentThread() {
        this.setCurrentThread((ThreadProxy)this.getCDebugger().getThreadList().get(0));
    }

    private void setCurrentThread(ThreadProxy t) {
        ArrayList<StackTraceEntry> trace = new ArrayList<StackTraceEntry>();
        CFrame fr = this.getCDebugger().topFrameForThread(t);
        while (fr != null) {
            trace.add(new StackTraceEntry(fr, this.getCDebugger()));
            try {
                fr = fr.sender();
            }
            catch (AddressException e) {
                e.printStackTrace();
                this.showMessageDialog("Error while walking stack; stack trace will be truncated\n(see console for details)", "Error walking stack", 2);
                fr = null;
            }
        }
        JavaThread jthread = this.javaThreadForProxy(t);
        if (jthread != null) {
            ArrayList<StackTraceEntry> javaTrace = new ArrayList<StackTraceEntry>();
            VFrame vf = jthread.getLastJavaVFrameDbg();
            while (vf != null) {
                if (!((VFrame)vf).isJavaFrame()) continue;
                javaTrace.add(new StackTraceEntry((JavaVFrame)vf));
                vf = vf.sender();
            }
            ArrayList<StackTraceEntry> mergedTrace = new ArrayList<StackTraceEntry>();
            int c = 0;
            int j = 0;
            while (c < trace.size()) {
                StackTraceEntry entry = (StackTraceEntry)trace.get(c);
                if (entry.isUnknownCFrame()) {
                    StackTraceEntry javaEntry;
                    JavaVFrame jvf;
                    Method m;
                    boolean gotJavaFrame = false;
                    while (!(j >= javaTrace.size() || (m = (jvf = (javaEntry = (StackTraceEntry)javaTrace.get(j)).getJavaFrame()).getMethod()).isNative() && gotJavaFrame)) {
                        gotJavaFrame = true;
                        mergedTrace.add(javaEntry);
                        ++j;
                    }
                    if (gotJavaFrame) {
                        while (c < trace.size() && entry.isUnknownCFrame()) {
                            if (++c >= trace.size()) continue;
                            entry = (StackTraceEntry)trace.get(c);
                        }
                        continue;
                    }
                }
                mergedTrace.add(entry);
                ++c;
            }
            trace = mergedTrace;
        }
        this.stackTracePanel.setTrace(trace);
        this.registerPanel.update(t);
    }

    private void setCurrentFrame(CFrame fr, JavaVFrame jfr) {
        this.localsPanel.clear();
        if (fr != null) {
            CDebugInfoDataBase db;
            this.localsPanel.update(fr);
            LoadObject lo = this.getCDebugger().loadObjectContainingPC(fr.pc());
            if (lo != null && (db = lo.getDebugInfoDataBase()) != null) {
                LineNumberInfo info = db.lineNumberForPC(fr.pc());
                if (info != null) {
                    System.err.println("PC " + fr.pc() + ": Source file \"" + info.getSourceFileName() + "\", line number " + info.getLineNumber() + ", PC range [" + info.getStartPC() + ", " + info.getEndPC() + ")");
                    this.showLineNumber(null, info.getSourceFileName(), info.getLineNumber());
                } else {
                    System.err.println("(No line number information for PC " + fr.pc() + ")");
                    db.iterate(new LineNumberVisitor(){

                        @Override
                        public void doLineNumber(LineNumberInfo info) {
                            System.err.println("  Source file \"" + info.getSourceFileName() + "\", line number " + info.getLineNumber() + ", PC range [" + info.getStartPC() + ", " + info.getEndPC() + ")");
                        }
                    });
                }
            }
        } else {
            int bci;
            int lineNo;
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(jfr != null, "Must have either C or Java frame");
            }
            this.localsPanel.update(jfr);
            Method m = jfr.getMethod();
            Symbol sfn = ((InstanceKlass)m.getMethodHolder()).getSourceFileName();
            if (sfn != null && (lineNo = m.getLineNumberFromBCI(bci = jfr.getBCI())) >= 0) {
                this.showLineNumber(this.packageName(m.getMethodHolder().getName().asString()), sfn.asString(), lineNo);
            }
        }
    }

    private String packageName(String str) {
        int idx = str.lastIndexOf(47);
        if (idx < 0) {
            return "";
        }
        return str.substring(0, idx).replace('/', '.');
    }

    private JavaThread javaThreadForProxy(ThreadProxy t) {
        if (!this.getAgent().isJavaMode()) {
            return null;
        }
        if (this.threadToJavaThreadMap == null) {
            this.threadToJavaThreadMap = new HashMap();
            Threads threads = VM.getVM().getThreads();
            for (JavaThread thr = threads.first(); thr != null; thr = thr.next()) {
                this.threadToJavaThreadMap.put(thr.getThreadProxy(), thr);
            }
        }
        return (JavaThread)this.threadToJavaThreadMap.get(t);
    }

    private static JMenu createMenu(String name, char mnemonic, int mnemonicPos) {
        JMenu menu = new JMenu(name);
        menu.setMnemonic(mnemonic);
        menu.setDisplayedMnemonicIndex(mnemonicPos);
        return menu;
    }

    private static JMenuItem createMenuItem(String name, ActionListener l) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(l);
        return item;
    }

    private static JMenuItem createMenuItemInternal(String name, ActionListener l, int accelerator, int modifiers) {
        JMenuItem item = BugSpot.createMenuItem(name, l);
        item.setAccelerator(KeyStroke.getKeyStroke(accelerator, modifiers));
        return item;
    }

    private static JMenuItem createMenuItem(String name, ActionListener l, int accelerator) {
        return BugSpot.createMenuItemInternal(name, l, accelerator, 0);
    }

    private static JMenuItem createMenuItem(String name, ActionListener l, char mnemonic, int mnemonicPos) {
        JMenuItem item = BugSpot.createMenuItem(name, l);
        item.setMnemonic(mnemonic);
        item.setDisplayedMnemonicIndex(mnemonicPos);
        return item;
    }

    private static JMenuItem createMenuItem(String name, ActionListener l, int accelerator, int acceleratorMods, char mnemonic, int mnemonicPos) {
        JMenuItem item = BugSpot.createMenuItemInternal(name, l, accelerator, acceleratorMods);
        item.setMnemonic(mnemonic);
        item.setDisplayedMnemonicIndex(mnemonicPos);
        return item;
    }

    private static String formatMessage(String message, int charsPerLine) {
        StringBuffer buf = new StringBuffer(message.length());
        StringTokenizer tokenizer = new StringTokenizer(message);
        int curLineLength = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (curLineLength + tok.length() > charsPerLine) {
                buf.append('\n');
                curLineLength = 0;
            } else if (curLineLength != 0) {
                buf.append(' ');
                ++curLineLength;
            }
            buf.append(tok);
            curLineLength += tok.length();
        }
        return buf.toString();
    }

    private void setMenuItemsEnabled(List items, boolean enabled) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            ((JMenuItem)iter.next()).setEnabled(enabled);
        }
    }

    private void showMessageDialog(final String message, final String title, final int jOptionPaneKind) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BugSpot.this.mdiMode) {
                    JOptionPane.showInternalMessageDialog(BugSpot.this.desktop, message, title, jOptionPaneKind);
                } else {
                    JOptionPane.showMessageDialog(null, message, title, jOptionPaneKind);
                }
            }
        });
    }

    private FrameWrapper newFrame(String title) {
        if (this.mdiMode) {
            return new JInternalFrameWrapper(new JInternalFrame(title));
        }
        return new JFrameWrapper(new JFrame(title));
    }

    private void addFrame(FrameWrapper frame) {
        if (this.mdiMode) {
            this.desktop.add(frame.getComponent());
        }
    }

    private void removeFrame(FrameWrapper frame) {
        if (this.mdiMode) {
            this.desktop.remove(frame.getComponent());
            this.desktop.invalidate();
            this.desktop.validate();
            this.desktop.repaint();
        }
    }

    private Dimension getParentDimension(Component c) {
        if (this.mdiMode) {
            return this.desktop.getSize();
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private void openSourceFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Open source code file");
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(null) != 0) {
            return;
        }
        File chosen = chooser.getSelectedFile();
        if (chosen == null) {
            return;
        }
        String path = chosen.getPath();
        String name = null;
        JavaUserData data = null;
        if (path.endsWith(".java")) {
            PackageScanner scanner = new PackageScanner();
            String pkg = scanner.scan(chosen);
            String fileName = chosen.getName();
            name = pkg + "." + fileName;
            data = new JavaUserData(pkg, fileName);
        } else {
            name = path;
        }
        Editor editor = (Editor)this.editors.get(name);
        if (editor == null) {
            editor = this.editorFact.openFile(path, this.editorComm);
            if (editor == null) {
                this.showMessageDialog("Unable to open file \"" + path + "\" -- unexpected error.", "Unable to open file", 2);
                return;
            }
            this.editors.put(name, editor);
            if (data != null) {
                editor.setUserData(data);
            }
        } else {
            editor.toFront();
        }
        editor.showLineNumber(1);
        Set set = (Set)this.fileToBreakpointMap.get(editor.getSourceFileName());
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                editor.showBreakpointAtLine((Integer)iter.next());
            }
        }
    }

    private void showLineNumber(String packageName, String fileName, int lineNumber) {
        String name = packageName == null ? fileName : packageName + "." + fileName;
        Editor editor = (Editor)this.editors.get(name);
        if (editor == null) {
            File file = new File(fileName);
            String realFileName = fileName;
            if (!file.exists()) {
                int res;
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Please locate " + fileName);
                chooser.setMultiSelectionEnabled(false);
                if (packageName != null) {
                    chooser.setFileFilter(new JavaFileFilter(packageName, fileName));
                }
                if ((res = chooser.showOpenDialog(null)) != 0) {
                    return;
                }
                File chosen = chooser.getSelectedFile();
                if (chosen == null) {
                    return;
                }
                realFileName = chosen.getPath();
            }
            if ((editor = this.editorFact.openFile(realFileName, this.editorComm)) == null) {
                this.showMessageDialog("Unable to open file \"" + realFileName + "\" -- unexpected error.", "Unable to open file", 2);
                return;
            }
            this.editors.put(name, editor);
            if (packageName != null) {
                editor.setUserData(new JavaUserData(packageName, fileName));
            }
        }
        editor.showLineNumber(lineNumber);
        editor.highlightLineNumber(lineNumber);
        Set set = (Set)this.fileToBreakpointMap.get(editor.getSourceFileName());
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                editor.showBreakpointAtLine((Integer)iter.next());
            }
        }
    }

    private boolean isSuspended() {
        return this.suspended;
    }

    private synchronized void suspend() {
        this.setMenuItemsEnabled(this.resumeDebugMenuItems, true);
        this.setMenuItemsEnabled(this.suspendDebugMenuItems, false);
        BugSpotAgent agent = this.getAgent();
        if (agent.canInteractWithJava() && !agent.isJavaSuspended()) {
            agent.suspendJava();
        }
        agent.suspend();
        this.resetCurrentThread();
        this.debugEventTimer.stop();
        this.suspended = true;
    }

    private synchronized void resume() {
        this.threadToJavaThreadMap = null;
        this.setMenuItemsEnabled(this.resumeDebugMenuItems, false);
        this.setMenuItemsEnabled(this.suspendDebugMenuItems, true);
        this.registerPanel.clear();
        BugSpotAgent agent = this.getAgent();
        agent.resume();
        if (agent.canInteractWithJava()) {
            if (agent.isJavaSuspended()) {
                agent.resumeJava();
            }
            if (this.javaEventPending) {
                this.javaEventPending = false;
                agent.javaEventContinue();
            }
        }
        agent.enableJavaInteraction();
        this.suspended = false;
        this.debugEventTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized BreakpointResult handleBreakpointToggle(Editor editor, int lineNumber) {
        JavaUserData data = (JavaUserData)editor.getUserData();
        String filename = editor.getSourceFileName();
        if (data == null) {
            CDebugger dbg = this.getCDebugger();
            ProcessControl prctl = dbg.getProcessControl();
            if (prctl == null) {
                return new BreakpointResult(false, false, 0, "Process control not enabled");
            }
            boolean mustSuspendAndResume = !prctl.isSuspended();
            try {
                LineNumberInfo info;
                if (mustSuspendAndResume) {
                    prctl.suspend();
                }
                if ((info = this.getLineNumberInfo(filename, lineNumber)) != null) {
                    Integer key;
                    HashSet<Integer> bpset = (HashSet<Integer>)this.fileToBreakpointMap.get(filename);
                    if (bpset == null) {
                        bpset = new HashSet<Integer>();
                        this.fileToBreakpointMap.put(filename, bpset);
                    }
                    if (bpset.contains(key = new Integer(info.getLineNumber()))) {
                        prctl.clearBreakpoint(info.getStartPC());
                        bpset.remove(key);
                        BreakpointResult breakpointResult = new BreakpointResult(true, false, info.getLineNumber());
                        return breakpointResult;
                    }
                    System.err.println("Setting breakpoint at PC " + info.getStartPC());
                    prctl.setBreakpoint(info.getStartPC());
                    bpset.add(key);
                    BreakpointResult breakpointResult = new BreakpointResult(true, true, info.getLineNumber());
                    return breakpointResult;
                }
                BreakpointResult bpset = new BreakpointResult(false, false, 0, "No debug information for this source file and line");
                return bpset;
            }
            finally {
                if (mustSuspendAndResume) {
                    prctl.resume();
                }
            }
        }
        BugSpotAgent agent = this.getAgent();
        if (!agent.canInteractWithJava()) {
            String why = agent.isJavaInteractionDisabled() ? "Can not toggle Java breakpoints while stopped because\nof C/C++ debug events (breakpoints, single-stepping)" : "Could not talk to SA's JVMDI module to enable Java\nprogramming language breakpoints (run with -Xdebug -Xrunsa)";
            return new BreakpointResult(false, false, 0, why);
        }
        HashSet<Integer> bpset = (HashSet<Integer>)this.fileToBreakpointMap.get(filename);
        if (bpset == null) {
            bpset = new HashSet<Integer>();
            this.fileToBreakpointMap.put(filename, bpset);
        }
        boolean mustResumeAndSuspend = this.isSuspended();
        try {
            ServiceabilityAgentJVMDIModule.BreakpointToggleResult res;
            if (mustResumeAndSuspend) {
                agent.resume();
            }
            if ((res = this.getAgent().toggleJavaBreakpoint(data.sourceFileName(), data.packageName(), lineNumber)).getSuccess()) {
                Integer key = new Integer(res.getLineNumber());
                boolean addRemRes = false;
                if (res.getWasSet()) {
                    addRemRes = bpset.add(key);
                    System.err.println("Setting breakpoint at " + res.getMethodName() + res.getMethodSignature() + ", bci " + res.getBCI() + ", line " + res.getLineNumber());
                } else {
                    addRemRes = bpset.remove(key);
                    System.err.println("Clearing breakpoint at " + res.getMethodName() + res.getMethodSignature() + ", bci " + res.getBCI() + ", line " + res.getLineNumber());
                }
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(addRemRes, "Inconsistent Java breakpoint state with respect to target process");
                }
                BreakpointResult breakpointResult = new BreakpointResult(true, res.getWasSet(), res.getLineNumber());
                return breakpointResult;
            }
            BreakpointResult breakpointResult = new BreakpointResult(false, false, 0, res.getErrMsg());
            return breakpointResult;
        }
        finally {
            if (mustResumeAndSuspend) {
                agent.suspend();
                this.resetCurrentThread();
            }
        }
    }

    private LineNumberInfo getLineNumberInfo(String filename, int lineNumber) {
        Map map = this.getSourceFileToLineNumberInfoMap();
        List infos = (List)map.get(filename);
        if (infos == null) {
            return null;
        }
        return this.searchLineNumbers(infos, lineNumber, 0, infos.size());
    }

    private Map getSourceFileToLineNumberInfoMap() {
        if (this.sourceFileToLineNumberInfoMap == null) {
            List loadObjects = this.getCDebugger().getLoadObjectList();
            final HashMap map = new HashMap();
            for (LoadObject lo : loadObjects) {
                CDebugInfoDataBase db = lo.getDebugInfoDataBase();
                if (db == null) continue;
                db.iterate(new LineNumberVisitor(){

                    @Override
                    public void doLineNumber(LineNumberInfo info) {
                        String name = info.getSourceFileName();
                        if (name != null) {
                            ArrayList<LineNumberInfo> val = (ArrayList<LineNumberInfo>)map.get(name);
                            if (val == null) {
                                val = new ArrayList<LineNumberInfo>();
                                map.put(name, val);
                            }
                            val.add(info);
                        }
                    }
                });
            }
            for (List list : map.values()) {
                Collections.sort(list, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int n2;
                        LineNumberInfo l1 = (LineNumberInfo)o1;
                        LineNumberInfo l2 = (LineNumberInfo)o2;
                        int n1 = l1.getLineNumber();
                        if (n1 < (n2 = l2.getLineNumber())) {
                            return -1;
                        }
                        if (n1 == n2) {
                            return 0;
                        }
                        return 1;
                    }
                });
            }
            this.sourceFileToLineNumberInfoMap = map;
        }
        return this.sourceFileToLineNumberInfoMap;
    }

    private LineNumberInfo searchLineNumbers(List infoList, int lineNo, int lowIdx, int highIdx) {
        if (highIdx < lowIdx) {
            return null;
        }
        if (lowIdx == highIdx) {
            if (this.checkLineNumber(infoList, lineNo, lowIdx)) {
                return (LineNumberInfo)infoList.get(lowIdx);
            }
            return null;
        }
        if (lowIdx == highIdx - 1) {
            if (this.checkLineNumber(infoList, lineNo, lowIdx)) {
                return (LineNumberInfo)infoList.get(lowIdx);
            }
            if (this.checkLineNumber(infoList, lineNo, highIdx)) {
                return (LineNumberInfo)infoList.get(highIdx);
            }
            return null;
        }
        int midIdx = lowIdx + highIdx >> 1;
        LineNumberInfo info = (LineNumberInfo)infoList.get(midIdx);
        if (lineNo < info.getLineNumber()) {
            return this.searchLineNumbers(infoList, lineNo, lowIdx, midIdx);
        }
        if (lineNo == info.getLineNumber()) {
            return info;
        }
        return this.searchLineNumbers(infoList, lineNo, midIdx, highIdx);
    }

    private boolean checkLineNumber(List infoList, int lineNo, int idx) {
        LineNumberInfo info = (LineNumberInfo)infoList.get(idx);
        return info.getLineNumber() >= lineNo;
    }

    private synchronized void pollForDebugEvent() {
        ProcessControl prctl = this.getCDebugger().getProcessControl();
        if (prctl == null) {
            return;
        }
        DebugEvent ev = prctl.debugEventPoll();
        if (ev != null) {
            DebugEvent.Type t = ev.getType();
            if (t == DebugEvent.Type.LOADOBJECT_LOAD || t == DebugEvent.Type.LOADOBJECT_UNLOAD) {
                this.sourceFileToLineNumberInfoMap = null;
                prctl.debugEventContinue();
            } else if (t == DebugEvent.Type.BREAKPOINT) {
                this.showMessageDialog("Breakpoint reached at PC " + ev.getPC(), "Breakpoint reached", 1);
                this.agent.disableJavaInteraction();
                this.suspend();
                prctl.debugEventContinue();
            } else if (t == DebugEvent.Type.SINGLE_STEP) {
                this.agent.disableJavaInteraction();
                this.suspend();
                prctl.debugEventContinue();
            } else if (t == DebugEvent.Type.ACCESS_VIOLATION) {
                this.showMessageDialog("Access violation attempting to " + (ev.getWasWrite() ? "write" : "read") + " address " + ev.getAddress() + " at PC " + ev.getPC(), "Access Violation", 2);
                this.agent.disableJavaInteraction();
                this.suspend();
                prctl.debugEventContinue();
            } else {
                String info = "Unknown debug event encountered";
                if (ev.getUnknownEventDetail() != null) {
                    info = info + ": " + ev.getUnknownEventDetail();
                }
                this.showMessageDialog(info, "Unknown debug event", 1);
                this.suspend();
                prctl.debugEventContinue();
            }
            return;
        }
        if (this.getAgent().canInteractWithJava() && !this.javaEventPending && this.getAgent().javaEventPending()) {
            this.suspend();
            Event jev = this.getAgent().javaEventPoll();
            if (jev != null) {
                this.javaEventPending = true;
                if (jev.getType() == Event.Type.BREAKPOINT) {
                    BreakpointEvent bpev = (BreakpointEvent)jev;
                    this.showMessageDialog("Breakpoint reached in method\n" + bpev.methodID().method().externalNameAndSignature() + ",\nbci " + bpev.location(), "Breakpoint reached", 1);
                } else if (jev.getType() == Event.Type.EXCEPTION) {
                    ExceptionEvent exev = (ExceptionEvent)jev;
                    this.showMessageDialog(exev.exception().getKlass().getName().asString() + "\nthrown in method\n" + exev.methodID().method().externalNameAndSignature() + "\nat BCI " + exev.location(), "Exception thrown", 1);
                } else {
                    Assert.that(false, "Should not reach here");
                }
            }
        }
    }

    static class JavaUserData {
        private String packageName;
        private String sourceFileName;

        JavaUserData(String packageName, String sourceFileName) {
            this.packageName = packageName;
            this.sourceFileName = sourceFileName;
        }

        String packageName() {
            return this.packageName;
        }

        String sourceFileName() {
            return this.sourceFileName;
        }
    }

    static class JavaFileFilter
    extends FileFilter {
        private String packageName;
        private String fileName;

        JavaFileFilter(String packageName, String fileName) {
            this.packageName = packageName;
            this.fileName = fileName;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (!f.getName().equals(this.fileName)) {
                return false;
            }
            PackageScanner scanner = new PackageScanner();
            String pkg = scanner.scan(f);
            return pkg.equals(this.packageName);
        }

        @Override
        public String getDescription() {
            return "Java source files";
        }
    }

    class DefaultEditorFactory
    implements EditorFactory {
        private LinkedList editors = new LinkedList();

        DefaultEditorFactory() {
        }

        @Override
        public Editor openFile(String filename, EditorCommands commands) {
            DefaultEditor editor = new DefaultEditor(this, filename, BugSpot.this.editorComm);
            if (!editor.openFile()) {
                return null;
            }
            return editor;
        }

        @Override
        public Editor getCurrentEditor() {
            if (this.editors.isEmpty()) {
                return null;
            }
            return (Editor)this.editors.getFirst();
        }

        void editorClosed(Editor editor) {
            this.editors.remove(editor);
        }

        void makeEditorCurrent(Editor editor) {
            this.editors.remove(editor);
            this.editors.addFirst(editor);
        }
    }

    class DefaultEditor
    implements Editor {
        private DefaultEditorFactory factory;
        private FrameWrapper editorFrame;
        private String filename;
        private SourceCodePanel code;
        private boolean shown;
        private Object userData;

        public DefaultEditor(DefaultEditorFactory fact, String filename, final EditorCommands comm) {
            this.filename = filename;
            this.factory = fact;
            this.editorFrame = BugSpot.this.newFrame(filename);
            this.code = new SourceCodePanel();
            this.code.setFont(BugSpot.this.fixedWidthFont);
            this.editorFrame.getContentPane().add(this.code);
            this.editorFrame.setClosable(true);
            this.editorFrame.setResizable(true);
            this.editorFrame.setClosingActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    comm.windowClosed(DefaultEditor.this);
                    BugSpot.this.removeFrame(DefaultEditor.this.editorFrame);
                    DefaultEditor.this.editorFrame.dispose();
                    DefaultEditor.this.factory.editorClosed(DefaultEditor.this);
                }
            });
            this.editorFrame.setActivatedActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultEditor.this.factory.makeEditorCurrent(DefaultEditor.this);
                    DefaultEditor.this.code.requestFocus();
                }
            });
            this.code.setEditorCommands(comm, this);
        }

        public boolean openFile() {
            return this.code.openFile(this.filename);
        }

        @Override
        public String getSourceFileName() {
            return this.filename;
        }

        @Override
        public int getCurrentLineNumber() {
            return this.code.getCurrentLineNumber();
        }

        @Override
        public void showLineNumber(int lineNo) {
            if (!this.shown) {
                BugSpot.this.addFrame(this.editorFrame);
                GraphicsUtilities.reshapeToAspectRatio(this.editorFrame.getComponent(), 1.0f, 0.85f, BugSpot.this.getParentDimension(this.editorFrame.getComponent()));
                this.editorFrame.setVisible(true);
                this.shown = true;
            }
            this.code.showLineNumber(lineNo);
            this.editorFrame.toFront();
        }

        @Override
        public void highlightLineNumber(int lineNo) {
            this.code.highlightLineNumber(lineNo);
        }

        @Override
        public void showBreakpointAtLine(int lineNo) {
            this.code.showBreakpointAtLine(lineNo);
        }

        @Override
        public boolean hasBreakpointAtLine(int lineNo) {
            return this.code.hasBreakpointAtLine(lineNo);
        }

        @Override
        public void clearBreakpointAtLine(int lineNo) {
            this.code.clearBreakpointAtLine(lineNo);
        }

        @Override
        public void clearBreakpoints() {
            this.code.clearBreakpoints();
        }

        @Override
        public void setUserData(Object o) {
            this.userData = o;
        }

        @Override
        public Object getUserData() {
            return this.userData;
        }

        @Override
        public void toFront() {
            this.editorFrame.toFront();
            this.factory.makeEditorCurrent(this);
        }
    }

    static class BreakpointResult {
        private boolean success;
        private boolean set;
        private int lineNo;
        private String why;

        BreakpointResult(boolean success, boolean set, int lineNo) {
            this(success, set, lineNo, null);
        }

        BreakpointResult(boolean success, boolean set, int lineNo, String why) {
            this.success = success;
            this.set = set;
            this.lineNo = lineNo;
            this.why = why;
        }

        public boolean succeeded() {
            return this.success;
        }

        public boolean set() {
            return this.set;
        }

        public int getLine() {
            return this.lineNo;
        }

        public String getWhy() {
            return this.why;
        }
    }
}

