/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colon3Node
extends Node
implements INameNode {
    protected String name;
    private volatile transient IRubyObject cachedValue;
    private volatile int generation;

    public Colon3Node(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.COLON3NODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public RubyModule getEnclosingModule(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime2.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject value2 = this.getValue(context);
        return value2 != null ? value2 : runtime2.getObject().fastGetConstantFromConstMissing(this.name);
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            RubyClass left = runtime2.getObject();
            if (this.hasConstant(left)) {
                return CONSTANT_BYTELIST;
            }
            if (this.hasMethod(left)) {
                return METHOD_BYTELIST;
            }
        }
        catch (JumpException excptn) {
            // empty catch block
        }
        return null;
    }

    private boolean hasConstant(RubyModule left) {
        return left.fastGetConstantAt(this.name) != null;
    }

    private boolean hasMethod(IRubyObject left) {
        return left.getMetaClass().isMethodBound(this.name, true);
    }

    public IRubyObject getValue(ThreadContext context) {
        IRubyObject value2 = this.cachedValue;
        return this.isCached(context, value2) ? value2 : this.reCache(context, this.name);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2) {
        return value2 != null && this.generation == context.getRuntime().getConstantGeneration();
    }

    public IRubyObject reCache(ThreadContext context, String name2) {
        IRubyObject value2;
        Ruby runtime2 = context.getRuntime();
        int newGeneration = runtime2.getConstantGeneration();
        this.cachedValue = value2 = runtime2.getObject().fastGetConstantFromNoConstMissing(name2);
        if (value2 != null) {
            this.generation = newGeneration;
        }
        return value2;
    }
}

