/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.h2.Driver;
import org.h2.message.Message;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDatabase;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;

public class FileSystemDatabase
extends FileSystem {
    private static final HashMap INSTANCES = new HashMap();
    private Connection conn;
    private String url;
    private HashMap preparedMap = new HashMap();
    private boolean log;

    private FileSystemDatabase(String string, Connection connection, boolean bl) throws SQLException {
        this.url = string;
        this.conn = connection;
        this.log = bl;
        Statement statement = connection.createStatement();
        connection.setAutoCommit(false);
        statement.execute("SET ALLOW_LITERALS NONE");
        statement.execute("CREATE TABLE IF NOT EXISTS FILES(ID IDENTITY, PARENTID BIGINT, NAME VARCHAR, LASTMODIFIED BIGINT, LENGTH BIGINT, UNIQUE(PARENTID, NAME))");
        statement.execute("CREATE TABLE IF NOT EXISTS FILEDATA(ID BIGINT PRIMARY KEY, DATA BLOB)");
        PreparedStatement preparedStatement = connection.prepareStatement("SET MAX_LENGTH_INPLACE_LOB ?");
        preparedStatement.setLong(1, 4096L);
        preparedStatement.execute();
        statement.execute("MERGE INTO FILES VALUES(ZERO(), NULL, SPACE(ZERO()), ZERO(), NULL)");
        this.commit();
        if (bl) {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM FILES ORDER BY PARENTID, NAME");
            while (resultSet.next()) {
                long l = resultSet.getLong("ID");
                long l2 = resultSet.getLong("PARENTID");
                String string2 = resultSet.getString("NAME");
                long l3 = resultSet.getLong("LASTMODIFIED");
                long l4 = resultSet.getLong("LENGTH");
                this.log(l + " " + string2 + " parent:" + l2 + " length:" + l4 + " lastMod:" + l3);
            }
        }
    }

    public static synchronized FileSystem getInstance(String string) {
        FileSystemDatabase fileSystemDatabase;
        int n = string.indexOf(47);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((fileSystemDatabase = (FileSystemDatabase)INSTANCES.get(string)) != null) {
            return fileSystemDatabase;
        }
        try {
            Connection connection = string.startsWith("jdbc:h2:") ? Driver.load().connect(string, new Properties()) : JdbcUtils.getConnection(null, string, new Properties());
            boolean bl = string.toUpperCase().indexOf("TRACE_") >= 0;
            fileSystemDatabase = new FileSystemDatabase(string, connection, bl);
            INSTANCES.put(string, fileSystemDatabase);
            return fileSystemDatabase;
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public void close() {
        JdbcUtils.closeSilently(this.conn);
        INSTANCES.remove(this.url);
    }

    private void commit() {
        block2: {
            try {
                this.conn.commit();
            }
            catch (SQLException sQLException) {
                if (!this.log) break block2;
                sQLException.printStackTrace();
            }
        }
    }

    private void rollback() {
        block2: {
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                if (!this.log) break block2;
                sQLException.printStackTrace();
            }
        }
    }

    private void log(String string) {
        if (this.log) {
            System.out.println(string);
        }
    }

    private long getId(String string, boolean bl) {
        string = this.translateFileName(string);
        this.log(string);
        try {
            int n;
            String[] stringArray = StringUtils.arraySplit(string, '/', false);
            long l = 0L;
            int n2 = n = bl ? stringArray.length - 1 : stringArray.length;
            if (string.endsWith("/")) {
                --n;
            }
            for (int i = 1; i < n; ++i) {
                PreparedStatement preparedStatement = this.prepare("SELECT ID FROM FILES WHERE PARENTID=? AND NAME=?");
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, stringArray[i]);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    return -1L;
                }
                l = resultSet.getLong(1);
            }
            return l;
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    private String translateFileName(String string) {
        if (string.startsWith(this.url)) {
            string = string.substring(this.url.length());
        }
        return string;
    }

    private PreparedStatement prepare(String string) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.preparedMap.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
            this.preparedMap.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    private RuntimeException convert(SQLException sQLException) {
        if (this.log) {
            sQLException.printStackTrace();
        }
        return new RuntimeException(sQLException.toString(), sQLException);
    }

    public boolean canWrite(String string) {
        return true;
    }

    public void copy(String string, String string2) throws SQLException {
        try {
            OutputStream outputStream = this.openFileOutputStream(string2, false);
            InputStream inputStream = this.openFileInputStream(string);
            IOUtils.copyAndClose(inputStream, outputStream);
        }
        catch (IOException iOException) {
            this.rollback();
            throw Message.convertIOException(iOException, "Can not copy " + string + " to " + string2);
        }
    }

    public void createDirs(String string) {
        string = this.translateFileName(string);
        try {
            String[] stringArray = StringUtils.arraySplit(string, '/', false);
            long l = 0L;
            int n = stringArray.length;
            if (string.endsWith("/")) {
                --n;
            }
            --n;
            for (int i = 1; i < n; ++i) {
                PreparedStatement preparedStatement = this.prepare("SELECT ID FROM FILES WHERE PARENTID=? AND NAME=?");
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, stringArray[i]);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    preparedStatement = this.prepare("INSERT INTO FILES(NAME, PARENTID, LASTMODIFIED) VALUES(?, ?, ?)");
                    preparedStatement.setString(1, stringArray[i]);
                    preparedStatement.setLong(2, l);
                    preparedStatement.setLong(3, System.currentTimeMillis());
                    preparedStatement.execute();
                    resultSet = JdbcUtils.getGeneratedKeys(preparedStatement);
                    resultSet.next();
                    l = resultSet.getLong(1);
                    continue;
                }
                l = resultSet.getLong(1);
            }
            this.commit();
        }
        catch (SQLException sQLException) {
            this.rollback();
            throw this.convert(sQLException);
        }
    }

    public boolean createNewFile(String string) throws SQLException {
        try {
            if (this.exists(string)) {
                return false;
            }
            this.openFileObject(string, "rw").close();
            return true;
        }
        catch (IOException iOException) {
            throw Message.convert(iOException);
        }
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        string = string + ".";
        int n = 0;
        while (true) {
            String string3;
            if (!this.exists(string3 = string + n + string2)) {
                this.openFileObject(string3, "rw").close();
                return string3;
            }
            ++n;
        }
    }

    public synchronized void delete(String string) {
        try {
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("DELETE FROM FILES WHERE ID=?");
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
            preparedStatement = this.prepare("DELETE FROM FILEDATA WHERE ID=?");
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
            this.commit();
        }
        catch (SQLException sQLException) {
            this.rollback();
            throw this.convert(sQLException);
        }
    }

    public void deleteRecursive(String string) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public boolean exists(String string) {
        long l = this.getId(string, false);
        return l >= 0L;
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.translateFileName(string);
        return string.startsWith(string2);
    }

    public String getAbsolutePath(String string) {
        return string;
    }

    public String getFileName(String string) {
        string = this.translateFileName(string);
        String[] stringArray = StringUtils.arraySplit(string, '/', false);
        return stringArray[stringArray.length - 1];
    }

    public synchronized long getLastModified(String string) {
        try {
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("SELECT LASTMODIFIED FROM FILES WHERE ID=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            return resultSet.getLong(1);
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    public String getParent(String string) {
        int n = Math.max(string.indexOf(58), string.lastIndexOf(47));
        return string.substring(0, n);
    }

    public boolean isAbsolute(String string) {
        return true;
    }

    public synchronized boolean isDirectory(String string) {
        try {
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("SELECT LENGTH FROM FILES WHERE ID=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            resultSet.getLong(1);
            return resultSet.wasNull();
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    public boolean isReadOnly(String string) {
        return false;
    }

    public synchronized long length(String string) {
        try {
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("SELECT LENGTH FROM FILES WHERE ID=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            return resultSet.getLong(1);
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    public synchronized String[] listFiles(String string) {
        try {
            String string2 = string;
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("SELECT NAME FROM FILES WHERE PARENTID=? ORDER BY NAME");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(string2 + resultSet.getString(1));
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    public String normalize(String string) {
        return string;
    }

    public InputStream openFileInputStream(String string) throws IOException {
        return new FileObjectInputStream(this.openFileObject(string, "r"));
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        try {
            long l = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("SELECT DATA FROM FILEDATA WHERE ID=?");
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                InputStream inputStream = resultSet.getBinaryStream(1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copyAndClose(inputStream, byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return new FileObjectDatabase(this, string, byArray, false);
            }
            return new FileObjectDatabase(this, string, new byte[0], true);
        }
        catch (SQLException sQLException) {
            throw this.convert(sQLException);
        }
    }

    public OutputStream openFileOutputStream(String string, boolean bl) throws SQLException {
        try {
            return new FileObjectOutputStream(this.openFileObject(string, "rw"), bl);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, string);
        }
    }

    public synchronized void rename(String string, String string2) {
        try {
            long l = this.getId(string, true);
            long l2 = this.getId(string2, true);
            if (l != l2) {
                throw Message.getUnsupportedException();
            }
            string2 = this.getFileName(string2);
            long l3 = this.getId(string, false);
            PreparedStatement preparedStatement = this.prepare("UPDATE FILES SET NAME=? WHERE ID=?");
            preparedStatement.setString(1, string2);
            preparedStatement.setLong(2, l3);
            preparedStatement.execute();
            this.commit();
        }
        catch (SQLException sQLException) {
            this.rollback();
            throw this.convert(sQLException);
        }
    }

    public boolean tryDelete(String string) {
        this.delete(string);
        return true;
    }

    synchronized void write(String string, byte[] byArray, int n) {
        try {
            long l = this.getId(string, false);
            if (l >= 0L) {
                PreparedStatement preparedStatement = this.prepare("DELETE FROM FILES WHERE ID=?");
                preparedStatement.setLong(1, l);
                preparedStatement.execute();
                preparedStatement = this.prepare("DELETE FROM FILEDATA WHERE ID=?");
                preparedStatement.setLong(1, l);
                preparedStatement.execute();
            }
            long l2 = this.getId(string, true);
            PreparedStatement preparedStatement = this.prepare("INSERT INTO FILES(PARENTID, NAME, LASTMODIFIED) VALUES(?, ?, ?)");
            preparedStatement.setLong(1, l2);
            preparedStatement.setString(2, this.getFileName(string));
            preparedStatement.setLong(3, System.currentTimeMillis());
            preparedStatement.execute();
            ResultSet resultSet = JdbcUtils.getGeneratedKeys(preparedStatement);
            resultSet.next();
            l = resultSet.getLong(1);
            preparedStatement = this.prepare("INSERT INTO FILEDATA(ID, DATA) VALUES(?, ?)");
            preparedStatement.setLong(1, l);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, -1);
            preparedStatement.execute();
            preparedStatement = this.prepare("UPDATE FILES SET LENGTH=(SELECT LENGTH(DATA) FROM FILEDATA WHERE ID=?) WHERE ID=?");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            preparedStatement.execute();
            this.commit();
        }
        catch (SQLException sQLException) {
            this.rollback();
            throw this.convert(sQLException);
        }
    }
}

