/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class SelectUnion
extends Query {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int EXCEPT = 2;
    public static final int INTERSECT = 3;
    private int unionType;
    private Query left;
    private Query right;
    private ObjectArray expressions;
    private ObjectArray orderList;
    private SortOrder sort;
    private boolean distinct;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    public void setUnionType(int n) {
        this.unionType = n;
    }

    public void setRight(Query query) {
        this.right = query;
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public void setOrder(ObjectArray objectArray) {
        this.orderList = objectArray;
    }

    private Value[] convert(Value[] valueArray, int n) throws SQLException {
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)this.expressions.get(i);
            valueArray[i] = valueArray[i].convertTo(expression.getType());
        }
        return valueArray;
    }

    public LocalResult queryMeta() throws SQLException {
        ObjectArray objectArray = this.left.getExpressions();
        int n = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, objectArray, n);
        localResult.done();
        return localResult;
    }

    protected LocalResult queryWithoutCache(int n) throws SQLException {
        if (n != 0) {
            if (this.limit != null) {
                n = Math.min(this.limit.getValue(this.session).getInt(), n);
            }
            this.limit = ValueExpression.get(ValueInt.get(n));
        }
        int n2 = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressions, n2);
        localResult.setSortOrder(this.sort);
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            localResult.setDistinct();
        }
        switch (this.unionType) {
            case 0: 
            case 2: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                localResult.setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.unionType);
            }
        }
        LocalResult localResult2 = this.left.query(0);
        LocalResult localResult3 = this.right.query(0);
        localResult2.reset();
        localResult3.reset();
        switch (this.unionType) {
            case 0: 
            case 1: {
                while (localResult2.next()) {
                    localResult.addRow(this.convert(localResult2.currentRow(), n2));
                }
                while (localResult3.next()) {
                    localResult.addRow(this.convert(localResult3.currentRow(), n2));
                }
                break;
            }
            case 2: {
                while (localResult2.next()) {
                    localResult.addRow(this.convert(localResult2.currentRow(), n2));
                }
                while (localResult3.next()) {
                    localResult.removeDistinct(this.convert(localResult3.currentRow(), n2));
                }
                break;
            }
            case 3: {
                LocalResult localResult4 = new LocalResult(this.session, this.expressions, n2);
                localResult4.setDistinct();
                while (localResult2.next()) {
                    localResult4.addRow(this.convert(localResult2.currentRow(), n2));
                }
                while (localResult3.next()) {
                    Value[] valueArray = this.convert(localResult3.currentRow(), n2);
                    if (!localResult4.containsDistinct(valueArray)) continue;
                    localResult.addRow(valueArray);
                }
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.unionType);
            }
        }
        if (this.offset != null) {
            localResult.setOffset(this.offset.getValue(this.session).getInt());
        }
        if (this.limit != null) {
            localResult.setLimit(this.limit.getValue(this.session).getInt());
        }
        localResult.done();
        return localResult;
    }

    public void init() throws SQLException {
        if (SysProperties.CHECK && this.checkInit) {
            Message.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw Message.getSQLException(21002);
        }
        ObjectArray objectArray = this.left.getExpressions();
        this.expressions = new ObjectArray();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)objectArray.get(i);
            this.expressions.add(expression);
        }
    }

    public void prepare() throws SQLException {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            Message.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = new ObjectArray();
        ObjectArray objectArray = this.left.getExpressions();
        ObjectArray objectArray2 = this.right.getExpressions();
        for (int i = 0; i < n; ++i) {
            Expression expression = (Expression)objectArray.get(i);
            Expression expression2 = (Expression)objectArray2.get(i);
            int n2 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n3 = Math.max(expression.getScale(), expression2.getScale());
            int n4 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            Column column = new Column(expression.getAlias(), n2, l, n3, n4);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            this.initOrder(this.expressions, null, this.orderList, this.getColumnCount(), true);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
    }

    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    public HashSet getTables() {
        HashSet hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public ObjectArray getExpressions() {
        return this.expressions;
    }

    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    public void addGlobalCondition(Parameter parameter, int n, int n2) throws SQLException {
        this.addParameter(parameter);
        switch (this.unionType) {
            case 0: 
            case 1: 
            case 3: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case 2: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.unionType);
            }
        }
    }

    public String getPlanSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(StringUtils.unEnclose(this.left.getPlanSQL()));
        stringBuffer.append(')');
        switch (this.unionType) {
            case 1: {
                stringBuffer.append("UNION ALL ");
                break;
            }
            case 0: {
                stringBuffer.append("UNION ");
                break;
            }
            case 3: {
                stringBuffer.append("INTERSECT ");
                break;
            }
            case 2: {
                stringBuffer.append("EXCEPT ");
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.unionType);
            }
        }
        stringBuffer.append('(');
        stringBuffer.append(StringUtils.unEnclose(this.right.getPlanSQL()));
        stringBuffer.append(')');
        Object[] objectArray = new Expression[this.expressions.size()];
        this.expressions.toArray(objectArray);
        if (this.sort != null) {
            stringBuffer.append(" ORDER BY ");
            stringBuffer.append(this.sort.getSQL((Expression[])objectArray, objectArray.length));
        }
        if (this.limit != null) {
            stringBuffer.append(" LIMIT ");
            stringBuffer.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                stringBuffer.append(" OFFSET ");
                stringBuffer.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        if (this.isForUpdate) {
            stringBuffer.append(" FOR UPDATE");
        }
        return stringBuffer.toString();
    }

    public LocalResult query(int n) throws SQLException {
        return this.queryWithoutCache(n);
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    public String getFirstColumnAlias(Session session) {
        return null;
    }
}

