/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.util.BitField;
import org.h2.value.Value;

public class PageLog {
    private static final int NO_OP = 0;
    private static final int UNDO = 1;
    private static final int COMMIT = 2;
    private static final int ADD = 3;
    private static final int REMOVE = 4;
    private PageStore store;
    private Trace trace;
    private BitField undo = new BitField();
    private PageOutputStream pageOut;
    private DataOutputStream out;
    private int firstPage;
    private DataPage data;
    private boolean recoveryRunning;
    private long operation;

    PageLog(PageStore pageStore, int n) {
        this.store = pageStore;
        this.firstPage = n;
        this.data = pageStore.createDataPage();
        this.trace = pageStore.getTrace();
    }

    void openForWriting() {
        this.trace.debug("log openForWriting");
        this.pageOut = new PageOutputStream(this.store, 0, this.firstPage, 5, true);
        this.out = new DataOutputStream(this.pageOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(boolean bl) throws SQLException {
        this.trace.debug("log recover");
        DataInputStream dataInputStream = new DataInputStream(new PageInputStream(this.store, 0, this.firstPage, 5));
        DataPage dataPage = this.store.createDataPage();
        try {
            int n;
            this.recoveryRunning = true;
            while ((n = dataInputStream.read()) >= 0) {
                int n2;
                if (n == 0) continue;
                if (n == 1) {
                    n2 = dataInputStream.readInt();
                    dataInputStream.read(dataPage.getBytes(), 0, this.store.getPageSize());
                    if (!bl) continue;
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log write " + n2);
                    }
                    this.store.writePage(n2, dataPage);
                    continue;
                }
                if (n == 3 || n == 4) {
                    n2 = dataInputStream.readInt();
                    int n3 = dataInputStream.readInt();
                    Row row = this.readRow(dataInputStream);
                    Database database = this.store.getDatabase();
                    if (bl) continue;
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log redo " + (n == 3 ? "+" : "-") + " " + row);
                    }
                    database.redo(n3, row, n == 3);
                    continue;
                }
                if (n != 2) continue;
            }
        }
        catch (Exception exception) {
            this.trace.debug("log recovery stopped: " + exception.toString());
        }
        finally {
            this.recoveryRunning = false;
        }
        this.trace.debug("log recover done");
    }

    private Row readRow(DataInputStream dataInputStream) throws IOException, SQLException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        this.data.reset();
        this.data.checkCapacity(n2);
        dataInputStream.read(this.data.getBytes(), 0, n2);
        int n3 = this.data.readInt();
        Value[] valueArray = new Value[n3];
        for (int i = 0; i < n3; ++i) {
            valueArray[i] = this.data.readValue();
        }
        Row row = new Row(valueArray, 0);
        row.setPos(n);
        return row;
    }

    public void addUndo(int n, DataPage dataPage) throws SQLException {
        try {
            if (this.undo.get(n)) {
                return;
            }
            this.out.write(1);
            this.out.writeInt(n);
            this.out.write(dataPage.getBytes(), 0, this.store.getPageSize());
            this.undo.set(n);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    public void commit(Session session) throws SQLException {
        try {
            this.trace.debug("log commit");
            this.out.write(2);
            this.out.writeInt(session.getId());
            if (this.store.getDatabase().getLog().getFlushOnEachCommit()) {
                this.flush();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    public void addOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        try {
            if (this.recoveryRunning) {
                return;
            }
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("log " + (bl ? "+" : "-") + " table:" + n + " remaining:" + this.pageOut.getRemainingBytes() + " row:" + row);
            }
            session.addLogPos(0, (int)this.operation);
            row.setLastLog(0, (int)this.operation);
            this.out.write(bl ? 3 : 4);
            this.out.writeInt(session.getId());
            this.out.writeInt(n);
            this.out.writeInt(row.getPos());
            this.data.reset();
            row.write(this.data);
            this.out.writeInt(this.data.length());
            this.out.write(this.data.getBytes(), 0, this.data.length());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void reopen() throws SQLException {
        try {
            this.trace.debug("log reopen");
            this.out.close();
            this.openForWriting();
            this.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    public void flush() throws SQLException {
        try {
            this.trace.debug("log flush");
            this.out.flush();
            int n = this.pageOut.getRemainingBytes();
            for (int i = 0; i < n; ++i) {
                this.out.writeByte(0);
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }
}

