/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.container.ParcelDescriptor;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Parcel
implements XNameContainer {
    protected ParcelDescriptor m_descriptor;
    protected String name;
    protected ParcelContainer parent;
    protected XSimpleFileAccess m_xSFA;

    public Parcel(XSimpleFileAccess xSimpleFileAccess, ParcelContainer parcelContainer, ParcelDescriptor parcelDescriptor, String string) {
        this(parcelContainer, parcelDescriptor, string);
        this.m_xSFA = xSimpleFileAccess;
    }

    public Parcel(ParcelContainer parcelContainer, ParcelDescriptor parcelDescriptor, String string) {
        this.parent = parcelContainer;
        this.m_descriptor = parcelDescriptor;
        this.name = string;
    }

    public boolean isUnoPkg() {
        return this.parent.isUnoPkg();
    }

    public String getName() {
        return this.name;
    }

    public Object getByName(String string) throws NoSuchElementException, WrappedTargetException {
        Object object;
        ScriptEntry scriptEntry;
        block4: {
            LogUtils.DEBUG("** Parcel.getByName for " + string);
            scriptEntry = null;
            try {
                if (this.m_descriptor == null || !this.hasElements() || ((ScriptEntry[])(object = this.m_descriptor.getScriptEntries())).length == 0) break block4;
                for (int i = 0; i < ((ScriptEntry[])object).length; ++i) {
                    if (!object[i].getLanguageName().equals(string)) continue;
                    scriptEntry = object[i];
                    break;
                }
            }
            catch (Exception exception) {
                throw new WrappedTargetException(exception.toString());
            }
        }
        if (scriptEntry == null) {
            LogUtils.DEBUG("No script for " + string);
            throw new NoSuchElementException("No script named " + string);
        }
        object = new ScriptMetaData(this, scriptEntry, null);
        LogUtils.DEBUG("returning date  for " + string);
        return object;
    }

    public String[] getElementNames() {
        String[] stringArray = new String[]{};
        if (this.m_descriptor != null) {
            ScriptEntry[] scriptEntryArray = this.m_descriptor.getScriptEntries();
            stringArray = new String[scriptEntryArray.length];
            for (int i = 0; i < scriptEntryArray.length; ++i) {
                stringArray[i] = scriptEntryArray[i].getLanguageName();
            }
        }
        return stringArray;
    }

    public boolean hasByName(String string) {
        boolean bl = true;
        Object object = null;
        try {
            object = this.getByName(string);
            if (object != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        return this.m_descriptor != null && this.m_descriptor.getScriptEntries().length > 0;
    }

    public void replaceByName(String string, Object object) throws IllegalArgumentException, NoSuchElementException, WrappedTargetException {
        if (this.m_descriptor != null) {
            try {
                ScriptEntry scriptEntry = (ScriptEntry)this.getByName(string);
                if (scriptEntry == null) {
                    throw new NoSuchElementException("No script named " + string);
                }
            }
            catch (Exception exception) {
                throw new WrappedTargetException();
            }
        }
    }

    public void insertByName(String string, Object object) throws IllegalArgumentException, ElementExistException, WrappedTargetException {
        try {
            if (this.hasByName(string)) {
                throw new ElementExistException(string);
            }
            ScriptMetaData scriptMetaData = (ScriptMetaData)object;
            if (scriptMetaData.hasSource()) {
                LogUtils.DEBUG("Inserting source: " + scriptMetaData.getSource());
                if (!scriptMetaData.writeSourceFile()) {
                    throw new WrappedTargetException("Failed to create source file " + scriptMetaData.getLanguageName());
                }
            }
            this.m_descriptor.addScriptEntry(scriptMetaData);
            this.writeParcelDescriptor();
        }
        catch (Exception exception) {
            LogUtils.DEBUG("Failed to insert entry " + string + ": " + exception.getMessage());
            throw new WrappedTargetException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParcelDescriptor() throws CommandAbortedException, com.sun.star.io.IOException, com.sun.star.uno.Exception, IOException {
        String string = PathUtils.make_url(this.getPathToParcel(), "parcel-descriptor.xml");
        XSimpleFileAccess2 xSimpleFileAccess2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)this.m_xSFA);
        if (xSimpleFileAccess2 != null) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            XInputStreamImpl xInputStreamImpl = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream(1024);
                this.m_descriptor.write(byteArrayOutputStream);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                xInputStreamImpl = new XInputStreamImpl(byteArrayInputStream);
                xSimpleFileAccess2.writeFile(string, xInputStreamImpl);
            }
            finally {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (xInputStreamImpl != null) {
                    xInputStreamImpl.closeInput();
                }
            }
        }
    }

    public void removeByName(String string) throws NoSuchElementException, WrappedTargetException {
        try {
            ScriptMetaData scriptMetaData = null;
            scriptMetaData = (ScriptMetaData)this.getByName(string);
            if (scriptMetaData != null) {
                if (!scriptMetaData.removeSourceFile()) {
                    LogUtils.DEBUG("** Parcel.removeByName Failed to remove script " + string);
                    throw new WrappedTargetException("Failed to remove script " + string);
                }
            } else {
                throw new NoSuchElementException("No script named " + string);
            }
            LogUtils.DEBUG("** Parcel.removeByName have removed script source file " + string);
            this.m_descriptor.removeScriptEntry(scriptMetaData);
            this.writeParcelDescriptor();
        }
        catch (Exception exception) {
            LogUtils.DEBUG("** Parcel.removeByName Exception: " + exception);
            throw new WrappedTargetException(exception.toString());
        }
    }

    public void rename(String string) throws WrappedTargetException {
        this.name = string;
    }

    public ParcelContainer getParent() {
        return this.parent;
    }

    public String getPathToParcel() {
        String string = this.parent.getParcelContainerDir() + "/" + this.name;
        return string;
    }
}

