/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordDocument;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements DocumentSerializer,
OfficeConstants {
    private PocketWordDocument pswDoc;
    private SxwDocument sxwDoc;
    private StyleCatalog styleCat = null;
    private boolean inList = false;

    public DocumentSerializerImpl(Document document) {
        this.sxwDoc = (SxwDocument)document;
        this.pswDoc = new PocketWordDocument(this.sxwDoc.getName());
    }

    @Override
    public ConvertData serialize() throws IOException, ConvertException {
        ConvertData convertData = new ConvertData();
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        this.loadStyles();
        NodeList nodeList = document.getElementsByTagName("office:body");
        int n = nodeList.getLength();
        if (n > 0) {
            Node node = nodeList.item(0);
            this.traverseBody(node);
        }
        convertData.addDocument(this.pswDoc);
        return convertData;
    }

    private void loadStyles() {
        int n;
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        org.w3c.dom.Document document2 = this.sxwDoc.getStyleDOM();
        this.styleCat = new StyleCatalog(25);
        NodeList nodeList = null;
        String[] stringArray = new String[]{"text", "paragraph", "paragraph"};
        Class[] classArray = new Class[]{TextStyle.class, ParaStyle.class, TextStyle.class};
        String[] stringArray2 = new String[]{"office:styles", "office:automatic-styles", "office:master-styles"};
        if (document2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                nodeList = document2.getElementsByTagName(stringArray2[n]);
                if (nodeList.getLength() == 0) continue;
                this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
            }
        }
        for (n = 0; n < stringArray2.length; ++n) {
            nodeList = document.getElementsByTagName(stringArray2[n]);
            if (nodeList.getLength() == 0) continue;
            this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
        }
    }

    private void traverseBody(Node node) throws IOException, ConvertException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("text:p") || string.equals("text:h")) {
                    this.traverseParagraph(node2);
                }
                if (!string.equals("text:unordered-list") && !string.equals("text:ordered-list")) continue;
                this.traverseList(node2);
            }
        }
    }

    private void traverseParagraph(Node node) throws IOException, ConvertException {
        String string = this.getAttribute(node, "text:style-name");
        ParaStyle paraStyle = (ParaStyle)this.styleCat.lookup(string, "paragraph", null, ParaStyle.class);
        if (paraStyle != null) {
            paraStyle = (ParaStyle)paraStyle.getResolved();
        }
        TextStyle textStyle = (TextStyle)this.styleCat.lookup(string, "paragraph", null, TextStyle.class);
        if (paraStyle != null) {
            textStyle = (TextStyle)textStyle.getResolved();
        }
        try {
            this.pswDoc.addParagraph(paraStyle, this.inList);
        }
        catch (Exception exception) {
            throw new ConvertException("Error adding paragraph to PocketWordDocument.\n" + exception.toString());
        }
        this.traverseParagraphContents(node, textStyle);
    }

    private void traverseParagraphContents(Node node, TextStyle textStyle) throws IOException, ConvertException {
        String string = this.getAttribute(node, "text:style-name");
        TextStyle textStyle2 = (TextStyle)this.styleCat.lookup(string, "text", null, TextStyle.class);
        if (textStyle2 == null) {
            textStyle2 = textStyle;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            block10: for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                short s = node2.getNodeType();
                switch (s) {
                    case 3: {
                        String string2 = node2.getNodeValue();
                        if (string2.length() <= 0) continue block10;
                        try {
                            this.pswDoc.addParagraphData(string2, textStyle2);
                            continue block10;
                        }
                        catch (Exception exception) {
                            throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                        }
                    }
                    case 1: {
                        if (node2.getNodeName().equals("text:s")) {
                            StringBuffer stringBuffer = new StringBuffer("");
                            int n2 = 1;
                            NamedNodeMap namedNodeMap = node2.getAttributes();
                            if (namedNodeMap.getLength() > 0) {
                                Node node3 = namedNodeMap.getNamedItem("text:c");
                                n2 = Integer.parseInt(node3.getNodeValue().trim());
                            }
                            while (n2 > 0) {
                                stringBuffer.append(" ");
                                --n2;
                            }
                            try {
                                this.pswDoc.addParagraphData(stringBuffer.toString(), textStyle2);
                                continue block10;
                            }
                            catch (Exception exception) {
                                throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                            }
                        }
                        if (node2.getNodeName().equals("text:tab-stop")) {
                            try {
                                this.pswDoc.addParagraphData("\t", textStyle2);
                                continue block10;
                            }
                            catch (Exception exception) {
                                throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                            }
                        }
                        if (node2.getNodeName().equals("text:line-break")) continue block10;
                        if (node2.getNodeName().equals("text:span")) {
                            this.traverseParagraphContents(node2, textStyle);
                            continue block10;
                        }
                        if (!node2.getNodeName().equals("text:a")) continue block10;
                        this.traverseParagraphContents(node2, textStyle);
                        continue block10;
                    }
                }
            }
        } else {
            this.pswDoc.addParagraphData("", textStyle2);
        }
    }

    private void traverseList(Node node) throws IOException, ConvertException {
        this.inList = true;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !(string = node2.getNodeName()).equals("text:list-item")) continue;
                this.traverseListItem(node2);
            }
        }
        this.inList = false;
    }

    private void traverseListItem(Node node) throws IOException, ConvertException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !(string = node2.getNodeName()).equals("text:p")) continue;
                this.traverseParagraph(node2);
            }
        }
    }

    private String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }
}

