-- File: jc2.vhd
-- Generated by MyHDL 0.7dev
-- Date: Thu Sep 30 16:28:28 2010



package pck_jc2 is

    type t_enum_DirType_1 is (
    RIGHT,
    LEFT
);

end package pck_jc2;

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_07dev.all;

use work.pck_jc2.all;

entity jc2 is
    port (
        goLeft: in std_logic;
        goRight: in std_logic;
        stop: in std_logic;
        clk: in std_logic;
        q: inout unsigned(3 downto 0)
    );
end entity jc2;
-- A bi-directional 4-bit Johnson counter with stop control.
-- 
-- I/O pins:
-- --------
-- clk      : input free-running slow clock 
-- goLeft   : input signal to shift left (active-low switch)
-- goRight   : input signal to shift right (active-low switch)
-- stop     : input signal to stop counting (active-low switch)
-- q        : 4-bit counter output (active-low LEDs; q[0] is right-most)
-- 
-- Operation:
-- ---------
-- The counter is triggered on the rising edge of the clock (clk). 
-- A low pulse on the goLeft input will cause the counter to start 
-- shifting left from its current state. A low pulse on the goRight
-- input will cause the counter to start shifting right from its 
-- current state. A low pulse on the stop input will cause the 
-- counter to hold its current state until goLeft or goRight is pulsed.
-- 
-- After power-up, the counter is stopped with all outputs low (LEDs lit).

architecture MyHDL of jc2 is

signal run: std_logic;
signal dir: t_enum_DirType_1;

begin




JC2_LOGIC: process (clk) is
begin
    if rising_edge(clk) then
        if (goRight = '0') then
            dir <= RIGHT;
            run <= '1';
        elsif (goLeft = '0') then
            dir <= LEFT;
            run <= '1';
        end if;
        if (stop = '0') then
            run <= '0';
        end if;
        if to_boolean(run) then
            if (dir = LEFT) then
                q(4-1 downto 1) <= q(3-1 downto 0);
                q(0) <= to_std_logic((not to_boolean(q(3))));
            else
                q(3-1 downto 0) <= q(4-1 downto 1);
                q(3) <= to_std_logic((not to_boolean(q(0))));
            end if;
        end if;
    end if;
end process JC2_LOGIC;

end architecture MyHDL;
