/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.BasicSearchForm;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTypePanel;
import org.netbeans.modules.search.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public final class SearchPanel
extends JPanel
implements PropertyChangeListener,
FocusListener,
ChangeListener,
ActionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private final BasicSearchForm basicCriteriaPanel;
    private final boolean projectWide;
    private final boolean searchAndReplace;
    private final JButton okButton;
    private final JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List<SearchTypePanel> orderedSearchTypePanels;
    private JTabbedPane tabbedPane;

    SearchPanel(Map<SearchScope, Boolean> searchScopes, String preferredSearchScopeType, boolean searchAndReplace) {
        this(searchScopes, preferredSearchScopeType, null, Utils.cloneSearchTypes(Utils.getSearchTypes()), false, searchAndReplace);
    }

    SearchPanel(Map<SearchScope, Boolean> searchScopes, String preferredSearchScopeType, BasicSearchCriteria basicSearchCriteria, Collection<? extends SearchType> extraSearchTypes) {
        this(searchScopes, preferredSearchScopeType, basicSearchCriteria, extraSearchTypes, true, basicSearchCriteria.isSearchAndReplace());
    }

    private SearchPanel(Map<SearchScope, Boolean> searchScopes, String preferredSearchScopeType, BasicSearchCriteria basicSearchCriteria, Collection<? extends SearchType> extraSearchTypes, boolean activateWithPreviousValues, boolean searchAndReplace) {
        assert (extraSearchTypes != null);
        if (extraSearchTypes == null) {
            extraSearchTypes = Collections.emptyList();
        }
        this.projectWide = SearchScopeRegistry.hasProjectSearchScopes(searchScopes.keySet());
        this.searchAndReplace = searchAndReplace;
        this.basicCriteriaPanel = new BasicSearchForm(searchScopes, preferredSearchScopeType, basicSearchCriteria, searchAndReplace, activateWithPreviousValues);
        this.basicCriteriaPanel.setUsabilityChangeListener(this);
        this.setLayout(new GridLayout(1, 1));
        if (!extraSearchTypes.isEmpty()) {
            this.orderedSearchTypePanels = new ArrayList<SearchTypePanel>(extraSearchTypes.size());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add(this.basicCriteriaPanel);
            HashSet<String> processedClassNames = new HashSet<String>();
            for (SearchType searchType : extraSearchTypes) {
                SearchTypePanel newPanel;
                int index;
                String className = searchType.getClass().getName();
                if (!processedClassNames.add(className) || (index = this.orderedSearchTypePanels.indexOf(newPanel = new SearchTypePanel(searchType))) != -1) continue;
                this.orderedSearchTypePanels.add(newPanel);
                newPanel.addPropertyChangeListener(this);
                this.tabbedPane.add(newPanel);
            }
            this.add(this.tabbedPane);
            int tabIndex = 0;
            if (activateWithPreviousValues) {
                int n = this.getIndexOfSearchType(FindDialogMemory.getDefault().getLastSearchType());
                tabIndex = n + 1;
            }
            this.tabbedPane.setSelectedIndex(tabIndex);
            this.updateFirstTabText();
            this.updateExtraTabsTexts();
        } else {
            this.orderedSearchTypePanels = null;
            this.tabbedPane = null;
            this.add(this.basicCriteriaPanel);
        }
        this.setName(NbBundle.getMessage(SearchPanel.class, (String)"TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_SEARCH"));
        this.updateIsCustomized();
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"TEXT_BUTTON_CANCEL"));
        this.initAccessibility();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.doClose(evt.getSource() == this.okButton ? 1 : 0);
    }

    SearchScope getSearchScope() {
        return this.basicCriteriaPanel.getSelectedSearchScope();
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        BasicSearchCriteria basicCriteria = this.basicCriteriaPanel.getBasicSearchCriteria();
        return basicCriteria.isUsable() ? basicCriteria : null;
    }

    List<SearchType> getSearchTypes() {
        List<SearchType> result;
        if (this.orderedSearchTypePanels == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
            for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
                result.add(searchTypePanel.getSearchType());
            }
        }
        return result;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_SearchPanel"));
        if (this.tabbedPane != null) {
            this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SearchPanel.class).getString("ACSN_Tabs"));
            this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACSD_Tabs"));
        }
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SearchPanel.class).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private String getTabText(int index) {
        String text;
        if (index == 0) {
            text = NbBundle.getMessage(this.getClass(), (String)"BasicSearchForm.tabText");
            if (this.basicCriteriaPanel.getBasicSearchCriteria().isUsable()) {
                text = text + " *";
            }
        } else {
            text = this.orderedSearchTypePanels.get(index - 1).getName();
        }
        return text;
    }

    List<SearchType> getCustomizedSearchTypes() {
        if (this.orderedSearchTypePanels == null) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> searchTypeList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
            if (!searchTypePanel.isCustomized()) continue;
            searchTypeList.add(searchTypePanel.getSearchType());
        }
        return searchTypeList;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int returnStatus) {
        int selectedIndex;
        if (this.orderedSearchTypePanels != null) {
            for (SearchTypePanel panel : this.orderedSearchTypePanels) {
                panel.removePropertyChangeListener(this);
            }
        }
        int n = selectedIndex = this.tabbedPane == null ? 0 : this.tabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            if (returnStatus == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(null);
                this.basicCriteriaPanel.onOk();
            }
        } else if (selectedIndex > 0) {
            SearchTypePanel panel;
            panel = this.getSearchTypePanel(selectedIndex);
            if (returnStatus == 1) {
                FindDialogMemory.getDefault().setLastUsedSearchType(panel.getSearchType());
                panel.onOk();
            } else {
                panel.onCancel();
            }
        }
        this.returnStatus = returnStatus;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    void showDialog() {
        String titleMsgKey = this.projectWide ? (this.searchAndReplace ? "LBL_ReplaceInProjects" : "LBL_FindInProjects") : (this.searchAndReplace ? "LBL_ReplaceInFiles" : "LBL_FindInFiles");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)titleMsgKey), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), (ActionListener)this);
        dialogDescriptor.setTitle(NbBundle.getMessage(this.getClass(), (String)titleMsgKey));
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setModal(true);
        if (this.tabbedPane != null) {
            this.tabbedPane.addFocusListener(this);
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent e) {
        SearchTypePanel panel;
        assert (this.tabbedPane != null);
        this.tabbedPane.removeFocusListener(this);
        Component defaultComp = null;
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            defaultComp = this.basicCriteriaPanel;
        } else if (selectedIndex > 0 && (panel = this.getSearchTypePanel(selectedIndex)) != null) {
            defaultComp = panel.customizerComponent;
        }
        if (defaultComp != null) {
            ((Component)defaultComp).requestFocusInWindow();
        }
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.basicCriteriaPanel) {
            this.updateIsCustomized();
            if (this.tabbedPane != null) {
                this.updateFirstTabText();
            }
        } else {
            this.tabSelectionChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("customized".equals(event.getPropertyName())) {
            this.updateIsCustomized();
            if (this.tabbedPane != null) {
                this.updateExtraTabsTexts();
            }
        }
    }

    private void updateFirstTabText() {
        assert (this.tabbedPane != null);
        this.tabbedPane.setTitleAt(0, this.getTabText(0));
    }

    private void updateExtraTabsTexts() {
        assert (this.tabbedPane != null);
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 1; i < tabCount; ++i) {
            this.tabbedPane.setTitleAt(i, this.getTabText(i));
        }
    }

    private void updateIsCustomized() {
        this.okButton.setEnabled(this.checkIsCustomized());
    }

    private boolean checkIsCustomized() {
        if (this.basicCriteriaPanel.isUsable()) {
            return true;
        }
        if (this.orderedSearchTypePanels != null && !this.orderedSearchTypePanels.isEmpty()) {
            for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
                if (!searchTypePanel.isCustomized()) continue;
                return true;
            }
        }
        return false;
    }

    private void tabSelectionChanged() {
        SearchTypePanel panel;
        assert (this.tabbedPane != null);
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex != 0 && selectedIndex > 0 && (panel = this.getSearchTypePanel(selectedIndex)) != null) {
            panel.initializeWithObject();
        }
    }

    private SearchTypePanel getSearchTypePanel(int index) {
        assert (this.orderedSearchTypePanels != null);
        assert (index >= 1);
        return --index < this.orderedSearchTypePanels.size() ? this.orderedSearchTypePanels.get(index) : null;
    }

    private int getIndexOfSearchType(SearchType searchTypeToFind) {
        if (searchTypeToFind == null) {
            return -1;
        }
        int index = -1;
        for (SearchTypePanel searchTypePanel : this.orderedSearchTypePanels) {
            ++index;
            if (searchTypePanel.getSearchType().getClass() != searchTypeToFind.getClass()) continue;
            return index;
        }
        return -1;
    }
}

