/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectListColumnResolver;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;

public class ExpressionColumn
extends Expression {
    private Database database;
    private String schemaName;
    private String tableAlias;
    private String columnName;
    private ColumnResolver resolver;
    private int queryLevel;
    private Column column;
    private boolean evaluatable;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
    }

    public ExpressionColumn(Database database, String string, String string2, String string3) {
        this.database = database;
        this.schemaName = string;
        this.tableAlias = string2;
        this.columnName = string3;
    }

    public String getSQL() {
        String string = this.column != null ? this.column.getSQL() : this.columnName;
        if (this.tableAlias != null) {
            string = Parser.quoteIdentifier(this.tableAlias) + "." + string;
        }
        if (this.schemaName != null) {
            string = Parser.quoteIdentifier(this.schemaName) + "." + string;
        }
        return string;
    }

    public TableFilter getTableFilter() {
        return this.resolver == null ? null : this.resolver.getTableFilter();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        Column column;
        int n2;
        if (this.tableAlias != null && !this.tableAlias.equals(columnResolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.schemaName.equals(columnResolver.getSchemaName())) {
            return;
        }
        Column[] columnArray = columnResolver.getColumns();
        for (n2 = 0; n2 < columnArray.length; ++n2) {
            column = columnArray[n2];
            if (!this.columnName.equals(column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
        columnArray = columnResolver.getSystemColumns();
        for (n2 = 0; columnArray != null && n2 < columnArray.length; ++n2) {
            column = columnArray[n2];
            if (!this.columnName.equals(column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
    }

    private void mapColumn(ColumnResolver columnResolver, Column column, int n) throws SQLException {
        if (this.resolver == null) {
            this.queryLevel = n;
            this.column = column;
            this.resolver = columnResolver;
        } else if (this.queryLevel == n && this.resolver != columnResolver && !(columnResolver instanceof SelectListColumnResolver)) {
            throw Message.getSQLException(90059, this.columnName);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        if (this.resolver == null) {
            Object object;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (object = schema.findConstant(this.columnName)) != null) {
                return ((Constant)object).getValue();
            }
            object = this.columnName;
            if (this.tableAlias != null) {
                object = this.tableAlias + "." + (String)object;
                if (this.schemaName != null) {
                    object = this.schemaName + "." + (String)object;
                }
            }
            throw Message.getSQLException(42122, (String)object);
        }
        return this.resolver.optimize(this, this.column);
    }

    public void updateAggregate(Session session) throws SQLException {
        Value value = this.resolver.getValue(this.column);
        Select select = this.resolver.getSelect();
        if (select == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        HashMap hashMap = select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        Value value2 = (Value)hashMap.get(this);
        if (value2 == null) {
            hashMap.put(this, value);
        } else if (!this.database.areEqual(value, value2)) {
            throw Message.getSQLException(90016, this.getSQL());
        }
    }

    public Value getValue(Session session) throws SQLException {
        Value value;
        Object object;
        Select select = this.resolver.getSelect();
        if (select != null && (object = select.getCurrentGroup()) != null && (value = (Value)((HashMap)object).get(this)) != null) {
            return value;
        }
        object = this.resolver.getValue(this.column);
        if (object == null) {
            throw Message.getSQLException(90016, this.getSQL());
        }
        return object;
    }

    public int getType() {
        return this.column.getType();
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.resolver != null && tableFilter == this.resolver.getTableFilter()) {
            this.evaluatable = bl;
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public int getScale() {
        return this.column.getScale();
    }

    public long getPrecision() {
        return this.column.getPrecision();
    }

    public int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    public String getAlias() {
        return this.column == null ? null : this.column.getName();
    }

    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    public int getNullable() {
        return this.column.getNullable() ? 1 : 0;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return this.queryLevel < expressionVisitor.getQueryLevel();
            }
            case 3: {
                return this.evaluatable || expressionVisitor.getQueryLevel() < this.queryLevel;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.resolver != expressionVisitor.getResolver();
            }
            case 7: {
                expressionVisitor.addDependency(this.column.getTable());
                return true;
            }
        }
        throw Message.getInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 2;
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        TableFilter tableFilter2 = this.getTableFilter();
        if (tableFilter == tableFilter2 && this.column.getType() == 1) {
            IndexCondition indexCondition = new IndexCondition(0, this, ValueExpression.get(ValueBoolean.get(true)));
            tableFilter.addIndexCondition(indexCondition);
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }
}

