/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;

public class PropertiesPresenterForwarder
extends PropertiesPresenter {
    private String propertyName;
    private String[] propertyNames;

    public static Presenter createByReference(String propertyName) {
        return new PropertiesPresenterForwarder(propertyName, new String[0]);
    }

    public static Presenter createByNames(String propertyName, String ... propertyNames) {
        return new PropertiesPresenterForwarder(propertyName, propertyNames);
    }

    private PropertiesPresenterForwarder(String propertyName, String ... propertyNames) {
        this.propertyName = propertyName;
        this.propertyNames = propertyNames;
    }

    @Override
    public List<DesignPropertyDescriptor> getDesignPropertyDescriptors() {
        DesignComponent component = this.getComponent().readProperty(this.propertyName).getComponent();
        if (component == null) {
            return Collections.emptyList();
        }
        ArrayList<DesignPropertyDescriptor> descriptors = new ArrayList<DesignPropertyDescriptor>();
        Collection propertiesPresenters = component.getPresenters(PropertiesPresenter.class);
        if (propertiesPresenters == null) {
            return Collections.emptyList();
        }
        for (PropertiesPresenter presenter : propertiesPresenters) {
            descriptors.addAll(this.filterDescriptors(presenter.getDesignPropertyDescriptors()));
        }
        return descriptors;
    }

    @Override
    public List<String> getPropertiesCategories() {
        DesignComponent component = this.getComponent().readProperty(this.propertyName).getComponent();
        if (component == null) {
            return Collections.emptyList();
        }
        ArrayList<String> categories = new ArrayList<String>();
        for (PropertiesPresenter presenter : component.getPresenters(PropertiesPresenter.class)) {
            categories.addAll(presenter.getPropertiesCategories());
        }
        return categories;
    }

    private List<DesignPropertyDescriptor> filterDescriptors(List<DesignPropertyDescriptor> descriptors) {
        if (this.propertyNames == null || this.propertyNames.length == 0) {
            return descriptors;
        }
        ArrayList<DesignPropertyDescriptor> list = new ArrayList<DesignPropertyDescriptor>(descriptors.size());
        for (DesignPropertyDescriptor designPropertyDescriptor : descriptors) {
            for (String name : this.propertyNames) {
                if (!designPropertyDescriptor.getPropertyNames().contains(name)) continue;
                list.add(designPropertyDescriptor);
            }
        }
        return list;
    }

    protected void notifyDetached(DesignComponent component) {
    }

    protected DesignEventFilter getEventFilter() {
        return null;
    }

    protected void designChanged(DesignEvent event) {
    }

    protected void presenterChanged(PresenterEvent event) {
    }

    protected void notifyAttached(DesignComponent component) {
    }
}

